/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.syscontext;

import com.jeecms.exception.GlobalException;
import com.jeecms.utils.syscontext.BaseSysConf;
import com.jeecms.utils.syscontext.BaseSysUtilDelegate;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseSysUtil {
    private static final Logger log = LoggerFactory.getLogger(BaseSysUtil.class);
    protected static BaseSysUtilDelegate delegate;
    protected static final String IDENTITY;

    protected BaseSysUtil() {
    }

    protected static void setDelegate(BaseSysUtilDelegate delegate) {
        BaseSysUtil.delegate = delegate;
    }

    public static long currUserId() {
        return delegate.currUserId();
    }

    public static long currClientUserId() {
        return delegate.currClientUserId();
    }

    public static long currClientUserId(long currSiteId) {
        return delegate.currClientUserId(currSiteId);
    }

    public static Long currUserIdMayNull() {
        try {
            return BaseSysUtil.currUserId();
        }
        catch (Exception e) {
            log.debug("\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u5931\u8d25\u6216\u5f53\u524d\u7528\u6237\u672a\u767b\u5f55");
            return null;
        }
    }

    public static String currClientId() {
        return delegate.currClientId();
    }

    public static String currUsername() {
        return delegate.currUsername();
    }

    public static String currUsernameThrowExp() throws GlobalException {
        return delegate.currUsernameThrowExp();
    }

    public static List currRoles() {
        return delegate.currRoles();
    }

    public static BaseSysConf getSysConfig() {
        return delegate.getSysConfig();
    }

    public static String getIdentity() {
        return IDENTITY;
    }

    protected static long getDatacenterId(long maxDatacenterId) {
        long id = 0L;
        try {
            InetAddress ip = InetAddress.getLocalHost();
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            if (network == null) {
                id = 1L;
            } else {
                byte[] mac = network.getHardwareAddress();
                if (null != mac) {
                    id = (0xFFL & (long)mac[mac.length - 2] | 0xFF00L & (long)mac[mac.length - 1] << 8) >> 6;
                    id %= maxDatacenterId + 1L;
                }
            }
        }
        catch (Exception e) {
            log.error(" getDatacenterId: " + e.getMessage());
        }
        return id;
    }

    protected static long genIdentity() {
        long maxWorkerId = 65535L;
        long maxDatacenterId = 65535L;
        long datacenterId = BaseSysUtil.getDatacenterId(maxDatacenterId);
        long workerId = BaseSysUtil.getMaxWorkerId(datacenterId, maxWorkerId);
        long identity = datacenterId << 16 | workerId;
        return identity;
    }

    protected static long getMaxWorkerId(long datacenterId, long maxWorkerId) {
        StringBuilder mpid = new StringBuilder();
        mpid.append(datacenterId);
        String name = ManagementFactory.getRuntimeMXBean().getName();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            mpid.append(name.split("@")[0]);
        }
        return (long)(mpid.toString().hashCode() & 0xFFFF) % (maxWorkerId + 1L);
    }

    public static boolean isAdminUser() {
        return "jeecms_manager".equals(BaseSysUtil.currClientId());
    }

    public static boolean isClientUser() {
        return "jeecms_tenant".equals(BaseSysUtil.currClientId());
    }

    static {
        IDENTITY = Long.toHexString(BaseSysUtil.genIdentity());
        BaseSysUtil.setDelegate(new BaseSysUtilDelegate());
    }
}

