/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.spring;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.extra.servlet.ServletUtil;
import com.jeecms.utils.URLUtil;
import com.jeecms.utils.spring.SpringUtil;
import com.jeecms.utils.token.TokenUtil;
import java.io.BufferedReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.mobile.device.Device;
import org.springframework.mobile.device.DeviceUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.AbstractHandlerMethodMapping;
import org.springframework.web.servlet.handler.AbstractUrlHandlerMapping;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

@Component
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class WebUtil {
    private static final Logger log = LoggerFactory.getLogger(WebUtil.class);
    private static HttpServletResponse RESPONSE;
    private static HttpServletRequest REQUEST;
    public static final int PORT_DEF = 80;
    private static final String CURR_MAPPING_PATH_ATTRIBUTE_NAME = "currMappingPath";

    @Autowired
    private void init(HttpServletRequest request, HttpServletResponse response) {
        REQUEST = request;
        RESPONSE = response;
    }

    public static String getMethod(HttpServletRequest request) {
        return request.getMethod().toUpperCase();
    }

    public static HttpServletRequest getRequest() {
        return REQUEST;
    }

    public static HttpServletResponse getResponse() {
        return RESPONSE;
    }

    public static String currContextPath() {
        return WebUtil.getRequest().getContextPath();
    }

    public static void setAttribute(String name, Object obj) {
        WebUtil.getRequest().setAttribute(name, obj);
    }

    public static <T> T getAttribute(String name) {
        return (T)WebUtil.getRequest().getAttribute(name);
    }

    public static <T> T getAttribute(String name, Function<String, T> defaultValFunc) {
        T attribute = WebUtil.getAttribute(name);
        if (attribute == null) {
            attribute = defaultValFunc.apply(name);
            WebUtil.setAttribute(name, attribute);
        }
        return attribute;
    }

    public static String currMappingPath() {
        return WebUtil.getMappingPath(WebUtil.getRequest());
    }

    public static String getMappingPath(HttpServletRequest request) {
        String attribute = (String)request.getAttribute(CURR_MAPPING_PATH_ATTRIBUTE_NAME);
        if (StringUtils.isBlank((CharSequence)attribute)) {
            DispatcherServlet dispatcherServlet;
            List handlerMappings;
            String mappingPattern = null;
            Map<String, DispatcherServlet> dispatcherServletMap = SpringUtil.getBeansOfType(DispatcherServlet.class);
            Iterator<DispatcherServlet> iterator = dispatcherServletMap.values().iterator();
            while (iterator.hasNext() && (mappingPattern = WebUtil.fetchMappingPattern(handlerMappings = (dispatcherServlet = iterator.next()).getHandlerMappings(), request)) == null) {
            }
            if (mappingPattern == null) {
                mappingPattern = WebUtil.currServletPath();
            }
            mappingPattern = mappingPattern.replaceAll("(?<=\\{)(.*?):.*?(?=})", "$1");
            request.setAttribute(CURR_MAPPING_PATH_ATTRIBUTE_NAME, (Object)mappingPattern);
            attribute = mappingPattern;
        }
        return attribute;
    }

    public static String getModuleMappingPath(HttpServletRequest request) {
        return WebUtil.currModulePrefix() + WebUtil.getMappingPath(request);
    }

    public static String currModuleMappingPath() {
        return WebUtil.currModulePrefix() + WebUtil.currMappingPath();
    }

    private static String fetchMappingPattern(List<HandlerMapping> handlerMappings, HttpServletRequest request) {
        for (HandlerMapping handlerMapping : handlerMappings) {
            try {
                String lookupPath;
                if (handlerMapping instanceof AbstractHandlerMethodMapping) {
                    AbstractHandlerMethodMapping ahm = (AbstractHandlerMethodMapping)handlerMapping;
                    lookupPath = ahm.getUrlPathHelper().getLookupPathForRequest(request);
                    Object mappingRegistry = ReflectUtil.invoke((Object)ahm, (String)"getMappingRegistry", (Object[])new Object[0]);
                    List mappingInfos = (List)ReflectUtil.invoke((Object)mappingRegistry, (String)"getMappingsByUrl", (Object[])new Object[]{lookupPath});
                    if (mappingInfos == null) {
                        Map mappings = (Map)ReflectUtil.invoke((Object)mappingRegistry, (String)"getMappings", (Object[])new Object[0]);
                        Set requestMappingInfos = mappings.keySet();
                        Iterator iterator = requestMappingInfos.iterator();
                        while (iterator.hasNext()) {
                            RequestMappingInfo mappingInfo = ((RequestMappingInfo)iterator.next()).getMatchingCondition(request);
                            String pattern = WebUtil.fetchPatternFromRequestMappingInfo(mappingInfo);
                            if (pattern == null) continue;
                            return pattern;
                        }
                    }
                    if (mappingInfos == null) continue;
                    for (RequestMappingInfo mappingInfo : mappingInfos) {
                        String pattern = WebUtil.fetchPatternFromRequestMappingInfo(mappingInfo);
                        if (pattern == null) continue;
                        return pattern;
                    }
                    continue;
                }
                if (!(handlerMapping instanceof AbstractUrlHandlerMapping)) continue;
                AbstractUrlHandlerMapping urlHandlerMapping = (AbstractUrlHandlerMapping)handlerMapping;
                lookupPath = urlHandlerMapping.getUrlPathHelper().getLookupPathForRequest(request);
                if (urlHandlerMapping.getHandlerMap().containsKey(lookupPath)) {
                    return lookupPath;
                }
                for (String registeredPattern : urlHandlerMapping.getHandlerMap().keySet()) {
                    if (urlHandlerMapping.getPathMatcher().match(registeredPattern, lookupPath)) {
                        return registeredPattern;
                    }
                    if (!urlHandlerMapping.useTrailingSlashMatch() || registeredPattern.endsWith("/") || !urlHandlerMapping.getPathMatcher().match(registeredPattern + "/", lookupPath)) continue;
                    return registeredPattern;
                }
            }
            catch (Throwable throwable) {
            }
        }
        return null;
    }

    private static String fetchPatternFromRequestMappingInfo(RequestMappingInfo requestMappingInfo) {
        Set patterns = Optional.ofNullable(requestMappingInfo).map(RequestMappingInfo::getPatternsCondition).map(PatternsRequestCondition::getPatterns).orElse(Collections.emptySet());
        Iterator iterator = patterns.iterator();
        if (iterator.hasNext()) {
            return (String)iterator.next();
        }
        return null;
    }

    public static String currServletPath() {
        String servletPath = WebUtil.getRequest().getServletPath();
        return servletPath;
    }

    public static String currModulePath() {
        return WebUtil.currModulePrefix() + WebUtil.currServletPath();
    }

    public static String currModulePrefix() {
        return "/" + SpringUtil.getApplicationName();
    }

    public static String currMethod() {
        return WebUtil.getMethod(WebUtil.getRequest());
    }

    public static String currToken() {
        return WebUtil.getToken(WebUtil.getRequest());
    }

    public static String currClientId() {
        return WebUtil.getClientId(WebUtil.getRequest());
    }

    public static String getCoreUsername() {
        return WebUtil.getCoreUsername(WebUtil.getRequest());
    }

    public static String getClientId(HttpServletRequest request) {
        return WebUtil.getClientId(WebUtil.getToken(request));
    }

    public static String getCoreUsername(HttpServletRequest request) {
        return WebUtil.getCoreUsername(WebUtil.getToken(request));
    }

    public static String getClientId(String token) {
        return TokenUtil.getClientId(token);
    }

    public static String getCoreUsername(String token) {
        return TokenUtil.getUsername(token);
    }

    public static String getToken(HttpServletRequest request) {
        String authorization = request.getHeader("Authorization");
        String authToken = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)authorization)) {
                authToken = TokenUtil.getTokenFromAuthorization(authorization);
            } else {
                String accessToken = request.getParameter("access_token");
                if (StringUtils.isNotBlank((CharSequence)accessToken)) {
                    authToken = accessToken;
                }
            }
        }
        catch (Exception e) {
            log.debug("\u4ece\u8bf7\u6c42\u4e2d\u53d6token\u5931\u8d25", (Throwable)e);
        }
        return authToken;
    }

    public static String currRequestBody() {
        return WebUtil.fetchRequestBody(WebUtil.getRequest());
    }

    public static String fetchRequestBody(HttpServletRequest request) {
        String body = null;
        try {
            BufferedReader bufferedReader = request.getReader();
            body = IoUtil.read((Reader)bufferedReader);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return body;
    }

    public static void print() {
        try {
            HttpServletRequest request = WebUtil.getRequest();
            System.out.println("URL: " + request.getRequestURL());
            System.out.println("QUERY: " + request.getQueryString());
            System.out.println("BODY: " + IoUtil.read((Reader)request.getReader()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getClientIP() {
        return WebUtil.getClientIP(WebUtil.getRequest());
    }

    public static String getClientIP(HttpServletRequest request) {
        return ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]);
    }

    public static Map<String, String> getHeaderMap(HttpServletRequest request) {
        return ServletUtil.getHeaderMap((HttpServletRequest)request);
    }

    public static String getHeaderIgnoreCase(HttpServletRequest request, String nameIgnoreCase) {
        return ServletUtil.getHeaderIgnoreCase((HttpServletRequest)request, (String)nameIgnoreCase);
    }

    public static String getHeader(HttpServletRequest request, String name, String charsetName) {
        return WebUtil.getHeader(request, name, CharsetUtil.charset((String)charsetName));
    }

    public static String getHeader(HttpServletRequest request, String name, Charset charset) {
        return ServletUtil.getHeader((HttpServletRequest)request, (String)name, (Charset)charset);
    }

    public static String getHeader(HttpServletRequest request, String name) {
        return ServletUtil.getHeader((HttpServletRequest)request, (String)name, (Charset)StandardCharsets.UTF_8);
    }

    public static String getHeader(String name) {
        return ServletUtil.getHeader((HttpServletRequest)WebUtil.getRequest(), (String)name, (Charset)StandardCharsets.UTF_8);
    }

    public static String getHeaderIgnoreCase(String nameIgnoreCase) {
        return ServletUtil.getHeaderIgnoreCase((HttpServletRequest)WebUtil.getRequest(), (String)nameIgnoreCase);
    }

    public static Map<String, String> getHeaderMap() {
        return ServletUtil.getHeaderMap((HttpServletRequest)WebUtil.getRequest());
    }

    public static String getHeader(String name, String charsetName) {
        return WebUtil.getHeader(WebUtil.getRequest(), name, CharsetUtil.charset((String)charsetName));
    }

    public static String getHeader(String name, Charset charset) {
        return ServletUtil.getHeader((HttpServletRequest)WebUtil.getRequest(), (String)name, (Charset)charset);
    }

    public static boolean isIE(HttpServletRequest request) {
        return ServletUtil.isIE((HttpServletRequest)request);
    }

    public static boolean isGetMethod(HttpServletRequest request) {
        return ServletUtil.isGetMethod((HttpServletRequest)request);
    }

    public static boolean isPostMethod(HttpServletRequest request) {
        return ServletUtil.isPostMethod((HttpServletRequest)request);
    }

    public static boolean isMultipart(HttpServletRequest request) {
        return ServletUtil.isMultipart((HttpServletRequest)request);
    }

    public static boolean isIE() {
        return ServletUtil.isIE((HttpServletRequest)WebUtil.getRequest());
    }

    public static boolean isGetMethod() {
        return ServletUtil.isGetMethod((HttpServletRequest)WebUtil.getRequest());
    }

    public static boolean isPostMethod() {
        return ServletUtil.isPostMethod((HttpServletRequest)WebUtil.getRequest());
    }

    public static boolean isMultipart() {
        return ServletUtil.isMultipart((HttpServletRequest)WebUtil.getRequest());
    }

    public static void addCookie(String key, String value) {
        WebUtil.addCookie(key, value, "/");
    }

    public static void addCookie(String key, String value, String path) {
        WebUtil.addCookie(key, value, path, null);
    }

    public static void addCookie(String key, String value, String path, Integer maxAge) {
        Cookie cookie = new Cookie(key, value);
        cookie.setPath(path);
        if (maxAge != null) {
            cookie.setMaxAge(maxAge.intValue());
        }
        WebUtil.addCookie(cookie);
    }

    public static void addCookie(String key, String value, Integer maxAge) {
        WebUtil.addCookie(key, value, "/", maxAge);
    }

    public static void addCookie(String key, String value, Duration duration) {
        Integer maxAge = duration == null ? null : Integer.valueOf((int)(duration.toMillis() / 1000L));
        WebUtil.addCookie(key, value, "/", maxAge);
    }

    public static void addCookie(Cookie cookie) {
        if (StringUtils.isBlank((CharSequence)cookie.getPath())) {
            cookie.setPath("/");
        }
        WebUtil.getResponse().addCookie(cookie);
    }

    public static String getCookie(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        Cookie[] cookies = WebUtil.getRequest().getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(key)) continue;
            return cookie.getValue();
        }
        return null;
    }

    public static void delCookie(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        Cookie[] cookies = WebUtil.getRequest().getCookies();
        if (cookies == null) {
            return;
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(key)) continue;
            cookie.setMaxAge(0);
            cookie.setValue(null);
            WebUtil.addCookie(cookie);
            return;
        }
    }

    public static String getRequestString(HttpServletRequest req) {
        return Stream.of(req.getServletPath(), req.getQueryString()).filter(Objects::nonNull).collect(Collectors.joining("?"));
    }

    public static String currRequestString() {
        return WebUtil.getRequestString(WebUtil.getRequest());
    }

    public static Map<String, Object> getQueryParams() {
        Map<String, String[]> map;
        HttpServletRequest request = WebUtil.getRequest();
        if (request.getMethod().equalsIgnoreCase("POST")) {
            map = request.getParameterMap();
        } else {
            String s = request.getQueryString();
            if (StringUtils.isBlank((CharSequence)s)) {
                return new HashMap<String, Object>(5);
            }
            try {
                s = s.replaceAll("%(?![0-9a-fA-F]{2})", "%25");
                s = s.replaceAll("\\+", "%2B");
                s = URLDecoder.decode(s, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                s = request.getQueryString();
            }
            map = WebUtil.parseQueryString(s);
        }
        HashMap<String, Object> params = new HashMap<String, Object>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            int len = ((String[])entry.getValue()).length;
            if (len == 1) {
                params.put((String)entry.getKey(), ((String[])entry.getValue())[0]);
                continue;
            }
            if (len <= 1) continue;
            params.put((String)entry.getKey(), entry.getValue());
        }
        return params;
    }

    public static String createSignStr(Map<String, Object> param) {
        List<Object> list = new ArrayList<String>(param.keySet());
        Object[] ary = list.toArray();
        Arrays.sort(ary);
        list = Arrays.asList(ary);
        String str = "";
        StringJoiner joiner = new StringJoiner("&");
        for (int i = 0; i < list.size(); ++i) {
            joiner.add(list.get(i) + "=" + param.get(list.get(i)));
        }
        log.info("sign str=" + str);
        return joiner.toString();
    }

    public static void setDownloadHeader(HttpServletResponse response, String filename) {
        response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
    }

    public static Map<String, String[]> parseQueryString(String queryString) {
        if (StringUtils.isBlank((CharSequence)queryString)) {
            return Collections.emptyMap();
        }
        TreeMap<String, String[]> queryMap = new TreeMap<String, String[]>();
        String[] params = queryString.indexOf("&amp;") != -1 ? queryString.split("&amp;") : queryString.split("&");
        for (String param : params) {
            String name;
            int index = param.indexOf(61);
            if (index == -1 || StringUtils.isBlank((CharSequence)(name = param.substring(0, index)))) continue;
            String value = param.substring(index + 1);
            try {
                value = value.replaceAll("%(?![0-9a-fA-F]{2})", "%25");
                value = value.replaceAll("\\+", "%2B");
                value = URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error("never!", (Throwable)e);
            }
            if (queryMap.containsKey(name)) {
                Object[] values = (String[])queryMap.get(name);
                queryMap.put(name, (String[])ArrayUtils.addAll((Object[])values, (Object[])new String[]{value}));
                continue;
            }
            queryMap.put(name, new String[]{value});
        }
        return queryMap;
    }

    public static String getServerUrl(HttpServletRequest request) {
        String agreement = request.getScheme();
        String serverName = request.getServerName();
        int port = request.getServerPort();
        String contextPath = request.getContextPath();
        String url = "%s://%s%s%s";
        String portStr = "";
        if (port != 80) {
            portStr = portStr + ":" + port;
        }
        return String.format(url, agreement, serverName, portStr, contextPath);
    }

    public static String getReferer(HttpServletRequest request) {
        return WebUtil.getHeader(request, "Referer");
    }

    public static String currReferer() {
        return WebUtil.getReferer(WebUtil.getRequest());
    }

    public static String getAccessHost(HttpServletRequest request) {
        String tmp = WebUtil.getHeader("origin");
        if (StringUtils.isNotBlank((CharSequence)tmp)) {
            return tmp;
        }
        tmp = WebUtil.getReferer(request);
        if (StringUtils.isNotBlank((CharSequence)tmp)) {
            URL url = URLUtil.url((String)WebUtil.getReferer(request));
            String accessHost = url.getProtocol() + "://" + url.getHost();
            if (url.getPort() > 0 && url.getPort() != url.getDefaultPort()) {
                accessHost = accessHost + ":" + url.getPort();
            }
            return accessHost;
        }
        tmp = WebUtil.getHeader("host");
        if (StringUtils.isNotBlank((CharSequence)tmp)) {
            return request.getScheme() + "://" + tmp;
        }
        int port = request.getServerPort();
        String portStr = !request.isSecure() && port == 80 || request.isSecure() && port == 443 ? "" : ":" + port;
        return String.format("%s://%s%s", request.getScheme(), request.getServerName(), portStr);
    }

    public static String getAccessDomain(HttpServletRequest request) {
        String tmp = WebUtil.getHeader("origin");
        if (StringUtils.isNotBlank((CharSequence)tmp)) {
            return tmp;
        }
        tmp = WebUtil.getReferer(request);
        if (StringUtils.isNotBlank((CharSequence)tmp)) {
            URL url = URLUtil.url((String)WebUtil.getReferer(request));
            return url.getHost();
        }
        tmp = WebUtil.getHeader("host");
        if (StringUtils.isNotBlank((CharSequence)tmp)) {
            return tmp;
        }
        return request.getServerName();
    }

    public static String currAccessHost() {
        return WebUtil.getAccessHost(WebUtil.getRequest());
    }

    public static String currAccessDomain() {
        return WebUtil.getAccessDomain(WebUtil.getRequest());
    }

    public static String getParam(HttpServletRequest request, String name) {
        Object[] values = WebUtil.getParamValues(request, name);
        return ArrayUtils.isNotEmpty((Object[])values) ? StringUtils.join((Object[])values, (char)',') : null;
    }

    public static String[] getParamValues(HttpServletRequest request, String name) {
        Validate.notNull((Object)request, (String)"Request must not be null", (Object[])new Object[0]);
        String qs = request.getQueryString();
        Map<String, String[]> queryMap = WebUtil.parseQueryString(qs);
        return WebUtil.getParamValues(request, queryMap, name);
    }

    public static String[] getParamValues(HttpServletRequest request, Map<String, String[]> queryMap, String name) {
        Validate.notNull((Object)request, (String)"Request must not be null", (Object[])new Object[0]);
        String[] values = queryMap.get(name);
        if (values == null) {
            values = request.getParameterValues(name);
        }
        return values;
    }

    public static Device currDevice() {
        Device currentDevice = DeviceUtils.getRequiredCurrentDevice((HttpServletRequest)WebUtil.getRequest());
        return currentDevice;
    }

    public static boolean isPcWeb() {
        return false;
    }

    public static boolean isH5() {
        return false;
    }

    public static boolean isPc() {
        return WebUtil.currDevice().isNormal();
    }

    public static boolean isTablet() {
        return WebUtil.currDevice().isTablet();
    }

    public static boolean isMobile() {
        return WebUtil.currDevice().isMobile();
    }

    public static boolean isValidRequestUri(String url) {
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            if (WebUtil.hasSpecialChar(url)) {
                return true;
            }
            try {
                try {
                    url = url.replaceAll("%(?![0-9a-fA-F]{2})", "%25");
                    url = url.replaceAll("\\+", "%2B");
                    url = URLDecoder.decode(url, "utf-8");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                url = url.replaceAll("%(?![0-9a-fA-F]{2})", "%25");
                url = url.replaceAll("\\+", "%2B");
                url = URLDecoder.decode(url, "UTF-8");
                if (WebUtil.hasSpecialChar(url)) {
                    return true;
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private static boolean hasSpecialChar(String a) {
        return a.contains(" and ") || a.contains(" or ") || a.contains("1=1");
    }
}

