/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.spring;

import cn.hutool.core.util.ClassUtil;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.system.ApplicationHome;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class SpringUtil
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SpringUtil.class);
    private static ApplicationContext applicationContext;
    private static String applicationName;
    private static volatile String appHome;
    private static final Object appHomeLock;
    private static Class<?> cls;

    @Autowired
    private void init(@Value(value="${spring.application.name}") String applicationName) {
        SpringUtil.applicationName = applicationName.toLowerCase();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext.getParent() == SpringUtil.applicationContext || SpringUtil.applicationContext == null) {
            SpringUtil.applicationContext = applicationContext;
        }
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static <T> T getBean(Class<T> requiredType) throws BeansException {
        return (T)SpringUtil.getApplicationContext().getBean(requiredType);
    }

    public static <T> Map<String, T> getBeansOfType(@Nullable Class<T> type) throws BeansException {
        return SpringUtil.getApplicationContext().getBeansOfType(type);
    }

    public static Object getBean(String name) throws BeansException {
        return SpringUtil.getApplicationContext().getBean(name);
    }

    public static Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> annotationType) {
        Map beansWithAnnotation = SpringUtil.getApplicationContext().getBeansWithAnnotation(annotationType);
        return beansWithAnnotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String appHome() {
        if (appHome == null) {
            Object object = appHomeLock;
            synchronized (object) {
                if (appHome == null) {
                    appHome = new ApplicationHome().getDir().getAbsolutePath() + File.separator;
                }
            }
        }
        return appHome;
    }

    public static void publishEvent(ApplicationEvent event) {
        SpringUtil.getApplicationContext().publishEvent(event);
    }

    public static String getApplicationName() {
        return applicationName;
    }

    public static RestTemplate getLoadBalancedRestTemplate() {
        return (RestTemplate)SpringUtil.getBean("loadBalancedRestTemplate");
    }

    static {
        appHomeLock = new Object();
        cls = ClassUtil.loadClass((String)"com.jeecms.utils.ReflectUtil.ClassLoader");
    }
}

