/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.social;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.jeecms.utils.social.SocialPlatform;
import com.jeecms.utils.social.SocialUserInfo;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocialUtil {
    private static final String WEIXIN_ACCESS_TOKEN_URL = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=%s&secret=%s&code=%s&grant_type=authorization_code";
    private static final String WEIXIN_USER_INFO_URL = "https://api.weixin.qq.com/sns/userinfo?access_token=%s&openid=%s";
    private static final String WEIXIN_OPEN_ACCESS_TOKEN_URL = "https://api.weixin.qq.com/sns/oauth2/component/access_token?appid=%s&code=%s&grant_type=authorization_code&component_appid=%s&component_access_token=%s";
    private static final String QQ_ACCESS_TOKEN_URL = "https://graph.qq.com/oauth2.0/token?grant_type=authorization_code&client_id=%s&client_secret=%s&code=%s&redirect_uri=%s&fmt=json";
    private static final String QQ_OPEN_ID_URL = "https://graph.qq.com/oauth2.0/me?access_token=%s&fmt=json";
    private static final String QQ_USER_INFO_URL = "https://graph.qq.com/user/get_user_info?access_token=%s&oauth_consumer_key=%s&openid=%s";
    private static final String WEIBO_ACCESS_TOKEN_URL = "https://api.weibo.com/oauth2/access_token?client_id=%s&client_secret=%s&grant_type=authorization_code&redirect_uri=%s&code=%s";
    private static final String WEIBO_USER_IFNO_URL = "https://api.weibo.com/2/users/show.json?access_token=%s&uid=%s";
    private static Logger log = LoggerFactory.getLogger(SocialUtil.class);

    public static SocialUserInfo getWeiXinUid(String appid, String appSecret, String code) {
        Map accessTokenMap;
        String accessTokenRet;
        try {
            String accessTokenUrl = String.format(WEIXIN_ACCESS_TOKEN_URL, appid, appSecret, code);
            accessTokenRet = HttpUtil.get((String)accessTokenUrl);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5fae\u4fe1\u7528\u6237token\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u83b7\u53d6\u5fae\u4fe1\u7528\u6237token\u5931\u8d25", e);
        }
        try {
            accessTokenMap = (Map)JSONObject.parseObject((String)accessTokenRet, HashMap.class);
        }
        catch (Exception e) {
            log.error("\u89e3\u6790json\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u89e3\u6790json\u5931\u8d25", e);
        }
        if (accessTokenMap.containsKey("errcode")) {
            log.error("\u83b7\u53d6\u5fae\u4fe1\u7528\u6237\u552f\u4e00id\u5931\u8d25: errcode: [{}], errmsg: [{}]", accessTokenMap.get("errcode"), accessTokenMap.get("errmsg"));
            throw new RuntimeException(accessTokenMap.get("errmsg").toString());
        }
        accessTokenMap.put("appid", appid);
        SocialUserInfo socialUserInfo = SocialUtil.parseMapToSocialUserInfo(SocialPlatform.WeiXin, accessTokenMap);
        return socialUserInfo;
    }

    public static SocialUserInfo getWeiXinUid(String appid, String code, String componentAppId, String componentAccessToken) {
        Map accessTokenMap;
        String accessTokenRet;
        try {
            String accessTokenUrl = String.format(WEIXIN_OPEN_ACCESS_TOKEN_URL, appid, code, componentAppId, componentAccessToken);
            accessTokenRet = HttpUtil.get((String)accessTokenUrl);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5fae\u4fe1\u7528\u6237token\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u83b7\u53d6\u5fae\u4fe1\u7528\u6237token\u5931\u8d25", e);
        }
        try {
            accessTokenMap = (Map)JSONObject.parseObject((String)accessTokenRet, HashMap.class);
        }
        catch (Exception e) {
            log.error("\u89e3\u6790json\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u89e3\u6790json\u5931\u8d25", e);
        }
        if (accessTokenMap.containsKey("errcode")) {
            log.error("\u83b7\u53d6\u5fae\u4fe1\u7528\u6237\u552f\u4e00id\u5931\u8d25: errcode: [{}], errmsg: [{}]", accessTokenMap.get("errcode"), accessTokenMap.get("errmsg"));
            throw new RuntimeException(accessTokenMap.get("errmsg").toString());
        }
        accessTokenMap.put("appid", appid);
        SocialUserInfo socialUserInfo = SocialUtil.parseMapToSocialUserInfo(SocialPlatform.WeiXin, accessTokenMap);
        return socialUserInfo;
    }

    public static SocialUserInfo getWeiXinUserInfo(String appid, String appSecret, String code) {
        SocialUserInfo userInfo = SocialUtil.getWeiXinUid(appid, appSecret, code);
        SocialUtil.getWeiXinUserInfo(userInfo);
        return userInfo;
    }

    public static SocialUserInfo getWeiXinUserInfo(String appid, String code, String componentAppId, String componentAccessToken) {
        SocialUserInfo userInfo = SocialUtil.getWeiXinUid(appid, code, componentAppId, componentAccessToken);
        userInfo = SocialUtil.getWeiXinUserInfo(userInfo);
        return userInfo;
    }

    private static SocialUserInfo getWeiXinUserInfo(SocialUserInfo userInfo) {
        if (StringUtils.isNotBlank((CharSequence)userInfo.getOpenId())) {
            String userInfoUrl = String.format(WEIXIN_USER_INFO_URL, userInfo.getAccessToken(), userInfo.getOpenId());
            String userInfoRet = HttpUtil.get((String)userInfoUrl);
            Map userInfoMap = (Map)JSONObject.parseObject((String)userInfoRet, HashMap.class);
            System.out.println("\u5fae\u4fe1\u7528\u6237\u4fe1\u606f ~~~~~~~~~~~~~~~~~~~" + userInfoMap.toString());
            if (userInfoMap.containsKey("errcode")) {
                throw new RuntimeException(userInfoMap.get("errmsg").toString());
            }
            userInfo.setSocialNickname(userInfoMap.get("nickname").toString());
            Integer gender = (Integer)userInfoMap.get("sex");
            if (gender != 1 && gender != 2) {
                gender = 3;
            }
            userInfo.setUid(userInfoMap.containsKey("unionid") ? userInfoMap.get("unionid").toString() : null);
            userInfo.setGender(gender);
            userInfo.setHeadImg(userInfoMap.get("headimgurl").toString());
            return userInfo;
        }
        return userInfo;
    }

    public static SocialUserInfo getQqUid(String appid, String secret, String code, String redirectUri) {
        Map openIdMap;
        String openIdRet;
        Map accessTokenMap;
        String accessTokenRet;
        try {
            String accessTokenUrl = String.format(QQ_ACCESS_TOKEN_URL, appid, secret, code, redirectUri);
            accessTokenRet = HttpUtil.get((String)accessTokenUrl);
        }
        catch (Exception e) {
            log.debug("\u83b7\u53d6QQ TOKEN\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u83b7\u53d6QQ TOKEN\u5931\u8d25", e);
        }
        try {
            accessTokenMap = (Map)JSONObject.parseObject((String)accessTokenRet, HashMap.class);
        }
        catch (Exception e) {
            log.error("\u89e3\u6790json\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u4fe1\u606f", e);
        }
        if (accessTokenMap.containsKey("error")) {
            log.debug("\u83b7\u53d6QQ token\u5931\u8d25: error: [{}], error_description: [{}]", accessTokenMap.get("error"), accessTokenMap.get("error_description"));
            throw new RuntimeException((String)accessTokenMap.get("error_description"));
        }
        String accessToken = (String)accessTokenMap.get("access_token");
        try {
            String qqOpenIdUrl = String.format(QQ_OPEN_ID_URL, accessToken);
            openIdRet = HttpUtil.get((String)qqOpenIdUrl);
        }
        catch (Exception e) {
            log.debug("\u83b7\u53d6QQ openid \u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u83b7\u53d6QQ openid \u5931\u8d25", e);
        }
        try {
            openIdMap = (Map)JSONObject.parseObject((String)openIdRet, HashMap.class);
        }
        catch (Exception e) {
            log.error("\u89e3\u6790json\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u89e3\u6790json\u5931\u8d25", e);
        }
        if (accessTokenMap.containsKey("error")) {
            log.error("\u83b7\u53d6QQ\u7528\u6237\u552f\u4e00id\u5931\u8d25: error: [{}], error_description: [{}]", accessTokenMap.get("error"), accessTokenMap.get("error_description"));
            throw new RuntimeException((String)accessTokenMap.get("error_description"));
        }
        openIdMap.putAll(accessTokenMap);
        openIdMap.put("appid", appid);
        SocialUserInfo socialUserInfo = SocialUtil.parseMapToSocialUserInfo(SocialPlatform.QQ, openIdMap);
        return socialUserInfo;
    }

    public static SocialUserInfo getQqUserInfo(String appid, String secret, String code, String redirectUri) {
        SocialUserInfo userInfo = SocialUtil.getQqUid(appid, secret, code, redirectUri);
        String userInfoUrl = String.format(QQ_USER_INFO_URL, userInfo.getAccessToken(), appid, userInfo.getUid());
        String userInfoRet = HttpUtil.get((String)userInfoUrl);
        Map userInfoMap = (Map)JSONObject.parseObject((String)userInfoRet, HashMap.class);
        if ((Integer)userInfoMap.get("ret") != 0) {
            throw new RuntimeException(userInfoMap.get("msg").toString());
        }
        userInfo.setSocialNickname(userInfoMap.get("nickname").toString());
        userInfo.setHeadImg(userInfoMap.get("figureurl_qq").toString());
        if ("\u7537".equals(userInfoMap.get("gender"))) {
            userInfo.setGender(1);
        } else if ("\u5973".equals(userInfoMap.get("gender"))) {
            userInfo.setGender(2);
        } else {
            userInfo.setGender(3);
        }
        return userInfo;
    }

    public static SocialUserInfo getWeiBoUid(String appid, String appSecret, String code, String redirectUri) {
        Map accessTokenMap;
        String accessTokenRet;
        try {
            String accessTokenUrl = String.format(WEIBO_ACCESS_TOKEN_URL, appid, appSecret, redirectUri, code);
            accessTokenRet = HttpUtil.post((String)accessTokenUrl, (String)"");
        }
        catch (Exception e) {
            log.debug("\u83b7\u53d6\u5fae\u535aTOKEN\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u83b7\u53d6\u5fae\u535aTOKEN\u5931\u8d25", e);
        }
        try {
            accessTokenMap = (Map)JSONObject.parseObject((String)accessTokenRet, HashMap.class);
        }
        catch (Exception e) {
            log.debug("\u89e3\u6790json\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u89e3\u6790json\u5931\u8d25", e);
        }
        if (accessTokenMap.containsKey("error")) {
            log.error("\u83b7\u53d6\u5fae\u535a\u7528\u6237\u552f\u4e00id\u5931\u8d25: errcode: [{}], errmsg: [{}]", accessTokenMap.get("error_code"), accessTokenMap.get("error_description"));
            throw new RuntimeException("\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u4fe1\u606f");
        }
        accessTokenMap.put("appid", appid);
        SocialUserInfo socialUserInfo = SocialUtil.parseMapToSocialUserInfo(SocialPlatform.WeiBo, accessTokenMap);
        return socialUserInfo;
    }

    public static SocialUserInfo getWeiBoUserInfo(String appid, String appSecret, String code, String redirectUri) {
        Map userInfoMap;
        String userInfoJsonStr;
        SocialUserInfo socialUserInfo = SocialUtil.getWeiBoUid(appid, appSecret, code, redirectUri);
        try {
            String userInfoUrl = String.format(WEIBO_USER_IFNO_URL, socialUserInfo.getAccessToken(), socialUserInfo.getUid());
            userInfoJsonStr = HttpUtil.get((String)userInfoUrl);
        }
        catch (Exception e) {
            log.debug("\u83b7\u53d6\u5fae\u535a\u7528\u6237\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u83b7\u53d6\u5fae\u535a\u7528\u6237\u4fe1\u606f\u5931\u8d25", e);
        }
        try {
            userInfoMap = (Map)JSONObject.parseObject((String)userInfoJsonStr, HashMap.class);
        }
        catch (Exception e) {
            log.debug("\u89e3\u6790json\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u89e3\u6790json\u5931\u8d25", e);
        }
        if (userInfoMap.containsKey("error")) {
            throw new RuntimeException(userInfoMap.get("error").toString());
        }
        socialUserInfo.setSocialNickname(userInfoMap.get("name").toString());
        if ("m".equals(userInfoMap.get("gender"))) {
            socialUserInfo.setGender(1);
        } else if ("f".equals(userInfoMap.get("gender"))) {
            socialUserInfo.setGender(2);
        } else {
            socialUserInfo.setGender(3);
        }
        socialUserInfo.setHeadImg(userInfoMap.get("avatar_hd").toString());
        return socialUserInfo;
    }

    public static SocialUserInfo getSocialUid(SocialPlatform platform, String appid, String appSecret, String code, String redirectUri) {
        switch (platform) {
            case QQ: {
                return SocialUtil.getQqUid(appid, appSecret, code, redirectUri);
            }
            case WeiBo: {
                return SocialUtil.getWeiBoUid(appid, appSecret, code, redirectUri);
            }
            case WeiXin: {
                return SocialUtil.getWeiXinUid(appid, appSecret, code);
            }
        }
        return null;
    }

    public static SocialUserInfo getSocialUserInfo(SocialPlatform platform, String appid, String appSecret, String code, String redirectUri) {
        switch (platform) {
            case QQ: {
                return SocialUtil.getQqUserInfo(appid, appSecret, code, redirectUri);
            }
            case WeiBo: {
                return SocialUtil.getWeiBoUserInfo(appid, appSecret, code, redirectUri);
            }
            case WeiXin: {
                return SocialUtil.getWeiXinUserInfo(appid, appSecret, code);
            }
        }
        return null;
    }

    private static SocialUserInfo parseMapToSocialUserInfo(SocialPlatform platform, Map<String, Object> socialMap) {
        SocialUserInfo.SocialUserInfoBuilder builder = SocialUserInfo.builder();
        builder.platform(platform).appid(socialMap.get("appid").toString());
        switch (platform) {
            case WeiXin: {
                builder.uid(socialMap.get("unionid") == null ? "" : socialMap.get("unionid").toString()).openId(socialMap.get("openid").toString()).accessToken(socialMap.get("access_token").toString()).accessTokenExpireIn((Integer)socialMap.get("expires_in")).refreshToken(socialMap.get("refresh_token").toString());
                break;
            }
            case WeiBo: {
                builder.uid(socialMap.get("uid").toString()).accessToken(socialMap.get("access_token").toString()).accessTokenExpireIn((Integer)socialMap.get("expires_in"));
                break;
            }
            case QQ: {
                builder.uid(socialMap.get("openid").toString()).accessToken(socialMap.get("access_token").toString()).accessTokenExpireIn(Integer.parseInt(socialMap.get("expires_in").toString())).refreshToken(socialMap.get("refresh_token").toString());
            }
        }
        return builder.build();
    }
}

