/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.setting;

import cn.hutool.core.util.StrUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.reader.UnicodeReader;

public class SettingUtil {
    public static InputStream openSettingFile(String settingFileName) throws IOException {
        return SettingUtil.openSettingFile(settingFileName, null);
    }

    public static InputStream openSettingFile(String settingFileName, String jvmArgName) throws IOException {
        String settingLocation;
        if (StrUtil.isNotBlank((CharSequence)jvmArgName) && StrUtil.isNotBlank((CharSequence)(settingLocation = System.getProperty(jvmArgName, "")))) {
            File settingFile = new File(settingLocation);
            if (settingFile.exists()) {
                return new FileInputStream(settingFile);
            }
            throw new IllegalArgumentException("Can't found setting(" + jvmArgName + ") file: " + settingLocation);
        }
        File settingFile = new File(settingFileName);
        if (settingFile.exists()) {
            return new FileInputStream(settingFile);
        }
        URL url = ResourceUtils.getURL((String)("classpath:" + settingFileName));
        return url.openStream();
    }

    public static Map<String, Object> readYamlFile(String settingFileName, String jvmArgName) throws IOException {
        Yaml yaml = new Yaml();
        InputStream inputStream = SettingUtil.openSettingFile(settingFileName, jvmArgName);
        UnicodeReader reader = new UnicodeReader(inputStream);
        Map map = (Map)yaml.loadAs((Reader)reader, LinkedHashMap.class);
        if (map == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        SettingUtil.buildFlattenedMap(result, map, null);
        return result;
    }

    private static void buildFlattenedMap(Map<String, Object> result, Map<String, Object> source, String path) {
        source.forEach((key, value) -> {
            if (StringUtils.hasText((String)path)) {
                key = key.startsWith("[") ? path + key : path + '.' + key;
            }
            if (value instanceof String) {
                result.put((String)key, value);
            } else if (value instanceof Map) {
                Map map = (Map)value;
                SettingUtil.buildFlattenedMap(result, map, key);
            } else if (value instanceof Collection) {
                Collection collection = (Collection)value;
                if (collection.isEmpty()) {
                    result.put((String)key, "");
                } else {
                    int count = 0;
                    for (Object object : collection) {
                        SettingUtil.buildFlattenedMap(result, Collections.singletonMap("[" + count++ + "]", object), key);
                    }
                }
            } else {
                result.put((String)key, value != null ? value : "");
            }
        });
    }
}

