/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.resource.store;

import com.alibaba.fastjson.JSON;
import com.jeecms.utils.CollectionUtil;
import com.jeecms.utils.StrUtil;
import com.jeecms.utils.resource.operator.UploadResult;
import com.jeecms.utils.resource.store.IResourceStore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;

public class ResourceCacheStore
implements IResourceStore {
    private static final Logger log = LoggerFactory.getLogger(ResourceCacheStore.class);
    private static final String KEY_PREFIX = "RESOURCE:";
    private IResourceStore resourceStore;
    private StringRedisTemplate redisTemplate;

    public ResourceCacheStore(IResourceStore resourceStore, StringRedisTemplate redisTemplate) {
        this.resourceStore = resourceStore;
        this.redisTemplate = redisTemplate;
    }

    @Override
    public void save(UploadResult uploadResult) {
        this.resourceStore.save(uploadResult);
    }

    @Override
    public void remove(Serializable mark) {
        this.resourceStore.remove(mark);
    }

    @Override
    public String getAlias(String alias, Long siteId, Long groupId, Integer originType) {
        return this.resourceStore.getAlias(alias, siteId, groupId, originType);
    }

    @Override
    public UploadResult getUploadResultById(Long id) {
        UploadResult uploadResult;
        String jsonStr = (String)this.redisTemplate.opsForValue().get((Object)(KEY_PREFIX + id));
        if (StrUtil.isNotBlank((CharSequence)jsonStr) && (uploadResult = this.parseUploadResult(jsonStr)) != null) {
            return uploadResult;
        }
        return this.loadUploadResultByIds(Collections.singletonList(id)).get(0);
    }

    @Override
    public List<UploadResult> getUploadResultByIds(List<Long> ids) {
        List keys = ids.stream().map(id -> KEY_PREFIX + id).collect(Collectors.toList());
        List jsonStrs = this.redisTemplate.opsForValue().multiGet(keys);
        if (CollectionUtil.isNotEmpty((Collection)jsonStrs)) {
            ArrayList<Long> hitIds = new ArrayList<Long>(jsonStrs.size());
            ArrayList<UploadResult> uploadResults = new ArrayList<UploadResult>(ids.size());
            for (String jsonStr : jsonStrs) {
                UploadResult uploadResult = this.parseUploadResult(jsonStr);
                if (uploadResult == null) continue;
                uploadResults.add(uploadResult);
                hitIds.add(uploadResult.getId());
            }
            if (hitIds.size() == ids.size()) {
                return uploadResults;
            }
            ArrayList<Long> copyIds = new ArrayList<Long>(ids);
            copyIds.removeAll(hitIds);
            List<UploadResult> uploadResultFromDb = this.loadUploadResultByIds(copyIds);
            uploadResults.addAll(uploadResultFromDb);
            return uploadResults;
        }
        return this.loadUploadResultByIds(ids);
    }

    private List<UploadResult> loadUploadResultByIds(List<Long> ids) {
        List<UploadResult> uploadResults;
        if (CollectionUtil.isEmpty(ids)) {
            return Collections.emptyList();
        }
        if (ids.size() == 1) {
            UploadResult uploadResult = this.resourceStore.getUploadResultById(ids.get(0));
            uploadResults = Collections.singletonList(uploadResult);
        } else {
            uploadResults = this.resourceStore.getUploadResultByIds(ids);
        }
        for (UploadResult uploadResult : uploadResults) {
            String jsonString = JSON.toJSONString((Object)uploadResult);
            this.redisTemplate.opsForValue().set((Object)(KEY_PREFIX + uploadResult.getId()), (Object)jsonString, 1L, TimeUnit.HOURS);
        }
        return uploadResults;
    }

    private UploadResult parseUploadResult(String jsonStr) {
        try {
            return (UploadResult)JSON.parseObject((String)jsonStr, UploadResult.class);
        }
        catch (Exception e) {
            log.error("\u8d44\u6e90JSON\u53cd\u5e8f\u5217\u5316\u5931\u8d25", (Throwable)e);
            return null;
        }
    }
}

