/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.resource.store;

import com.jeecms.utils.resource.Config;
import com.jeecms.utils.resource.ResourceUtil;
import com.jeecms.utils.resource.UploadStrategy;
import com.jeecms.utils.resource.UrlSpliceStrategy;
import com.jeecms.utils.resource.operator.UploadResult;
import com.jeecms.utils.resource.store.IResourceStore;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class PathSuffixResourceStore
implements IResourceStore {
    @Override
    public void save(UploadResult uploadResult) {
        this.dressPath(uploadResult);
    }

    @Override
    public UploadResult getUploadResultById(Long id) {
        return null;
    }

    @Override
    public UploadResult getUploadResultByPath(String path) {
        String url = null;
        if (Config.getInstance().getUrlSpliceStrategy() == UrlSpliceStrategy.DYNAMIC) {
            for (UploadStrategy uploadStrategy : UploadStrategy.values()) {
                String rt = this.getUrlParameter(uploadStrategy);
                if (!path.endsWith(rt)) continue;
                url = Optional.of(ResourceUtil.getUrlPrefix(uploadStrategy)).orElse(ResourceUtil.getUrlPrefix(UploadStrategy.REMOTE)) + path.substring(0, path.length() - rt.length() - 1);
            }
        }
        if (url == null) {
            url = ResourceUtil.getUrlPrefix() + path;
        }
        UploadResult uploadResult = new UploadResult();
        uploadResult.setPath(path);
        uploadResult.setUrl(url);
        return uploadResult;
    }

    @Override
    public List<UploadResult> getUploadResultByIds(List<Long> marks) {
        return Collections.emptyList();
    }

    @Override
    public void remove(Serializable mark) {
    }

    @Override
    public String getAlias(String alias, Long siteId, Long groupId, Integer originType) {
        return alias;
    }

    private void dressPath(UploadResult uploadResult) {
        if (Config.getInstance().getUrlSpliceStrategy() == UrlSpliceStrategy.DYNAMIC) {
            String path = uploadResult.getPath();
            String s = path.contains("?") ? path : path + "?rt=" + uploadResult.getStoreType();
            uploadResult.setPath(s);
        }
    }

    private String getUrlParameter(UploadStrategy uploadStrategy) {
        return "rt=" + uploadStrategy.getFlag();
    }
}

