/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.resource.store;

import com.jeecms.utils.URLUtil;
import com.jeecms.utils.resource.operator.UploadResult;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

public interface IResourceStore {
    public void save(UploadResult var1);

    public UploadResult getUploadResultById(Long var1);

    default public UploadResult getUploadResultByPath(String path) {
        throw new IllegalArgumentException("\u6682\u65f6\u4e0d\u652f\u6301\u901a\u8fc7Path\u67e5\u627e\u8d44\u6e90");
    }

    default public UploadResult getUploadResultByUrl(String url) {
        return this.getUploadResultByPath(URLUtil.getPath(url));
    }

    public List<UploadResult> getUploadResultByIds(List<Long> var1);

    default public List<UploadResult> getUploadResultByPaths(List<String> paths) {
        throw new IllegalArgumentException("\u6682\u65f6\u4e0d\u652f\u6301\u901a\u8fc7Paths\u67e5\u627e\u8d44\u6e90");
    }

    default public List<UploadResult> getUploadResultByUrls(List<String> urls) {
        List<String> paths = urls.stream().map(URLUtil::getPath).collect(Collectors.toList());
        return this.getUploadResultByPaths(paths);
    }

    default public List<UploadResult> getUploadResults(List<? extends Serializable> marks) {
        if (marks.get(0) instanceof Long) {
            List<UploadResult> uploadResults = this.getUploadResultByIds(marks);
            return uploadResults;
        }
        if (marks.get(0) instanceof String) {
            String str = (String)((Object)marks.get(0));
            if (str.startsWith("http")) {
                return this.getUploadResultByUrls(marks);
            }
            return this.getUploadResultByPaths(marks);
        }
        throw new IllegalArgumentException("\u65e0\u6cd5\u6839\u636e[" + marks + "]\u67e5\u627e\u8d44\u6e90");
    }

    public void remove(Serializable var1);

    public String getAlias(String var1, Long var2, Long var3, Integer var4);
}

