/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.resource.resolve;

import cn.hutool.core.util.ReflectUtil;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.jeecms.utils.CollectionUtil;
import com.jeecms.utils.DateUtil;
import com.jeecms.utils.StrUtil;
import com.jeecms.utils.resource.operator.UploadResult;
import com.jeecms.utils.resource.resolve.Res;
import com.jeecms.utils.resource.resolve.ResType;
import com.jeecms.utils.spring.WebUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ResourcePropertyFilter
implements ValueFilter {
    public Object process(Object object, String name, Object value) {
        try {
            if (value == null) {
                return value;
            }
            if (!(value instanceof Long) && !(value instanceof Collection)) {
                return value;
            }
            Class<?> objectClass = object.getClass();
            Field field = null;
            try {
                field = ReflectUtil.getField(objectClass, (String)name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Res res = null;
            if (field != null) {
                res = field.getAnnotation(Res.class);
            }
            if (res == null) {
                try {
                    Method method = ReflectUtil.getMethod(objectClass, (String)("get" + StrUtil.upperFirst((CharSequence)name)), (Class[])new Class[0]);
                    if (method != null) {
                        res = method.getAnnotation(Res.class);
                    }
                }
                catch (Exception method) {
                    // empty catch block
                }
            }
            if (res != null) {
                Collection coll;
                if (value instanceof Long) {
                    return this.resolveResource((Long)value, res);
                }
                if (value instanceof Collection && CollectionUtil.isNotEmpty((Collection)(coll = (Collection)value))) {
                    ArrayList<Long> ids = !(coll instanceof List) ? new ArrayList<Long>(coll) : (ArrayList<Long>)coll;
                    List<UploadResult> uploadResults = this.getResultByIds(ids);
                    if (res.onlyUrl()) {
                        List<String> urls = CollectionUtil.convert(uploadResults, ur -> Optional.ofNullable(ur).map(UploadResult::getUrl).orElse(null));
                        return urls;
                    }
                    if (res.onlyFilename()) {
                        List<String> filenames = CollectionUtil.convert(uploadResults, ur -> Optional.ofNullable(ur).map(UploadResult::getFilename).orElse(null));
                        return filenames;
                    }
                    if (res.onlyCoverUrl()) {
                        List<String> coverUrls = CollectionUtil.convert(uploadResults, ur -> Optional.ofNullable(ur).map(UploadResult::getCoverUrl).orElse(null));
                        return coverUrls;
                    }
                    if (res.onlyLength()) {
                        List<Long> lengthList = CollectionUtil.convert(uploadResults, ur -> Optional.ofNullable(ur).map(UploadResult::getLength).orElse(null));
                        return lengthList;
                    }
                    if (res.onlyDuration()) {
                        List<Long> durations = CollectionUtil.convert(uploadResults, ur -> Optional.ofNullable(ur).map(UploadResult::getDuration).orElse(null));
                        return durations;
                    }
                    List<Map> maps = CollectionUtil.convert(uploadResults, ur -> this.maskRoute((UploadResult)ur).apply((UploadResult)ur));
                    return maps;
                }
            }
        }
        catch (Exception e) {
            return value;
        }
        return value;
    }

    private Object resolveResource(Long id, Res res) {
        if (id == null) {
            return null;
        }
        UploadResult uploadResult = this.getResultById(id);
        if (uploadResult == null) {
            return null;
        }
        if (res.onlyUrl()) {
            return uploadResult.getUrl();
        }
        if (res.onlyFilename()) {
            return uploadResult.getFilename();
        }
        if (res.onlyCoverUrl()) {
            return uploadResult.getCoverUrl();
        }
        if (res.onlyLength()) {
            return uploadResult.getLength();
        }
        if (res.onlyDuration()) {
            return uploadResult.getDuration();
        }
        return this.maskRoute(uploadResult).apply(uploadResult);
    }

    private UploadResult getResultById(Long id) {
        if (id == null) {
            return null;
        }
        Map resultMap = (Map)WebUtil.getRequest().getAttribute("UPLOAD_RESULTS");
        return (UploadResult)resultMap.get(id);
    }

    private List<UploadResult> getResultByIds(List<Long> ids) {
        if (ids == null) {
            return Collections.emptyList();
        }
        Map resultMap = (Map)WebUtil.getRequest().getAttribute("UPLOAD_RESULTS");
        List<UploadResult> results = ids.stream().map(resultMap::get).collect(Collectors.toList());
        return results;
    }

    private Function<UploadResult, Map<String, Object>> maskRoute(UploadResult uploadResult) {
        ResType resType = uploadResult.getResType();
        if (resType == ResType.VIDEO) {
            return this::maskVideoResource;
        }
        if (resType == ResType.AUDIO) {
            return this::maskAudioResource;
        }
        if (resType == ResType.IMG) {
            return this::maskImgResource;
        }
        if (resType == ResType.DOC) {
            return this::maskDocResource;
        }
        if (resType == ResType.ATTACH) {
            return this::maskAttachResource;
        }
        return this::maskAttachResource;
    }

    private Map<String, Object> maskDocResource(UploadResult uploadResult) {
        if (uploadResult == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        if (uploadResult.getId() != null) {
            map.put("id", uploadResult.getId().toString());
        }
        map.put("filename", uploadResult.getFilename());
        map.put("url", uploadResult.getUrl());
        return map;
    }

    private Map<String, Object> maskImgResource(UploadResult uploadResult) {
        if (uploadResult == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        if (uploadResult.getId() != null) {
            map.put("id", uploadResult.getId().toString());
        }
        map.put("filename", uploadResult.getFilename());
        map.put("url", uploadResult.getUrl());
        return map;
    }

    private Map<String, Object> maskAudioResource(UploadResult uploadResult) {
        if (uploadResult == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        if (uploadResult.getId() != null) {
            map.put("id", uploadResult.getId().toString());
        }
        map.put("filename", uploadResult.getFilename());
        map.put("url", uploadResult.getUrl());
        map.put("duration", Optional.ofNullable(uploadResult.getDuration()).map(DateUtil::formatDuration).orElse(null));
        return map;
    }

    private Map<String, Object> maskVideoResource(UploadResult uploadResult) {
        if (uploadResult == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        if (uploadResult.getId() != null) {
            map.put("id", uploadResult.getId().toString());
        }
        map.put("url", uploadResult.getUrl());
        map.put("coverUrl", uploadResult.getCoverUrl());
        map.put("filename", uploadResult.getFilename());
        map.put("duration", Optional.ofNullable(uploadResult.getDuration()).map(DateUtil::formatDuration).orElse(null));
        return map;
    }

    private Map<String, Object> maskAttachResource(UploadResult uploadResult) {
        if (uploadResult == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        if (uploadResult.getId() != null) {
            map.put("id", uploadResult.getId().toString());
        }
        map.put("url", uploadResult.getUrl());
        map.put("filename", uploadResult.getFilename());
        map.put("coverUrl", uploadResult.getCoverUrl());
        map.put("duration", Optional.ofNullable(uploadResult.getDuration()).map(DateUtil::formatDuration).orElse(null));
        map.put("length", uploadResult.getLength());
        map.put("path", uploadResult.getPath());
        return map;
    }
}

