/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.resource.resolve;

import cn.hutool.core.collection.ConcurrentHashSet;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.TypeUtil;
import com.jeecms.kit.JcResult;
import com.jeecms.lang.ITreeNode;
import com.jeecms.lang.JeePage;
import com.jeecms.utils.ReflectUtil;
import com.jeecms.utils.resource.ResourceUtil;
import com.jeecms.utils.resource.operator.UploadResult;
import com.jeecms.utils.resource.resolve.Res;
import com.jeecms.utils.spring.WebUtil;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Page;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@RestControllerAdvice
public class ResourceAdvice
implements ResponseBodyAdvice<Object> {
    private static final Set<Class> BASIC_CLASS_SET = new HashSet<Class>(Arrays.asList(Integer.TYPE, Integer.class, Byte.TYPE, Byte.class, Float.TYPE, Float.class, Double.TYPE, Double.class, Character.TYPE, Character.class, Short.TYPE, Short.class, Boolean.TYPE, Boolean.class, Long.TYPE, Long.class, String.class, Date.class, LocalDateTime.class, LocalDate.class, LocalTime.class, BigInteger.class, BigDecimal.class));
    private final Map<Class, Map<Field, Res>> resVoMap = new ConcurrentHashMap<Class, Map<Field, Res>>();
    private final Set<String> containResApi = new ConcurrentHashSet();
    private final Set<String> rejectResApi = new ConcurrentHashSet();
    private final Map<Field, Res> placeholderMap = new HashMap<Field, Res>();
    private static final String BASE_PACKAGE = "com.jeecms";

    public boolean supports(MethodParameter returnType, Class converterType) {
        boolean support;
        String genericString = returnType.getMethod().toGenericString();
        if (this.rejectResApi.contains(genericString)) {
            return false;
        }
        if (this.containResApi.contains(genericString)) {
            return true;
        }
        Class parameterType = returnType.getParameterType();
        if (!parameterType.getName().startsWith(BASE_PACKAGE)) {
            this.rejectResApi.add(genericString);
            return false;
        }
        Class<?> objClass = this.findObjClass(returnType.getParameterType(), returnType.getGenericParameterType());
        if (objClass == null) {
            this.rejectResApi.add(genericString);
            return false;
        }
        Map<Field, Res> fieldMap = this.resVoMap.get(objClass);
        if (fieldMap == null) {
            this.findResAnnotation(objClass);
            fieldMap = this.resVoMap.get(objClass);
        }
        boolean bl = support = !fieldMap.isEmpty();
        if (support) {
            this.containResApi.add(genericString);
        } else {
            this.rejectResApi.add(genericString);
        }
        return support;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        this.cacheUploadResult(body);
        return body;
    }

    private Class<?> findObjClass(Class<?> cls, Type type) {
        ParameterizedType genericParameterType;
        Object[] actualTypeArguments;
        if (cls == JcResult.class && type instanceof ParameterizedType && ArrayUtil.isNotEmpty((Object[])(actualTypeArguments = (genericParameterType = (ParameterizedType)type).getActualTypeArguments()))) {
            type = actualTypeArguments[0];
            Class aClass = TypeUtil.getClass((Type)type);
            return this.findObjClass(aClass, (Type)type);
        }
        if (Page.class.isAssignableFrom(cls) && type instanceof ParameterizedType && ArrayUtil.isNotEmpty((Object[])(actualTypeArguments = (genericParameterType = (ParameterizedType)type).getActualTypeArguments()))) {
            type = actualTypeArguments[0];
            Class aClass = TypeUtil.getClass((Type)type);
            return this.findObjClass(aClass, (Type)type);
        }
        if (Collection.class.isAssignableFrom(cls) && type instanceof ParameterizedType && ArrayUtil.isNotEmpty((Object[])(actualTypeArguments = (genericParameterType = (ParameterizedType)type).getActualTypeArguments()))) {
            type = actualTypeArguments[0];
            Class aClass = TypeUtil.getClass((Type)type);
            return this.findObjClass(aClass, (Type)type);
        }
        if (Map.class.isAssignableFrom(cls) && type instanceof ParameterizedType && ArrayUtil.isNotEmpty((Object[])(actualTypeArguments = (genericParameterType = (ParameterizedType)type).getActualTypeArguments()))) {
            type = actualTypeArguments[1];
            Class aClass = TypeUtil.getClass((Type)type);
            return this.findObjClass(aClass, (Type)type);
        }
        return cls;
    }

    private void cacheUploadResult(Object obj) {
        List<Object> uploadResults;
        ArrayList<Long> allResId = new ArrayList<Long>(this.collectAllResId(obj));
        List<Object> list = uploadResults = allResId.isEmpty() ? Collections.emptyList() : ResourceUtil.getUploadResult(allResId);
        if (!uploadResults.isEmpty()) {
            uploadResults = uploadResults.stream().filter(u -> u != null && StringUtils.isNotBlank((CharSequence)u.getUrl())).collect(Collectors.toList());
            Map<Long, UploadResult> map = uploadResults.stream().collect(Collectors.toMap(UploadResult::getId, u -> u));
            WebUtil.getRequest().setAttribute("UPLOAD_RESULTS", map);
        }
    }

    private Set<Long> collectAllResId(Object obj) {
        if (obj == null) {
            return Collections.emptySet();
        }
        if (obj instanceof JcResult) {
            JcResult jcResult = (JcResult)obj;
            Object data = jcResult.getData();
            return this.collectAllResId(data);
        }
        if (obj instanceof Page) {
            Page page = (Page)obj;
            return this.collectAllResId(page.getContent());
        }
        if (obj instanceof JeePage) {
            JeePage page = (JeePage)obj;
            return this.collectAllResId(page.getContent());
        }
        HashSet<Long> resIds = new HashSet<Long>();
        if (obj instanceof Collection) {
            Collection coll = (Collection)obj;
            for (Object o : coll) {
                resIds.addAll(this.collectAllResId(o));
                this.fetchChild(resIds, o);
            }
            return resIds;
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            for (Map.Entry entry : map.entrySet()) {
                resIds.addAll(this.collectAllResId(entry.getValue()));
                this.fetchChild(resIds, entry.getValue());
            }
            return resIds;
        }
        Map<Field, Res> fieldMap = this.resVoMap.get(obj.getClass());
        for (Map.Entry<Field, Res> entry : fieldMap.entrySet()) {
            Field field = entry.getKey();
            Res resAnno = entry.getValue();
            Object value = ReflectUtil.getFieldValue(obj, field);
            if (resAnno == null) {
                resIds.addAll(this.collectAllResId(value));
                continue;
            }
            if (value instanceof Long) {
                resIds.add((Long)value);
                continue;
            }
            if (!(value instanceof List)) continue;
            List list = (List)value;
            resIds.addAll(list);
        }
        return resIds;
    }

    private void fetchChild(Set<Long> resIds, Object o) {
        if (o instanceof ITreeNode) {
            ITreeNode treeNode = (ITreeNode)o;
            for (Object child : treeNode.getChildren()) {
                resIds.addAll(this.collectAllResId(child));
                this.fetchChild(resIds, child);
            }
        }
    }

    private void findResAnnotation(Class<?> objClass) {
        this.resVoMap.put(objClass, this.placeholderMap);
        LinkedHashMap<Field, Res> map = new LinkedHashMap<Field, Res>();
        for (Field field : ReflectUtil.getFields(objClass)) {
            Class inlineVoClass;
            Type typeParameter;
            Type genericType;
            if (this.isResIdField(field)) {
                Res annotation = field.getAnnotation(Res.class);
                if (annotation == null) continue;
                map.put(field, annotation);
                continue;
            }
            if (this.isBasicType(field)) continue;
            if (Collection.class.isAssignableFrom(field.getType())) {
                genericType = field.getGenericType();
                if (!(genericType instanceof ParameterizedType) || (typeParameter = this.getGenericType((ParameterizedType)genericType, 0)) == null) continue;
                inlineVoClass = TypeUtil.getClass((Type)typeParameter);
                if (!this.resVoMap.containsKey(inlineVoClass)) {
                    this.findResAnnotation(inlineVoClass);
                }
                if (this.resVoMap.get(inlineVoClass).isEmpty()) continue;
                map.put(field, null);
                continue;
            }
            if (Map.class.isAssignableFrom(field.getType())) {
                genericType = field.getGenericType();
                if (!(genericType instanceof ParameterizedType) || (typeParameter = this.getGenericType((ParameterizedType)genericType, 1)) == null) continue;
                inlineVoClass = TypeUtil.getClass((Type)typeParameter);
                if (!this.resVoMap.containsKey(inlineVoClass)) {
                    this.findResAnnotation(inlineVoClass);
                }
                if (this.resVoMap.get(inlineVoClass).isEmpty()) continue;
                map.put(field, null);
                continue;
            }
            if (field.getType().isArray()) continue;
            Class<?> inlineVoClass2 = field.getType();
            if (!this.resVoMap.containsKey(inlineVoClass2)) {
                this.findResAnnotation(inlineVoClass2);
            }
            if (this.resVoMap.get(inlineVoClass2).isEmpty()) continue;
            map.put(field, null);
        }
        this.resVoMap.put(objClass, map.isEmpty() ? Collections.emptyMap() : map);
    }

    private boolean isBasicType(Field field) {
        return BASIC_CLASS_SET.contains(field.getType()) || field.getType().isEnum();
    }

    private boolean isResIdField(Field field) {
        ParameterizedType genericParameterType;
        Object[] actualTypeArguments;
        Object type;
        Class<?> cls = field.getType();
        if (cls == Long.class || cls == Long.TYPE) {
            return true;
        }
        if (List.class.isAssignableFrom(field.getType()) && (type = field.getGenericType()) instanceof ParameterizedType && ArrayUtil.isNotEmpty((Object[])(actualTypeArguments = (genericParameterType = (ParameterizedType)type).getActualTypeArguments()))) {
            type = actualTypeArguments[0];
            return Long.class == TypeUtil.getClass((Type)type);
        }
        return false;
    }

    private Type getGenericType(ParameterizedType type, int idx) {
        Object[] actualTypeArguments = type.getActualTypeArguments();
        if (ArrayUtil.isNotEmpty((Object[])actualTypeArguments) && idx < actualTypeArguments.length) {
            return actualTypeArguments[idx];
        }
        return null;
    }
}

