/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.resource.operator;

import com.jeecms.utils.resource.Config;
import com.jeecms.utils.resource.ResourceUtil;
import com.jeecms.utils.resource.operator.UploadContext;
import com.jeecms.utils.resource.resolve.ResType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class UploadResult
implements Serializable {
    private Long id;
    private String url;
    private String path;
    private String filename;
    private String oriFilename;
    private int storeType;
    private String coverUrl;
    private Long duration;
    private Long length;
    private ResType resType;
    private final Map<String, Object> attach = new HashMap<String, Object>();

    public UploadResult() {
    }

    public UploadResult(String path, String filename) {
        this(ResourceUtil.getUrlPrefix() + path, path, filename);
    }

    public UploadResult(String url, String path, String filename) {
        this.path = path;
        this.url = url;
        this.filename = filename;
        this.storeType = Character.digit(Config.getInstance().getStrategy().getFlag(), 10);
    }

    public UploadResult(String url, String path, String filename, String oriFilename) {
        this.path = path;
        this.url = url;
        this.filename = filename;
        this.oriFilename = oriFilename;
        this.storeType = Character.digit(Config.getInstance().getStrategy().getFlag(), 10);
    }

    public static UploadResult of(UploadContext context) {
        UploadResult uploadResult = new UploadResult(context.getAccessUrl(), context.getPath(), context.getFilename(), context.getOriFilename());
        uploadResult.setStoreType(Character.digit(context.getConfig().getStrategy().getFlag(), 10));
        return uploadResult;
    }

    public String getOriFilename() {
        return this.oriFilename;
    }

    public void setOriFilename(String oriFilename) {
        this.oriFilename = oriFilename;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getUrl() {
        return this.url;
    }

    public String getPath() {
        return this.path;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public int getStoreType() {
        return this.storeType;
    }

    public void setStoreType(int storeType) {
        this.storeType = storeType;
    }

    public String getCoverUrl() {
        return this.coverUrl;
    }

    public void setCoverUrl(String coverUrl) {
        this.coverUrl = coverUrl;
    }

    public Long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public Long getLength() {
        return this.length;
    }

    public void setLength(Long length) {
        this.length = length;
    }

    public ResType getResType() {
        return this.resType;
    }

    public void setResType(ResType resType) {
        this.resType = resType;
    }

    public void putAttach(String key, Object obj) {
        this.attach.put(key, obj);
    }

    public <T> T getAttach(String key) {
        return (T)this.attach.get(key);
    }

    public String toString() {
        return "UploadResult{id=" + this.id + ", url='" + this.url + '\'' + ", path='" + this.path + '\'' + ", filename='" + this.filename + '\'' + ", storeType=" + this.storeType + ", coverUrl='" + this.coverUrl + '\'' + ", duration=" + this.duration + ", length=" + this.length + ", resType=" + (Object)((Object)this.resType) + '}';
    }
}

