/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.resource.operator;

import com.jeecms.utils.DateUtil;
import com.jeecms.utils.FileNameUtil;
import com.jeecms.utils.IdUtil;
import com.jeecms.utils.URLUtil;
import com.jeecms.utils.lambda.LambdaUtil;
import com.jeecms.utils.resource.Config;
import com.jeecms.utils.resource.interceptor.ResourceInterceptor;
import com.jeecms.utils.resource.operator.ResourceOperator;
import com.jeecms.utils.resource.operator.UploadResult;
import com.jeecms.utils.resource.store.IResourceStore;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.core.io.Resource;

public class UploadContext {
    public static final String EXCEPTION = "EXCEPTION";
    public static final String NAME_NO = "NAME_NO";
    public static final String RESOURCE_STORE_IGNORE = "RESOURCE_STORE_IGNORE";
    public static final String DURATION = "DURATION";
    public static final String COVER_URL = "COVER_URL";
    public static final String RES_TYPE = "RES_TYPE";
    public static final String NO_WATERMARK = "NO_WATERMARK";
    public static final String NO_RESOURCE_LIMIT = "NO_RESOURCE_LIMIT";
    public static final String GROUP_ID = "GROUP_ID";
    public static final String ORIGIN_TYPE = "ORIGIN_TYPE";
    public static final String SITE_ID = "SITE_ID";
    public static final String VISIBLE = "VISIBLE";
    public static final String RES_SUFFIX = "RES_SUFFIX";
    private Config config;
    private ResourceOperator resourceOperator;
    private Resource resource;
    private Long contentLength;
    private String filename;
    private String oriFilename;
    private String suffix;
    private String dir;
    private UploadResult uploadResult;
    private IResourceStore resourceStore;
    private Map<String, Object> attachMap = new HashMap<String, Object>();

    private UploadContext(Resource resource) {
        this.setResource(resource);
        this.setConfig(Config.getInstance());
        this.setDir(DateUtil.format(LocalDate.now(), "/yyyy/MM/dd/"));
    }

    public void putAttach(String key, Object value) {
        this.attachMap.put(key, value);
    }

    public void putAttachFlag(String flag) {
        this.attachMap.put(flag, "");
    }

    public <V> V getAttach(String key) {
        return (V)this.attachMap.get(key);
    }

    public boolean containsAttach(String key) {
        return this.attachMap.containsKey(key);
    }

    public Map<String, Object> getAttachMap() {
        return this.attachMap;
    }

    public static UploadContext wrap(Resource resource) {
        return new UploadContext(resource);
    }

    public String getPath() {
        return this.getDir() + this.getFilename();
    }

    public String getAccessUrl() {
        return UploadContext.getUrlPrefix(this.config) + this.getPath();
    }

    public String getOriFilename() {
        return this.oriFilename;
    }

    public void setFilename(String filename) {
        this.oriFilename = URLUtil.decode((String)filename);
        this.suffix = FileNameUtil.getSuffix((String)filename);
        this.filename = IdUtil.getId() + "." + this.suffix;
    }

    public void setDir(String dir) {
        if (!dir.startsWith("/")) {
            dir = "/" + dir;
        }
        if (!dir.endsWith("/")) {
            dir = dir + "/";
        }
        this.dir = dir;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
        this.setFilename(Optional.ofNullable(this.getOriFilename()).orElse(resource.getFilename()));
        this.attachMap.put(NAME_NO, 0);
        try {
            this.contentLength = resource.contentLength();
        }
        catch (IOException e) {
            LambdaUtil.doThrow(e);
        }
    }

    public Resource getResource() {
        return this.resource;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getDir() {
        return this.dir;
    }

    public ResourceOperator getResourceOperator() {
        return this.resourceOperator;
    }

    public void setResourceOperator(ResourceOperator resourceOperator) {
        this.resourceOperator = resourceOperator;
    }

    public void setException(Exception e) {
        this.putAttach(EXCEPTION, e);
    }

    public Exception getException() {
        return (Exception)this.getAttach(EXCEPTION);
    }

    public boolean hasException() {
        return this.getException() != null;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = UploadContext.cloneConfig(config);
        this.setResourceOperator(this.config.getStrategy().getUploader());
        this.setResourceStore(this.config.getResourceStore());
    }

    public UploadResult getUploadResult() {
        return this.uploadResult;
    }

    public void setUploadResult(UploadResult uploadResult) {
        this.uploadResult = uploadResult;
    }

    public IResourceStore getResourceStore() {
        return this.resourceStore;
    }

    public void setResourceStore(IResourceStore resourceStore) {
        this.resourceStore = resourceStore;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    private static String getUrlPrefix(Config config) {
        switch (config.getStrategy()) {
            case LOCAL: {
                return config.getLocal().getUrlPrefix();
            }
            case FTP: {
                return config.getFtp().getUrlPrefix();
            }
            case ALI_OSS: {
                return config.getAliOss().getUrlPrefix();
            }
            case TENCENT_COS: {
                return config.getTencentCos().getUrlPrefix();
            }
            case QINIU_OSS: {
                return config.getQiniuOss().getUrlPrefix();
            }
            case REMOTE: 
            case RPC: {
                throw new RuntimeException("\u8fdc\u7aef\u8d44\u6e90\u65e0\u6cd5\u83b7\u53d6URL\u524d\u7f00");
            }
        }
        throw new RuntimeException("\u65e0\u6cd5\u83b7\u53d6URL\u524d\u7f00\uff1a" + (Object)((Object)config.getStrategy()));
    }

    private static Config cloneConfig(Config config) {
        Config newConfig = new Config();
        newConfig.setStrategy(config.getStrategy());
        newConfig.setUrlSpliceStrategy(config.getUrlSpliceStrategy());
        newConfig.setResourceStore(config.getResourceStore());
        newConfig.setInterceptors(new ArrayList<ResourceInterceptor>(config.getInterceptors()));
        switch (newConfig.getStrategy()) {
            case QINIU_OSS: {
                newConfig.setQiniuOss(UploadContext.cloneQiniuOssConfig(config.getQiniuOss()));
                break;
            }
            case TENCENT_COS: {
                newConfig.setTencentCos(UploadContext.cloneTencentCOSConfig(config.getTencentCos()));
                break;
            }
            case ALI_OSS: {
                newConfig.setAliOss(UploadContext.cloneAliOSSConfig(config.getAliOss()));
                break;
            }
            case FTP: {
                newConfig.setFtp(UploadContext.cloneFtpConfig(config.getFtp()));
                break;
            }
            case RPC: {
                newConfig.setRpc(UploadContext.cloneRPCConfig(config.getRpc()));
                break;
            }
            case REMOTE: {
                newConfig.setRemote(UploadContext.cloneRemoteConfig(config.getRemote()));
                break;
            }
            case LOCAL: {
                newConfig.setLocal(UploadContext.cloneLocalConfig(config.getLocal()));
                break;
            }
        }
        return newConfig;
    }

    private static Config.AliOSSConfig cloneAliOSSConfig(Config.AliOSSConfig aliOSSConfig) {
        Config.AliOSSConfig newAliOSSConfig = new Config.AliOSSConfig();
        newAliOSSConfig.setUrlPrefix(aliOSSConfig.getUrlPrefix());
        newAliOSSConfig.setAccessKeyId(aliOSSConfig.getAccessKeyId());
        newAliOSSConfig.setAccessKeySecret(aliOSSConfig.getAccessKeySecret());
        newAliOSSConfig.setEndpoint(aliOSSConfig.getEndpoint());
        newAliOSSConfig.setBucketName(aliOSSConfig.getBucketName());
        return newAliOSSConfig;
    }

    private static Config.TencentCOSConfig cloneTencentCOSConfig(Config.TencentCOSConfig tencentCOSConfig) {
        Config.TencentCOSConfig newTencentCOSConfig = new Config.TencentCOSConfig();
        newTencentCOSConfig.setUrlPrefix(tencentCOSConfig.getUrlPrefix());
        newTencentCOSConfig.setSecretId(tencentCOSConfig.getSecretId());
        newTencentCOSConfig.setSecretKey(tencentCOSConfig.getSecretKey());
        newTencentCOSConfig.setRegion(tencentCOSConfig.getRegion());
        newTencentCOSConfig.setBucketName(tencentCOSConfig.getBucketName());
        return newTencentCOSConfig;
    }

    private static Config.QiniuOssConfig cloneQiniuOssConfig(Config.QiniuOssConfig qiniuOssConfig) {
        Config.QiniuOssConfig newQiniuOssConfig = new Config.QiniuOssConfig();
        newQiniuOssConfig.setAccessKey(qiniuOssConfig.getAccessKey());
        newQiniuOssConfig.setSecretKey(qiniuOssConfig.getSecretKey());
        newQiniuOssConfig.setBucketName(qiniuOssConfig.getBucketName());
        newQiniuOssConfig.setUrlPrefix(qiniuOssConfig.getUrlPrefix());
        return newQiniuOssConfig;
    }

    private static Config.FtpConfig cloneFtpConfig(Config.FtpConfig ftpConfig) {
        Config.FtpConfig newFtpConfig = new Config.FtpConfig();
        newFtpConfig.setUrlPrefix(ftpConfig.getUrlPrefix());
        newFtpConfig.setHost(ftpConfig.getHost());
        newFtpConfig.setPort(ftpConfig.getPort());
        newFtpConfig.setUsername(ftpConfig.getUsername());
        newFtpConfig.setPassword(ftpConfig.getPassword());
        newFtpConfig.setDirPrefix(ftpConfig.getDirPrefix());
        return newFtpConfig;
    }

    private static Config.RemoteConfig cloneRemoteConfig(Config.RemoteConfig remoteConfig) {
        Config.RemoteConfig newRemoteConfig = new Config.RemoteConfig();
        newRemoteConfig.setHost(remoteConfig.getHost());
        newRemoteConfig.setPort(remoteConfig.getPort());
        return newRemoteConfig;
    }

    private static Config.RPCConfig cloneRPCConfig(Config.RPCConfig rpcConfig) {
        Config.RPCConfig newRpcConfig = new Config.RPCConfig();
        newRpcConfig.setServiceId(rpcConfig.getServiceId());
        return newRpcConfig;
    }

    private static Config.LocalConfig cloneLocalConfig(Config.LocalConfig localConfig) {
        Config.LocalConfig newLocalConfig = new Config.LocalConfig();
        newLocalConfig.setUrlPrefix(localConfig.getUrlPrefix());
        newLocalConfig.setStoreLocation(localConfig.getStoreLocation());
        return newLocalConfig;
    }
}

