/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.resource.operator;

import com.jeecms.utils.FileUtil;
import com.jeecms.utils.resource.Config;
import com.jeecms.utils.resource.operator.AbstractResourceOperator;
import com.jeecms.utils.resource.operator.UploadContext;
import com.jeecms.utils.resource.operator.UploadResult;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.region.Region;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TencentCOSResourceOperator
extends AbstractResourceOperator {
    private static final Logger log = LoggerFactory.getLogger(TencentCOSResourceOperator.class);

    @Override
    protected void openClient(UploadContext context) throws IOException {
        Config.TencentCOSConfig tencentCOSConfig = this.getTencentCOSConfig();
        BasicCOSCredentials cred = new BasicCOSCredentials(tencentCOSConfig.getSecretId(), tencentCOSConfig.getSecretKey());
        Region region = new Region(tencentCOSConfig.getRegion());
        ClientConfig clientConfig = new ClientConfig(region);
        COSClient cosClient = new COSClient((COSCredentials)cred, clientConfig);
        context.putAttach("tencentcos", cosClient);
    }

    @Override
    protected UploadResult doUpload(UploadContext context) throws IOException {
        COSClient cosClient = (COSClient)context.getAttach("tencentcos");
        Config.TencentCOSConfig tencentCOSConfig = this.getTencentCOSConfig();
        PutObjectRequest putObjectRequest = new PutObjectRequest(tencentCOSConfig.getBucketName(), context.getDir().substring(1) + context.getFilename(), context.getResource().getInputStream(), null);
        cosClient.putObject(putObjectRequest);
        return UploadResult.of(context);
    }

    @Override
    public boolean doDelete(String path) throws IOException {
        Config.TencentCOSConfig tencentCOSConfig = this.getTencentCOSConfig();
        try {
            BasicCOSCredentials cred = new BasicCOSCredentials(tencentCOSConfig.getSecretId(), tencentCOSConfig.getSecretKey());
            Region region = new Region(tencentCOSConfig.getRegion());
            ClientConfig clientConfig = new ClientConfig(region);
            COSClient cosClient = new COSClient((COSCredentials)cred, clientConfig);
            try {
                cosClient.deleteObject(tencentCOSConfig.getBucketName(), path.substring(1));
                return true;
            }
            catch (Exception e) {
                log.info("\u817e\u8baf\u4e91COS\u5220\u9664\u6587\u4ef6\u5931\u8d25: [{}]", (Object)path, (Object)e);
                return false;
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public File doDownload(String path, String dir) throws IOException {
        Config.TencentCOSConfig tencentCOSConfig = this.getTencentCOSConfig();
        try {
            BasicCOSCredentials cred = new BasicCOSCredentials(tencentCOSConfig.getSecretId(), tencentCOSConfig.getSecretKey());
            Region region = new Region(tencentCOSConfig.getRegion());
            ClientConfig clientConfig = new ClientConfig(region);
            COSClient cosClient = new COSClient((COSCredentials)cred, clientConfig);
            File targetFile = FileUtil.touch((String)(dir + path));
            cosClient.getObject(new GetObjectRequest(tencentCOSConfig.getBucketName(), path.substring(1)), targetFile);
            return targetFile;
        }
        catch (Exception e) {
            log.info("\u963f\u91cc\u4e91OSS\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new IOException(e);
        }
    }

    @Override
    public boolean exist(UploadContext context) {
        Config.TencentCOSConfig tencentCOSConfig = this.getTencentCOSConfig();
        COSClient cosClient = (COSClient)context.getAttach("tencentcos");
        boolean found = cosClient.doesObjectExist(tencentCOSConfig.getBucketName(), context.getDir().substring(1) + context.getFilename());
        return found;
    }

    private Config.TencentCOSConfig getTencentCOSConfig() {
        return Config.getInstance().getTencentCos();
    }
}

