/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.resource.operator;

import com.jeecms.utils.DownloadUtil;
import com.jeecms.utils.URLUtil;
import com.jeecms.utils.resource.Config;
import com.jeecms.utils.resource.operator.AbstractResourceOperator;
import com.jeecms.utils.resource.operator.UploadContext;
import com.jeecms.utils.resource.operator.UploadResult;
import com.qiniu.common.QiniuException;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.UploadManager;
import com.qiniu.storage.model.FileInfo;
import com.qiniu.util.Auth;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class QiNiuOSSResourceOperator
extends AbstractResourceOperator {
    private static final Logger log = LoggerFactory.getLogger(QiNiuOSSResourceOperator.class);

    @Override
    protected void openClient(UploadContext context) throws IOException {
        Config.QiniuOssConfig qiniuOssConfig = this.getQiniuOssConfig(context);
        Configuration cfg = new Configuration();
        UploadManager uploadManager = new UploadManager(cfg);
        Auth auth = Auth.create((String)qiniuOssConfig.getAccessKey(), (String)qiniuOssConfig.getSecretKey());
        BucketManager bucketManager = new BucketManager(auth, cfg);
        String upToken = auth.uploadToken(qiniuOssConfig.getBucketName());
        context.putAttach("uploadManager", uploadManager);
        context.putAttach("bucketManager", bucketManager);
        context.putAttach("upToken", upToken);
    }

    @Override
    protected UploadResult doUpload(UploadContext context) throws IOException {
        try {
            UploadManager uploadManager = (UploadManager)context.getAttach("uploadManager");
            String upToken = (String)context.getAttach("upToken");
            uploadManager.put(context.getResource().getInputStream(), context.getDir().substring(1) + context.getFilename(), upToken, null, null);
            return UploadResult.of(context);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (e instanceof QiniuException) {
                QiniuException qe = (QiniuException)((Object)e);
                try {
                    msg = qe.response.bodyString();
                }
                catch (QiniuException qiniuException) {
                    // empty catch block
                }
            }
            log.info("\u4e03\u725b\u4e91\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a", (Object)msg);
            throw new IOException(e);
        }
    }

    @Override
    public boolean doDelete(String path) throws IOException {
        Config.QiniuOssConfig qiniuOssConfig = this.getQiniuOssConfig();
        Configuration cfg = new Configuration();
        Auth auth = Auth.create((String)qiniuOssConfig.getAccessKey(), (String)qiniuOssConfig.getSecretKey());
        BucketManager bucketManager = new BucketManager(auth, cfg);
        try {
            bucketManager.delete(qiniuOssConfig.getBucketName(), path.substring(1));
            return true;
        }
        catch (QiniuException ex) {
            log.info("\u4e03\u725b\u4e91\u5220\u9664\u6587\u4ef6\u5931\u8d25\uff1a" + ex.response.toString());
            return false;
        }
    }

    @Override
    public File doDownload(String path, String dir) throws IOException {
        Config.QiniuOssConfig qiniuOssConfig = this.getQiniuOssConfig();
        Auth auth = Auth.create((String)qiniuOssConfig.getAccessKey(), (String)qiniuOssConfig.getSecretKey());
        String encodedFileName = path.substring(1);
        String publicUrl = String.format("%s/%s", qiniuOssConfig.getUrlPrefix(), encodedFileName);
        long expireInSeconds = 3600L;
        String finalUrl = auth.privateDownloadUrl(publicUrl, expireInSeconds);
        File file = DownloadUtil.download(finalUrl, dir);
        return file;
    }

    @Override
    public UploadResult doCopy(String path, String dir) throws IOException {
        Config.QiniuOssConfig qiniuOssConfig = this.getQiniuOssConfig();
        Auth auth = Auth.create((String)qiniuOssConfig.getAccessKey(), (String)qiniuOssConfig.getSecretKey());
        String encodedFileName = URLUtil.encode((String)path.substring(1));
        String publicUrl = String.format("%s/%s", qiniuOssConfig.getUrlPrefix(), encodedFileName);
        long expireInSeconds = 7200L;
        String finalUrl = auth.privateDownloadUrl(publicUrl, expireInSeconds);
        UrlResource urlResource = new UrlResource(finalUrl);
        UploadResult uploadResult = this.upload((Resource)urlResource, context -> context.setDir(dir));
        return uploadResult;
    }

    @Override
    public boolean exist(UploadContext context) {
        Config.QiniuOssConfig qiniuOssConfig = this.getQiniuOssConfig();
        BucketManager bucketManager = (BucketManager)context.getAttach("bucketManager");
        try {
            FileInfo fileInfo = bucketManager.stat(qiniuOssConfig.getBucketName(), context.getDir().substring(1) + context.getFilename());
            return fileInfo != null;
        }
        catch (QiniuException qiniuException) {
            return false;
        }
    }

    private Config.QiniuOssConfig getQiniuOssConfig() {
        return Config.getInstance().getQiniuOss();
    }

    private Config.QiniuOssConfig getQiniuOssConfig(UploadContext context) {
        return context.getConfig().getQiniuOss();
    }
}

