/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.resource.operator;

import cn.hutool.core.io.FileUtil;
import com.jeecms.utils.resource.Config;
import com.jeecms.utils.resource.operator.AbstractResourceOperator;
import com.jeecms.utils.resource.operator.UploadContext;
import com.jeecms.utils.resource.operator.UploadResult;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;

public class LocalResourceOperator
extends AbstractResourceOperator {
    @Override
    protected UploadResult doUpload(UploadContext context) throws IOException {
        try (InputStream inputStream = context.getResource().getInputStream();){
            FileUtil.writeFromStream((InputStream)inputStream, (String)(this.getLocalConfig().getStoreLocation() + context.getPath()));
        }
        return UploadResult.of(context);
    }

    @Override
    public boolean doDelete(String path) {
        return FileUtil.del((String)(this.getLocalConfig().getStoreLocation() + path));
    }

    @Override
    public UploadResult doCopy(String path, String dir) {
        String filename = FilenameUtils.getName((String)path);
        FileUtil.copy((String)(this.getLocalConfig().getStoreLocation() + path), (String)(this.getLocalConfig().getStoreLocation() + dir + filename), (boolean)true);
        String newPath = dir + filename;
        UploadResult uploadResult = new UploadResult(newPath, filename);
        return uploadResult;
    }

    @Override
    public UploadResult doMove(String path, String dir) {
        String filename = FilenameUtils.getName((String)path);
        FileUtil.move((File)new File(this.getLocalConfig().getStoreLocation() + path), (File)new File(this.getLocalConfig().getStoreLocation() + dir + filename), (boolean)true);
        String newPath = dir + filename;
        UploadResult uploadResult = new UploadResult(newPath, filename);
        return uploadResult;
    }

    @Override
    public File doDownload(String path, String dir) {
        String downloadPath;
        String originPath = this.getLocalConfig().getStoreLocation() + path;
        if (originPath.equals(downloadPath = dir + path)) {
            return new File(this.getLocalConfig().getStoreLocation() + path);
        }
        return FileUtil.copy((String)originPath, (String)downloadPath, (boolean)true);
    }

    @Override
    public boolean exist(UploadContext context) {
        return FileUtil.exist((String)(this.getLocalConfig().getStoreLocation() + context.getPath()));
    }

    private Config.LocalConfig getLocalConfig() {
        return Config.getInstance().getLocal();
    }
}

