/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.resource.operator;

import cn.hutool.core.io.IoUtil;
import cn.hutool.extra.ftp.Ftp;
import com.jeecms.utils.FileUtil;
import com.jeecms.utils.resource.Config;
import com.jeecms.utils.resource.operator.AbstractResourceOperator;
import com.jeecms.utils.resource.operator.UploadContext;
import com.jeecms.utils.resource.operator.UploadResult;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;

public class FtpResourceOperator
extends AbstractResourceOperator {
    @Override
    protected void openClient(UploadContext context) throws IOException {
        Ftp ftp = null;
        try {
            ftp = this.openFtp();
            context.putAttach("ftp", ftp);
        }
        catch (Exception e) {
            if (ftp != null) {
                try {
                    ftp.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            IOException ioException = e instanceof IOException ? (IOException)e : new IOException(e);
            throw ioException;
        }
    }

    @Override
    protected void closeClient(UploadContext context) {
        Ftp ftp = (Ftp)context.getAttach("ftp");
        IoUtil.close((Closeable)ftp);
    }

    @Override
    protected UploadResult doUpload(UploadContext context) throws IOException {
        Ftp ftp = (Ftp)context.getAttach("ftp");
        if (ftp.getClient() == null) {
            this.openClient(context);
            ftp = (Ftp)context.getAttach("ftp");
        }
        try (InputStream in = context.getResource().getInputStream();){
            ftp.upload(this.getFtpConfig().getDirPrefix() + context.getDir(), context.getFilename(), in);
        }
        return UploadResult.of(context);
    }

    @Override
    public boolean doDelete(String path) throws IOException {
        try (Ftp ftp = this.openFtp();){
            boolean b;
            String homePath = this.getHomePath(ftp);
            boolean bl = b = ftp.delFile(homePath + this.getFtpConfig().getDirPrefix() + path);
            return bl;
        }
    }

    @Override
    public UploadResult doCopy(String path, String dir) throws IOException {
        try (Ftp ftp = this.openFtp();){
            UploadResult uploadResult;
            String homePath = this.getHomePath(ftp);
            String filename = FilenameUtils.getName((String)path);
            File tempFile = FileUtil.touch((File)FileUtil.getTmpDir(), (String)filename);
            ftp.download(homePath + this.getFtpConfig().getDirPrefix() + path, tempFile);
            ftp.upload(this.getFtpConfig().getDirPrefix() + dir, tempFile);
            String newPath = dir + filename;
            UploadResult uploadResult2 = uploadResult = new UploadResult(newPath, filename);
            return uploadResult2;
        }
    }

    @Override
    public File doDownload(String path, String dir) throws IOException {
        try (Ftp ftp = this.openFtp();){
            String homePath = this.getHomePath(ftp);
            String filename = FileUtil.getName((String)path);
            File dest = FileUtil.touch((String)(dir + filename));
            ftp.download(homePath + this.getFtpConfig().getDirPrefix() + path, dest);
            File file = dest;
            return file;
        }
    }

    private Ftp openFtp() {
        Ftp ftp = new Ftp(this.getFtpConfig().getHost(), this.getFtpConfig().getPort(), this.getFtpConfig().getUsername(), this.getFtpConfig().getPassword());
        ftp.init().setBackToPwd(true);
        return ftp;
    }

    @Override
    public boolean exist(UploadContext context) {
        Ftp ftp = (Ftp)context.getAttach("ftp");
        return ftp.existFile(this.getFtpConfig().getDirPrefix() + context.getDir() + context.getFilename());
    }

    private Config.FtpConfig getFtpConfig() {
        return Config.getInstance().getFtp();
    }

    private String getHomePath(Ftp ftp) {
        String homePath = ftp.pwd() + "/";
        if (this.getFtpConfig().getDirPrefix().startsWith(homePath)) {
            homePath = "";
        }
        return homePath;
    }
}

