/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.resource.operator;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.GetObjectRequest;
import com.jeecms.utils.FileUtil;
import com.jeecms.utils.resource.Config;
import com.jeecms.utils.resource.operator.AbstractResourceOperator;
import com.jeecms.utils.resource.operator.UploadContext;
import com.jeecms.utils.resource.operator.UploadResult;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliOSSResourceOperator
extends AbstractResourceOperator {
    private static final Logger log = LoggerFactory.getLogger(AliOSSResourceOperator.class);

    @Override
    protected void openClient(UploadContext context) throws IOException {
        Config.AliOSSConfig aliOSSConfig = this.getAliOSSConfig(context);
        OSS ossClient = new OSSClientBuilder().build(aliOSSConfig.getEndpoint(), aliOSSConfig.getAccessKeyId(), aliOSSConfig.getAccessKeySecret());
        context.putAttach("alioss", ossClient);
    }

    @Override
    protected void closeClient(UploadContext context) {
        OSS ossClient = (OSS)context.getAttach("alioss");
        ossClient.shutdown();
    }

    @Override
    protected UploadResult doUpload(UploadContext context) throws IOException {
        Config.AliOSSConfig aliOSSConfig = this.getAliOSSConfig(context);
        OSS ossClient = (OSS)context.getAttach("alioss");
        try (InputStream in = context.getResource().getInputStream();){
            ossClient.putObject(aliOSSConfig.getBucketName(), context.getDir().substring(1) + context.getFilename(), in);
        }
        return UploadResult.of(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doDelete(String path) {
        Config.AliOSSConfig aliOSSConfig = this.getAliOSSConfig();
        OSS ossClient = null;
        try {
            ossClient = new OSSClientBuilder().build(aliOSSConfig.getEndpoint(), aliOSSConfig.getAccessKeyId(), aliOSSConfig.getAccessKeySecret());
            try {
                ossClient.deleteObject(aliOSSConfig.getBucketName(), path.substring(1));
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                boolean bl;
                block7: {
                    log.info("\u963f\u91cc\u4e91OSS\u5220\u9664\u6587\u4ef6\u5931\u8d25: [{}]", (Object)path, (Object)e);
                    bl = false;
                    if (ossClient == null) break block7;
                    ossClient.shutdown();
                }
                return bl;
            }
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
    }

    @Override
    public File doDownload(String path, String dir) throws IOException {
        File targetFile;
        Config.AliOSSConfig aliOSSConfig = this.getAliOSSConfig();
        OSS ossClient = null;
        try {
            ossClient = new OSSClientBuilder().build(aliOSSConfig.getEndpoint(), aliOSSConfig.getAccessKeyId(), aliOSSConfig.getAccessKeySecret());
            targetFile = FileUtil.touch((String)(dir + path));
            ossClient.getObject(new GetObjectRequest(aliOSSConfig.getBucketName(), path.substring(1)), targetFile);
        }
        catch (Exception e) {
            log.info("\u963f\u91cc\u4e91OSS\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new IOException(e);
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
        return targetFile;
    }

    @Override
    public boolean exist(UploadContext context) throws IOException {
        Config.AliOSSConfig aliOSSConfig = this.getAliOSSConfig(context);
        OSS ossClient = (OSS)context.getAttach("alioss");
        if (ossClient == null) {
            this.openClient(context);
            ossClient = (OSS)context.getAttach("alioss");
        }
        boolean found = ossClient.doesObjectExist(aliOSSConfig.getBucketName(), context.getDir().substring(1) + context.getFilename());
        return found;
    }

    private Config.AliOSSConfig getAliOSSConfig() {
        return Config.getInstance().getAliOss();
    }

    private Config.AliOSSConfig getAliOSSConfig(UploadContext context) {
        return context.getConfig().getAliOss();
    }
}

