/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.resource.operator;

import com.jeecms.utils.DownloadUtil;
import com.jeecms.utils.URLUtil;
import com.jeecms.utils.resource.Config;
import com.jeecms.utils.resource.ResourceUtil;
import com.jeecms.utils.resource.interceptor.ResourceInterceptor;
import com.jeecms.utils.resource.operator.ResourceOperator;
import com.jeecms.utils.resource.operator.UploadContext;
import com.jeecms.utils.resource.operator.UploadResult;
import com.jeecms.utils.resource.resolve.ResType;
import com.jeecms.utils.resource.store.IResourceStore;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public abstract class AbstractResourceOperator
implements ResourceOperator {
    private static final Logger log = LoggerFactory.getLogger(AbstractResourceOperator.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UploadResult upload(Resource resource, Consumer<UploadContext> consumer) throws IOException {
        UploadContext context = UploadContext.wrap(resource);
        int interceptorIdx = 0;
        UploadResult uploadResult = null;
        List<ResourceInterceptor> interceptors = context.getConfig().getInterceptors();
        try {
            this.openClient(context);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("\u8d44\u6e90\u4e0a\u4f20\u5f00\u542f\u5ba2\u6237\u7aef\u5931\u8d25\uff1a{}", context.getResourceOperator().getClass());
            }
            context.setException(e);
            try {
                this.closeClient(context);
            }
            catch (Exception exception) {
                // empty catch block
            }
            IOException ioException = e instanceof IOException ? (IOException)e : new IOException(e);
            throw ioException;
        }
        try {
            if (consumer != null) {
                consumer.accept(context);
            }
            try {
                while (interceptorIdx < interceptors.size()) {
                    if (log.isDebugEnabled()) {
                        log.debug("\u8d44\u6e90\u4e0a\u4f20\u62e6\u622a\u5668\u524d\u7f6e\u5904\u7406\uff1aidx {}, interceptor {}", (Object)interceptorIdx, interceptors.get(interceptorIdx).getClass());
                    }
                    interceptors.get(interceptorIdx).preHandler(context);
                    ++interceptorIdx;
                }
            }
            catch (Exception e) {
                context.setException(e);
                log.warn("\u8d44\u6e90\u4e0a\u4f20\u62e6\u622a\u5668\u524d\u7f6e\u5904\u7406\u5f02\u5e38\uff1a" + interceptors.get(interceptorIdx).getClass().getName(), (Throwable)e);
            }
            if (!context.hasException()) {
                try {
                    uploadResult = this.doUpload(context);
                    uploadResult.setLength(context.getContentLength());
                    uploadResult.setResType((ResType)((Object)context.getAttach("RES_TYPE")));
                    context.setUploadResult(uploadResult);
                    if (log.isDebugEnabled()) {
                        log.debug("\u8d44\u6e90\u4e0a\u4f20\u6210\u529f\uff1a\u6587\u4ef6\u540d[{}],  \u5b9e\u9645\u4e0a\u4f20\u540d[{}]", (Object)resource.getFilename(), (Object)context.getFilename());
                    }
                }
                catch (Exception e) {
                    context.setException(e);
                }
            }
            --interceptorIdx;
            while (interceptorIdx >= 0) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("\u8d44\u6e90\u4e0a\u4f20\u62e6\u622a\u5668\u540e\u7f6e\u5904\u7406\uff1aidx {}, interceptor {}", (Object)interceptorIdx, interceptors.get(interceptorIdx).getClass());
                    }
                    interceptors.get(interceptorIdx).postHandler(context);
                }
                catch (Exception e) {
                    context.setException(e);
                    log.warn("\u8d44\u6e90\u4e0a\u4f20\u62e6\u622a\u5668\u540e\u7f6e\u5904\u7406\u5f02\u5e38\uff1a" + interceptors.get(interceptorIdx).getClass().getName(), (Throwable)e);
                }
                --interceptorIdx;
            }
            if (context.hasException()) {
                IOException ioException;
                e = context.getException();
                if (e instanceof IOException) {
                    ioException = (IOException)e;
                } else {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    ioException = new IOException(e);
                }
                throw ioException;
            }
            if (log.isDebugEnabled()) {
                log.debug("\u4e0a\u4f20\u7ed3\u679c\uff1a{}", (Object)uploadResult);
            }
            UploadResult uploadResult2 = uploadResult;
            return uploadResult2;
        }
        finally {
            this.closeClient(context);
        }
    }

    protected void openClient(UploadContext context) throws IOException {
    }

    protected void closeClient(UploadContext context) throws IOException {
    }

    protected abstract UploadResult doUpload(UploadContext var1) throws IOException;

    @Override
    public boolean delete(Serializable mark) {
        Config config = Config.getInstance();
        IResourceStore resourceStore = config.getResourceStore();
        if (mark != null && mark instanceof Long) {
            mark = this.getUrlById(resourceStore, (Long)mark);
        }
        if (mark != null && mark instanceof String) {
            String strMark = (String)mark;
            if (strMark.startsWith("http")) {
                strMark = URLUtil.getPath(strMark);
            }
            if (strMark.startsWith("/")) {
                if (mark instanceof Long) {
                    resourceStore.remove((Serializable)mark);
                } else {
                    resourceStore.remove((Serializable)((Object)strMark));
                }
                try {
                    boolean delete = this.doDelete(this.clearPath(strMark));
                    return delete;
                }
                catch (IOException e) {
                    log.info("\u5220\u9664\u8d44\u6e90[{}]\u5931\u8d25", mark, (Object)e);
                    return false;
                }
            }
        }
        throw new IllegalArgumentException("\u65e0\u6cd5\u6839\u636emark[" + mark + "]\u5220\u9664\u8d44\u6e90");
    }

    protected abstract boolean doDelete(String var1) throws IOException;

    @Override
    public UploadResult copy(Serializable mark, String dir) throws IOException {
        Config config = Config.getInstance();
        IResourceStore resourceStore = config.getResourceStore();
        if (mark instanceof Long) {
            mark = this.getUrlById(resourceStore, (Long)mark);
        }
        if (mark instanceof String) {
            String strMark = (String)mark;
            if (strMark.startsWith("http")) {
                strMark = URLUtil.getPath(strMark);
            }
            if (strMark.startsWith("/")) {
                return this.doCopy(this.clearPath(strMark), this.unifyDir(dir));
            }
        }
        throw new IllegalArgumentException("\u65e0\u6cd5\u6839\u636emark[" + mark + "]\u590d\u5236\u8d44\u6e90");
    }

    public UploadResult doCopy(String path, String dir) throws IOException {
        File file = this.doDownload(path, dir);
        FileSystemResource resource = new FileSystemResource(file);
        UploadResult uploadResult = this.upload((Resource)resource, context -> context.setDir(dir));
        return uploadResult;
    }

    @Override
    public File download(Serializable mark, String dir) throws IOException {
        Config config = Config.getInstance();
        IResourceStore resourceStore = config.getResourceStore();
        if (mark != null && mark instanceof Long) {
            mark = this.getUrlById(resourceStore, (Long)mark);
        }
        if (mark != null && mark instanceof String) {
            String strMark = (String)mark;
            if (strMark.startsWith("http")) {
                return DownloadUtil.download(strMark, dir);
            }
            if (strMark.startsWith("/")) {
                return this.doDownload(this.clearPath(strMark), dir);
            }
        }
        throw new IllegalArgumentException("\u65e0\u6cd5\u6839\u636emark[" + mark + "]\u4e0b\u8f7d\u8d44\u6e90");
    }

    public File doDownload(String path, String dir) throws IOException {
        return DownloadUtil.download(ResourceUtil.accessUrl((Serializable)((Object)path)), dir);
    }

    @Override
    public UploadResult move(Serializable mark, String dir) throws IOException {
        Config config = Config.getInstance();
        IResourceStore resourceStore = config.getResourceStore();
        if (mark != null && mark instanceof Long) {
            mark = this.getUrlById(resourceStore, (Long)mark);
        }
        if (mark != null && mark instanceof String) {
            String strMark = (String)mark;
            if (strMark.startsWith("http")) {
                strMark = URLUtil.getPath(strMark);
            }
            if (strMark.startsWith("/")) {
                return this.doMove(this.clearPath(strMark), this.unifyDir(dir));
            }
        }
        throw new IllegalArgumentException("\u65e0\u6cd5\u6839\u636emark[" + mark + "]\u79fb\u52a8\u8d44\u6e90");
    }

    public UploadResult doMove(String path, String dir) throws IOException {
        UploadResult uploadResult = this.doCopy(path, dir);
        this.doDelete(path);
        return uploadResult;
    }

    public boolean exist(UploadContext context) throws IOException {
        return false;
    }

    public String getAlias(String originFileName, Long siteId, Long groupId, Integer originType) throws IOException {
        Config config = Config.getInstance();
        IResourceStore resourceStore = config.getResourceStore();
        return resourceStore.getAlias(originFileName, siteId, groupId, originType);
    }

    private String getUrlById(IResourceStore resourceStore, Long id) {
        if (resourceStore == null) {
            throw new IllegalArgumentException("\u672a\u914d\u7f6e\u8d44\u6e90\u5e93\uff0c\u65e0\u6cd5\u6839\u636eid\u67e5\u627e\u8d44\u6e90");
        }
        UploadResult uploadResult = resourceStore.getUploadResultById(id);
        if (uploadResult == null) {
            throw new IllegalArgumentException("\u8d44\u6e90\u5e93\u4e2d\u627e\u4e0d\u5230\u8d44\u6e90\uff1aid [" + id + "]");
        }
        return uploadResult.getUrl();
    }

    private String clearPath(String path) {
        int questionMarkIndex = path.indexOf(63);
        if (questionMarkIndex != -1) {
            return path.substring(0, questionMarkIndex);
        }
        return path;
    }

    private String unifyDir(String dir) {
        if (!(dir = dir.replaceAll("\\\\+", "/")).startsWith("/")) {
            dir = "/" + dir;
        }
        if (!dir.endsWith("/")) {
            dir = dir + "/";
        }
        return dir;
    }
}

