/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.resource.operator;

import com.alibaba.fastjson.JSONObject;
import com.jeecms.kit.JcResult;
import com.jeecms.utils.CollectionUtil;
import com.jeecms.utils.DownloadUtil;
import com.jeecms.utils.JcEncryptUtil;
import com.jeecms.utils.resource.Config;
import com.jeecms.utils.resource.endpoint.CopyDTO;
import com.jeecms.utils.resource.endpoint.DelDTO;
import com.jeecms.utils.resource.endpoint.GetUploadResultDTO;
import com.jeecms.utils.resource.endpoint.MoveDTO;
import com.jeecms.utils.resource.operator.ResourceOperator;
import com.jeecms.utils.resource.operator.UploadContext;
import com.jeecms.utils.resource.operator.UploadResult;
import com.jeecms.utils.resource.resolve.ResType;
import com.jeecms.utils.resource.store.IResourceStore;
import com.jeecms.utils.spring.WebUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class AbstractRemoteResourceOperator
implements ResourceOperator {
    private static final Logger log = LoggerFactory.getLogger(AbstractRemoteResourceOperator.class);

    @Override
    public UploadResult upload(@NotNull Resource resource, @Nullable Consumer<UploadContext> consumer) throws IOException {
        String uploadUrl = this.getUploadUrl();
        HttpHeaders headers = this.getDefaultHeader(uploadUrl);
        headers.setContentType(MediaType.parseMediaType((String)"multipart/form-data"));
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        form.add((Object)"files", (Object)resource);
        HttpEntity httpEntity = new HttpEntity((Object)form, (MultiValueMap)headers);
        ResponseEntity responseResponseEntity = this.getRestTemplate().postForEntity(uploadUrl, (Object)httpEntity, JcResult.class, new Object[0]);
        JcResult jcResult = (JcResult)responseResponseEntity.getBody();
        if (!jcResult.success()) {
            throw new IOException(jcResult.getMessage());
        }
        List maps = (List)jcResult.getData();
        List<UploadResult> uploadResults = this.convertMapsToResults(maps);
        return uploadResults.get(0);
    }

    @Override
    public boolean delete(@NotNull Serializable mark) {
        String url = this.getDeleteUrl();
        DelDTO delDTO = new DelDTO();
        delDTO.setMarks(Collections.singletonList(mark));
        HttpHeaders headers = this.getDefaultHeader(url);
        headers.set("Content-Type", "application/json;charset=UTF-8");
        HttpEntity requestEntity = new HttpEntity((Object)JSONObject.toJSONString((Object)delDTO), (MultiValueMap)headers);
        ResponseEntity resEntity = this.getRestTemplate().exchange(url, HttpMethod.POST, requestEntity, JcResult.class, new Object[0]);
        JcResult jcResult = (JcResult)resEntity.getBody();
        if (!jcResult.success()) {
            return false;
        }
        System.out.println(jcResult.getData());
        List booleans = (List)jcResult.getData();
        return (Boolean)booleans.get(0);
    }

    @Override
    public UploadResult copy(@NotNull Serializable mark, @NotNull String dir) throws IOException {
        String url = this.getCopyUrl();
        HttpHeaders headers = this.getDefaultHeader(url);
        headers.set("Content-Type", "application/json;charset=UTF-8");
        CopyDTO copyDTO = new CopyDTO();
        copyDTO.setMarks(Collections.singletonList(mark));
        copyDTO.setDir(dir);
        HttpEntity requestEntity = new HttpEntity((Object)JSONObject.toJSONString((Object)copyDTO), (MultiValueMap)headers);
        ResponseEntity resEntity = this.getRestTemplate().exchange(url, HttpMethod.POST, requestEntity, JcResult.class, new Object[0]);
        JcResult jcResult = (JcResult)resEntity.getBody();
        if (!jcResult.success()) {
            throw new IOException(jcResult.getMessage());
        }
        if (jcResult.getData() != null) {
            List maps = (List)jcResult.getData();
            List<UploadResult> uploadResults = this.convertMapsToResults(maps);
            return uploadResults.get(0);
        }
        return null;
    }

    @Override
    public UploadResult move(@NotNull Serializable mark, @NotNull String dir) throws IOException {
        String url = this.getMoveUrl();
        HttpHeaders headers = this.getDefaultHeader(url);
        headers.set("Content-Type", "application/json;charset=UTF-8");
        MoveDTO moveDTO = new MoveDTO();
        moveDTO.setMarks(Collections.singletonList(mark));
        moveDTO.setDir(dir);
        HttpEntity requestEntity = new HttpEntity((Object)JSONObject.toJSONString((Object)moveDTO), (MultiValueMap)headers);
        ResponseEntity resEntity = this.getRestTemplate().exchange(url, HttpMethod.POST, requestEntity, JcResult.class, new Object[0]);
        JcResult jcResult = (JcResult)resEntity.getBody();
        if (!jcResult.success()) {
            throw new IOException(jcResult.getMessage());
        }
        List maps = (List)jcResult.getData();
        List<UploadResult> uploadResults = this.convertMapsToResults(maps);
        return uploadResults.get(0);
    }

    @Override
    public File download(@NotNull Serializable mark, @NotNull String dir) {
        UploadResult uploadResult = this.getUploadResult(mark);
        return DownloadUtil.download(uploadResult.getUrl(), dir);
    }

    public UploadResult getUploadResult(Serializable mark) {
        if (mark == null) {
            return null;
        }
        List<UploadResult> uploadResults = this.getUploadResults(Collections.singletonList(mark));
        return uploadResults.get(0);
    }

    public List<UploadResult> getUploadResults(List<? extends Serializable> marks) {
        IResourceStore resourceStore = Config.getInstance().getResourceStore();
        if (resourceStore != null) {
            return resourceStore.getUploadResults(marks);
        }
        return this.getRemoteUploadResults(marks);
    }

    public List<UploadResult> getRemoteUploadResults(List<? extends Serializable> marks) {
        if (CollectionUtil.isEmpty(marks)) {
            return Collections.emptyList();
        }
        String url = this.getUploadResultUrl();
        HttpHeaders headers = this.getDefaultHeader(url);
        headers.set("Content-Type", "application/json;charset=UTF-8");
        GetUploadResultDTO downloadDTO = new GetUploadResultDTO();
        downloadDTO.setMarks(marks);
        log.info("\u53c2\u6570 ");
        HttpEntity requestEntity = new HttpEntity((Object)JSONObject.toJSONString((Object)downloadDTO), (MultiValueMap)headers);
        ResponseEntity resEntity = this.getRestTemplate().exchange(url, HttpMethod.POST, requestEntity, JcResult.class, new Object[0]);
        JcResult jcResult = (JcResult)resEntity.getBody();
        log.debug("\u67e5\u8be2Infra: \u53c2\u6570:{}  \u7ed3\u679c:{}", (Object)downloadDTO, (Object)jcResult);
        if (!jcResult.success()) {
            throw new RuntimeException(jcResult.getMessage());
        }
        List maps = (List)jcResult.getData();
        List<UploadResult> uploadResults = this.convertMapsToResults(maps);
        return uploadResults;
    }

    private String getReferer() {
        try {
            return WebUtil.currReferer();
        }
        catch (Exception e) {
            return "";
        }
    }

    private HttpHeaders getDefaultHeader(String url) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("remote-auth-token", this.getRemoteAuth(url));
        headers.add("Referer", this.getReferer());
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes != null) {
            HttpServletRequest request = attributes.getRequest();
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                headers.add(headerName, request.getHeader(headerName));
            }
        }
        return headers;
    }

    private List<UploadResult> convertMapsToResults(List<Map<String, Object>> maps) {
        List<UploadResult> results = maps.stream().map(m -> {
            Object resTypeObj;
            Object length;
            Object duration;
            Object storeType;
            String oriFilename;
            String filename;
            String coverUrl;
            String url;
            String path;
            UploadResult uploadResult = new UploadResult();
            String id = (String)m.get("id");
            if (StringUtils.isNotBlank((CharSequence)id)) {
                uploadResult.setId(Long.parseLong(id));
            }
            if (StringUtils.isNotBlank((CharSequence)(path = (String)m.get("path")))) {
                uploadResult.setPath(path);
            }
            if (StringUtils.isNotBlank((CharSequence)(url = (String)m.get("url")))) {
                uploadResult.setUrl(url);
            }
            if (StringUtils.isNotBlank((CharSequence)(coverUrl = (String)m.get("coverUrl")))) {
                uploadResult.setCoverUrl(coverUrl);
            }
            if (StringUtils.isNotBlank((CharSequence)(filename = (String)m.get("filename")))) {
                uploadResult.setFilename(filename);
            }
            if (StringUtils.isNotBlank((CharSequence)(oriFilename = (String)m.get("oriFilename")))) {
                uploadResult.setOriFilename(oriFilename);
            }
            if ((storeType = m.get("storeType")) != null && storeType instanceof Integer) {
                uploadResult.setStoreType((Integer)storeType);
            }
            if ((duration = m.get("duration")) != null && duration instanceof Number) {
                Number number = (Number)duration;
                uploadResult.setDuration(number.longValue());
            }
            if ((length = m.get("length")) != null && length instanceof Number) {
                Number number = (Number)length;
                uploadResult.setLength(number.longValue());
            }
            if ((resTypeObj = m.get("resType")) != null) {
                try {
                    ResType resType = ResType.valueOf(resTypeObj.toString());
                    uploadResult.setResType(resType);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return uploadResult;
        }).collect(Collectors.toList());
        return results;
    }

    private String getRemoteAuth(String url) {
        String auth = StringUtils.reverse((String)JcEncryptUtil.encrypt("tauthr", url));
        return auth;
    }

    protected abstract String getUploadUrl();

    protected abstract String getCopyUrl();

    protected abstract String getDeleteUrl();

    protected abstract String getMoveUrl();

    protected abstract String getUploadResultUrl();

    protected abstract RestTemplate getRestTemplate();
}

