/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.resource.interceptor;

import com.jeecms.utils.FileNameUtil;
import com.jeecms.utils.FileUtil;
import com.jeecms.utils.IdUtil;
import com.jeecms.utils.mediautil.MediaUtil;
import com.jeecms.utils.mediautil.VideoMetaInfo;
import com.jeecms.utils.resource.interceptor.ResourceInterceptor;
import com.jeecms.utils.resource.operator.AbstractResourceOperator;
import com.jeecms.utils.resource.operator.ResourceOperator;
import com.jeecms.utils.resource.operator.UploadContext;
import com.jeecms.utils.resource.operator.UploadResult;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class VideoCoverInterceptor
implements ResourceInterceptor {
    private static final Logger log = LoggerFactory.getLogger(VideoCoverInterceptor.class);

    @Override
    public void preHandler(UploadContext context) throws Exception {
        UploadResult imgUploadResult;
        if (!FileNameUtil.isVideo(context.getSuffix())) {
            return;
        }
        Resource videoResource = context.getResource();
        File videoFile = new File(FileUtil.getTmpDir(), context.getFilename());
        try (InputStream in = videoResource.getInputStream();){
            FileUtil.writeFromStream((InputStream)in, (File)videoFile);
        }
        catch (IOException e) {
            log.info("\u4fdd\u5b58\u89c6\u9891\u6587\u4ef6\u5230\u672c\u5730\u9519\u8bef", (Throwable)e);
            throw e;
        }
        VideoMetaInfo videoMetaInfo = MediaUtil.getVideoMetaInfo(videoFile);
        File imgFile = MediaUtil.cutVideoCover(videoFile, FileUtil.getTmpDirPath() + File.separator + IdUtil.getId() + ".jpg", 3000L);
        ResourceOperator resourceOperator = context.getResourceOperator();
        if (resourceOperator instanceof AbstractResourceOperator) {
            AbstractResourceOperator abstractResourceOperator = (AbstractResourceOperator)resourceOperator;
            imgUploadResult = abstractResourceOperator.upload((Resource)new FileSystemResource(imgFile), ctx -> ctx.getAttachMap().putAll(context.getAttachMap()));
        } else {
            imgUploadResult = resourceOperator.upload((Resource)new FileSystemResource(imgFile));
        }
        context.putAttach("COVER_URL", imgUploadResult.getUrl());
        context.putAttach("DURATION", videoMetaInfo.getDuration());
        context.putAttach("Video_File", videoFile);
        context.putAttach("Video_Cover_File", imgFile);
    }

    @Override
    public void postHandler(UploadContext context) throws Exception {
        if (!FileNameUtil.isVideo(context.getSuffix())) {
            return;
        }
        try {
            File videoFile = (File)context.getAttach("Video_File");
            FileUtil.del((File)videoFile);
        }
        catch (Exception videoFile) {
            // empty catch block
        }
        try {
            File videoCoverFile = (File)context.getAttach("Video_Cover_File");
            FileUtil.del((File)videoCoverFile);
        }
        catch (Exception videoCoverFile) {
            // empty catch block
        }
        if (context.hasException()) {
            return;
        }
        UploadResult uploadResult = context.getUploadResult();
        uploadResult.setCoverUrl((String)context.getAttach("COVER_URL"));
        uploadResult.setDuration((Long)context.getAttach("DURATION"));
    }
}

