/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.resource.interceptor;

import com.jeecms.exception.GlobalRuntimeException;
import com.jeecms.exception.error.CoreErrs;
import com.jeecms.utils.resource.interceptor.ResourceInterceptor;
import com.jeecms.utils.resource.operator.UploadContext;
import com.jeecms.utils.syscontext.BaseSysConf;
import com.jeecms.utils.syscontext.BaseSysUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidResourceInterceptor
implements ResourceInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ValidResourceInterceptor.class);

    @Override
    public void preHandler(UploadContext context) throws Exception {
        block14: {
            try {
                BaseSysConf sysConf = BaseSysUtil.getSysConfig();
                String fileSuffix = context.getSuffix();
                if (StringUtils.isBlank((CharSequence)fileSuffix)) {
                    log.info("\u6587\u4ef6\u683c\u5f0f\u9519\u8bef");
                    throw new GlobalRuntimeException(CoreErrs.UPLOAD_VALID_ERR);
                }
                if (sysConf.getAllowPicTypes().contains(fileSuffix)) {
                    long maxSize = sysConf.getMaxPicSize();
                    long actualSize = context.getContentLength();
                    if (maxSize > 0L && actualSize > maxSize) {
                        log.info("\u8d85\u51fa\u56fe\u7247\u6587\u4ef6\u5927\u5c0f\u9650\u5236: \u6700\u5927:[{}]  \u5b9e\u9645:[{}]", (Object)maxSize, (Object)actualSize);
                        throw new GlobalRuntimeException(CoreErrs.UPLOAD_TOO_LARGE);
                    }
                    break block14;
                }
                if (sysConf.getAllowDocTypes().contains(fileSuffix)) {
                    long maxSize = sysConf.getMaxDocSize();
                    long actualSize = context.getContentLength();
                    if (maxSize > 0L && actualSize > maxSize) {
                        log.info("\u8d85\u51fa\u6587\u6863\u6587\u4ef6\u5927\u5c0f\u9650\u5236: \u6700\u5927:[{}]  \u5b9e\u9645:[{}]", (Object)maxSize, (Object)actualSize);
                        throw new GlobalRuntimeException(CoreErrs.UPLOAD_TOO_LARGE);
                    }
                    break block14;
                }
                if (sysConf.getAllowVideoTypes().contains(fileSuffix)) {
                    long maxSize = sysConf.getMaxVideoSize();
                    long actualSize = context.getContentLength();
                    if (maxSize > 0L && actualSize > maxSize) {
                        log.info("\u8d85\u51fa\u89c6\u9891\u6587\u4ef6\u5927\u5c0f\u9650\u5236: \u6700\u5927:[{}]  \u5b9e\u9645:[{}]", (Object)maxSize, (Object)actualSize);
                        throw new GlobalRuntimeException(CoreErrs.UPLOAD_TOO_LARGE);
                    }
                    break block14;
                }
                if (sysConf.getAllowAudioTypes().contains(fileSuffix)) {
                    long maxSize = sysConf.getMaxAudioSize();
                    long actualSize = context.getContentLength();
                    if (maxSize > 0L && actualSize > maxSize) {
                        log.info("\u8d85\u51fa\u97f3\u9891\u6587\u4ef6\u5927\u5c0f\u9650\u5236: \u6700\u5927:[{}]  \u5b9e\u9645:[{}]", (Object)maxSize, (Object)actualSize);
                        throw new GlobalRuntimeException(CoreErrs.UPLOAD_TOO_LARGE);
                    }
                    break block14;
                }
                if (sysConf.getAttachCtlType() != 1 && sysConf.getAttachCtlType() != 2) break block14;
                boolean contains = sysConf.getAttachCtlTypes().contains(fileSuffix);
                if (sysConf.getAttachCtlType() == 1) {
                    boolean bl = contains = !contains;
                }
                if (contains) {
                    long maxSize = sysConf.getMaxAttachSize();
                    long actualSize = context.getContentLength();
                    if (maxSize > 0L && actualSize > maxSize) {
                        log.info("\u8d85\u51fa\u9644\u4ef6\u5927\u5c0f\u9650\u5236: \u6700\u5927:[{}]  \u5b9e\u9645:[{}]", (Object)maxSize, (Object)actualSize);
                        throw new GlobalRuntimeException(CoreErrs.UPLOAD_TOO_LARGE);
                    }
                    break block14;
                }
                log.info("\u4e0d\u88ab\u5141\u8bb8\u4e0a\u4f20\u7684\u6587\u4ef6\u7c7b\u578b: [{}]", (Object)fileSuffix);
                throw new GlobalRuntimeException(CoreErrs.UPLOAD_VALID_ERR);
            }
            catch (Exception e) {
                log.error("\u6587\u4ef6\u4e0a\u4f20\u683c\u5f0f\u548c\u5927\u5c0f\u6821\u9a8c\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                throw e;
            }
        }
    }
}

