/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.resource.interceptor;

import com.jeecms.utils.FileNameUtil;
import com.jeecms.utils.FileTypeUtil;
import com.jeecms.utils.resource.interceptor.ResourceInterceptor;
import com.jeecms.utils.resource.operator.UploadContext;
import com.jeecms.utils.resource.resolve.ResType;
import com.jeecms.utils.syscontext.BaseSysConf;
import com.jeecms.utils.syscontext.BaseSysUtil;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.Resource;

public class ResourceTypeInterceptor
implements ResourceInterceptor {
    @Override
    public void preHandler(UploadContext context) throws IOException {
        Resource resource = context.getResource();
        try (InputStream in = resource.getInputStream();){
            String realType = FileTypeUtil.getType(in, context.getSuffix());
            String suffix = context.getSuffix();
            String reType = null;
            reType = suffix;
            if (!suffix.equals(suffix.toLowerCase())) {
                reType = suffix.toLowerCase();
            }
            if (StringUtils.isNotBlank((CharSequence)reType)) {
                context.setFilename(FileNameUtil.replaceSuffix(context.getOriFilename(), reType));
            }
            context.putAttach("RES_TYPE", (Object)ResourceTypeInterceptor.classify(realType));
        }
    }

    private static ResType classify(String realType) {
        BaseSysConf sysConf = BaseSysUtil.getSysConfig();
        ResType resType = sysConf.getAllowPicTypes().contains(realType) ? ResType.IMG : (sysConf.getAllowDocTypes().contains(realType) ? ResType.DOC : (sysConf.getAllowAudioTypes().contains(realType) ? ResType.AUDIO : (sysConf.getAllowVideoTypes().contains(realType) ? ResType.VIDEO : ResType.ATTACH)));
        return resType;
    }
}

