/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.resource.interceptor;

import com.jeecms.utils.DateUtil;
import com.jeecms.utils.resource.interceptor.ResourceInterceptor;
import com.jeecms.utils.resource.operator.AbstractResourceOperator;
import com.jeecms.utils.resource.operator.ResourceOperator;
import com.jeecms.utils.resource.operator.UploadContext;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class RenameOnExistInterceptor
implements ResourceInterceptor {
    @Override
    public void preHandler(UploadContext context) throws Exception {
        ResourceOperator resourceOperator = context.getResourceOperator();
        if (resourceOperator instanceof AbstractResourceOperator) {
            AbstractResourceOperator abstractResourceOperator = (AbstractResourceOperator)resourceOperator;
            while (abstractResourceOperator.exist(context)) {
                context.setFilename(this.nextFilename(context));
            }
        }
    }

    protected String nextFilename(UploadContext context) {
        if (StringUtils.isBlank((CharSequence)context.getOriFilename())) {
            return Long.toHexString(DateUtil.currentSeconds() - 1592668800L) + ".data";
        }
        int nameNo = (Integer)context.getAttach("NAME_NO");
        context.putAttach("NAME_NO", ++nameNo);
        String originFilename = context.getResource().getFilename();
        String baseName = FilenameUtils.getBaseName((String)originFilename);
        String extension = FilenameUtils.getExtension((String)originFilename);
        String dot = StringUtils.isBlank((CharSequence)extension) ? "" : ".";
        return String.format("%s_%s%s%s", baseName, nameNo, dot, extension);
    }
}

