/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.resource.interceptor;

import com.jeecms.utils.FileNameUtil;
import com.jeecms.utils.FileUtil;
import com.jeecms.utils.mediautil.MediaUtil;
import com.jeecms.utils.mediautil.MusicMetaInfo;
import com.jeecms.utils.resource.interceptor.ResourceInterceptor;
import com.jeecms.utils.resource.operator.UploadContext;
import com.jeecms.utils.resource.operator.UploadResult;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class AudioResourceInterceptor
implements ResourceInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AudioResourceInterceptor.class);

    @Override
    public void preHandler(UploadContext context) throws Exception {
        if (!FileNameUtil.isAudio(context.getSuffix())) {
            return;
        }
        Resource audioResource = context.getResource();
        File audioFile = new File(FileUtil.getTmpDir(), context.getFilename());
        try (InputStream in = audioResource.getInputStream();){
            FileUtil.writeFromStream((InputStream)in, (File)audioFile);
        }
        catch (IOException e) {
            log.info("\u4fdd\u5b58\u97f3\u9891\u6587\u4ef6\u5230\u672c\u5730\u9519\u8bef", (Throwable)e);
            throw e;
        }
        MusicMetaInfo musicMetaInfo = MediaUtil.getMusicMetaInfo(audioFile);
        context.putAttach("DURATION", musicMetaInfo.getDuration());
        context.putAttach("Audio_File", audioFile);
    }

    @Override
    public void postHandler(UploadContext context) throws Exception {
        if (!FileNameUtil.isAudio(context.getSuffix())) {
            return;
        }
        try {
            File audioFile = (File)context.getAttach("Audio_File");
            FileUtil.del((File)audioFile);
        }
        catch (Exception audioFile) {
            // empty catch block
        }
        if (context.hasException()) {
            return;
        }
        UploadResult uploadResult = context.getUploadResult();
        uploadResult.setDuration((Long)context.getAttach("DURATION"));
    }
}

