/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.resource.endpoint;

import cn.hutool.core.lang.Assert;
import com.jeecms.kit.JcResult;
import com.jeecms.lang.MultipartFileResource;
import com.jeecms.utils.CollectionUtil;
import com.jeecms.utils.JcEncryptUtil;
import com.jeecms.utils.resource.ResourceUtil;
import com.jeecms.utils.resource.endpoint.CopyDTO;
import com.jeecms.utils.resource.endpoint.DelDTO;
import com.jeecms.utils.resource.endpoint.GetUploadResultDTO;
import com.jeecms.utils.resource.endpoint.MoveDTO;
import com.jeecms.utils.resource.operator.UploadResult;
import com.jeecms.utils.spring.SpringUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import springfox.documentation.annotations.ApiIgnore;

@ApiIgnore
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@RestController
public class FileUploadEndpoint {
    private static final Logger log = LoggerFactory.getLogger(FileUploadEndpoint.class);

    @PostMapping(value={"/innerRes/upload"})
    public JcResult<List<UploadResult>> fileUpload(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="files") MultipartFile[] files) throws IOException {
        if (!FileUploadEndpoint.check(request, response)) {
            return JcResult.ok();
        }
        Assert.notEmpty((Object[])files, (String)"\u8bf7\u9009\u62e9\u6587\u4ef6", (Object[])new Object[0]);
        List<Resource> resourceList = Arrays.stream(files).peek(mf -> {
            if (mf.isEmpty()) {
                throw new IllegalArgumentException("\u7a7a\u6587\u4ef6");
            }
        }).map(MultipartFileResource::new).collect(Collectors.toList());
        List<UploadResult> uploadResults = ResourceUtil.upload(resourceList);
        return JcResult.ok(uploadResults);
    }

    @PostMapping(value={"/innerRes/del"})
    public JcResult<List<Boolean>> delFile(HttpServletRequest request, HttpServletResponse response, @RequestBody @Validated DelDTO delDTO) throws IOException {
        if (!FileUploadEndpoint.check(request, response)) {
            return JcResult.ok();
        }
        if (CollectionUtil.isEmpty(delDTO.getMarks())) {
            return JcResult.ok(Collections.emptyList());
        }
        FileUploadEndpoint.fixMarks(delDTO.getMarks());
        List<Boolean> booleans = ResourceUtil.delete(delDTO.getMarks());
        return JcResult.ok(booleans);
    }

    @PostMapping(value={"/innerRes/cp"})
    public JcResult<List<UploadResult>> cpFile(HttpServletRequest request, HttpServletResponse response, @RequestBody @Valid CopyDTO copyDTO) throws IOException {
        if (!FileUploadEndpoint.check(request, response)) {
            return JcResult.ok();
        }
        if (CollectionUtil.isEmpty(copyDTO.getMarks())) {
            return JcResult.ok(Collections.emptyList());
        }
        FileUploadEndpoint.fixMarks(copyDTO.getMarks());
        List<UploadResult> uploadResults = ResourceUtil.copy(copyDTO.getMarks(), copyDTO.getDir());
        return JcResult.ok(uploadResults);
    }

    @PostMapping(value={"/innerRes/mv"})
    public JcResult<List<UploadResult>> mvFile(HttpServletRequest request, HttpServletResponse response, @RequestBody @Valid MoveDTO moveDTO) throws IOException {
        if (!FileUploadEndpoint.check(request, response)) {
            return JcResult.ok();
        }
        if (CollectionUtil.isEmpty(moveDTO.getMarks())) {
            return JcResult.ok(Collections.emptyList());
        }
        FileUploadEndpoint.fixMarks(moveDTO.getMarks());
        List<UploadResult> uploadResults = ResourceUtil.move(moveDTO.getMarks(), moveDTO.getDir());
        return JcResult.ok(uploadResults);
    }

    @PostMapping(value={"/innerRes/ur"})
    public JcResult<List<UploadResult>> getUploadResult(HttpServletRequest request, HttpServletResponse response, @RequestBody @Valid GetUploadResultDTO dto) throws IOException {
        long t3 = System.currentTimeMillis();
        if (!FileUploadEndpoint.check(request, response)) {
            return JcResult.ok();
        }
        if (CollectionUtil.isEmpty(dto.getMarks())) {
            return JcResult.ok(Collections.emptyList());
        }
        FileUploadEndpoint.fixMarks(dto.getMarks());
        log.debug("\u67e5\u8be2\u8d44\u6e90\uff1a{}", (Object)dto);
        List<UploadResult> uploadResults = ResourceUtil.getUploadResult(dto.getMarks());
        log.debug("\u67e5\u8be2\u7ed3\u679c\uff1a{}", uploadResults);
        long t4 = System.currentTimeMillis();
        System.out.println("t4-t3->" + (t4 - t3));
        return JcResult.ok(uploadResults);
    }

    private static boolean check(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String authToken = request.getHeader("remote-auth-token");
        String requestUrl = request.getRequestURL().toString();
        String requestUtl2 = requestUrl.replaceAll("//(.*?)/", "//" + SpringUtil.getApplicationName() + "/");
        try {
            String decrypt = JcEncryptUtil.decrypt("tauthr", StringUtils.reverse((String)authToken));
            if (requestUrl.equalsIgnoreCase(decrypt) || requestUtl2.equalsIgnoreCase(decrypt)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        response.sendError(HttpStatus.NOT_FOUND.value());
        return false;
    }

    private static void fixMarks(List<? extends Serializable> marks) {
        List<? extends Serializable> ms = marks;
        for (int i = 0; i < ms.size(); ++i) {
            Serializable serializable = ms.get(i);
            if (!(serializable instanceof Number) || serializable instanceof Long) continue;
            Number number = (Number)serializable;
            ms.set(i, (Serializable)number.longValue());
        }
    }
}

