/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.resource;

import cn.hutool.core.util.ArrayUtil;
import com.jeecms.utils.CollectionUtil;
import com.jeecms.utils.FileUtil;
import com.jeecms.utils.resource.Config;
import com.jeecms.utils.resource.EmptyUploadResult;
import com.jeecms.utils.resource.UploadStrategy;
import com.jeecms.utils.resource.dto.ResourceDto;
import com.jeecms.utils.resource.operator.AbstractRemoteResourceOperator;
import com.jeecms.utils.resource.operator.ResourceOperator;
import com.jeecms.utils.resource.operator.UploadContext;
import com.jeecms.utils.resource.operator.UploadResult;
import com.jeecms.utils.resource.store.IResourceStore;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.core.io.Resource;

public class ResourceUtil {
    public static List<UploadResult> upload(Collection<Resource> resources) throws IOException {
        ArrayList<UploadResult> results = new ArrayList<UploadResult>(resources.size());
        for (Resource resource : resources) {
            results.add(ResourceUtil.upload(resource));
        }
        return results;
    }

    public static List<UploadResult> upload(Resource[] resources) throws IOException {
        return ResourceUtil.upload(Arrays.asList(resources));
    }

    public static UploadResult upload(Resource resource) throws IOException {
        return Config.getInstance().getResourceOperator().upload(resource);
    }

    public static UploadResult upload(Resource resource, Consumer<UploadContext> consumer) throws IOException {
        return Config.getInstance().getResourceOperator().upload(resource, consumer);
    }

    public static boolean delete(Serializable mark) {
        return Config.getInstance().getResourceOperator().delete(mark);
    }

    public static List<Boolean> delete(Serializable[] marks) {
        return ResourceUtil.delete(Arrays.asList(marks));
    }

    public static List<Boolean> delete(Collection<? extends Serializable> marks) {
        return CollectionUtil.convert(marks, ResourceUtil::delete);
    }

    public static boolean deleteByResStoreType(ResourceDto mark) {
        return Config.getInstance().getResourceOperator(Character.valueOf(mark.getStoreType().toString().charAt(0))).delete(mark.getMask());
    }

    public static List<Boolean> deleteByResStoreType(Collection<? extends ResourceDto> marks) {
        return CollectionUtil.convert(marks, ResourceUtil::deleteByResStoreType);
    }

    public static UploadResult copy(Serializable mark, String dir) throws IOException {
        return Config.getInstance().getResourceOperator().copy(mark, dir);
    }

    public static List<UploadResult> copy(Serializable[] marks, String dir) throws IOException {
        return ResourceUtil.copy(Arrays.asList(marks), dir);
    }

    public static List<UploadResult> copy(List<? extends Serializable> marks, String dir) throws IOException {
        ArrayList<UploadResult> uploadResults = new ArrayList<UploadResult>(marks.size());
        for (Serializable serializable : marks) {
            UploadResult uploadResult = ResourceUtil.copy(serializable, dir);
            uploadResults.add(uploadResult);
        }
        return uploadResults;
    }

    public static UploadResult move(Serializable mark, String dir) throws IOException {
        return Config.getInstance().getResourceOperator().move(mark, dir);
    }

    public static List<UploadResult> move(Serializable[] marks, String dir) throws IOException {
        return ResourceUtil.move(Arrays.asList(marks), dir);
    }

    public static List<UploadResult> move(List<? extends Serializable> marks, String dir) throws IOException {
        ArrayList<UploadResult> uploadResults = new ArrayList<UploadResult>(marks.size());
        for (Serializable serializable : marks) {
            UploadResult uploadResult = ResourceUtil.move(serializable, dir);
            uploadResults.add(uploadResult);
        }
        return uploadResults;
    }

    public static File download(Serializable mark) throws IOException {
        return ResourceUtil.download(Collections.singletonList(mark)).get(0);
    }

    public static List<File> download(Serializable[] marks) throws IOException {
        return ResourceUtil.download(Arrays.asList(marks));
    }

    public static List<File> download(List<? extends Serializable> marks) throws IOException {
        return ResourceUtil.download(marks, FileUtil.getTmpDirPath());
    }

    public static File download(Serializable mark, String dir) throws IOException {
        return Config.getInstance().getResourceOperator().download(mark, dir);
    }

    public static List<File> download(Serializable[] marks, String dir) throws IOException {
        return ResourceUtil.download(Arrays.asList(marks), dir);
    }

    public static List<File> download(List<? extends Serializable> marks, String dir) throws IOException {
        ArrayList<File> files = new ArrayList<File>(marks.size());
        for (Serializable serializable : marks) {
            File file = ResourceUtil.download(serializable, dir);
            files.add(file);
        }
        return files;
    }

    public static UploadResult getUploadResult(Serializable mark) {
        if (mark == null) {
            return null;
        }
        Config config = Config.getInstance();
        ResourceOperator resourceOperator = config.getResourceOperator();
        if (resourceOperator instanceof AbstractRemoteResourceOperator) {
            UploadResult uploadResult = ((AbstractRemoteResourceOperator)resourceOperator).getUploadResult(mark);
            return uploadResult;
        }
        IResourceStore resourceStore = config.getResourceStore();
        if (mark instanceof Long) {
            Long id = (Long)mark;
            return resourceStore.getUploadResultById(id);
        }
        if (mark instanceof String) {
            String markStr = (String)((Object)mark);
            if (markStr.startsWith("http")) {
                return resourceStore.getUploadResultByUrl(markStr);
            }
            return resourceStore.getUploadResultByPath(markStr);
        }
        return EmptyUploadResult.INSTANCE;
    }

    public static List<UploadResult> getUploadResult(Serializable ... marks) {
        if (ArrayUtil.isEmpty((Object[])marks)) {
            return Collections.emptyList();
        }
        return ResourceUtil.getUploadResult(Arrays.asList(marks));
    }

    public static List<UploadResult> getUploadResult(List<? extends Serializable> marks) {
        if (CollectionUtil.isEmpty(marks)) {
            return Collections.emptyList();
        }
        Config config = Config.getInstance();
        ResourceOperator resourceOperator = config.getResourceOperator();
        if (resourceOperator instanceof AbstractRemoteResourceOperator) {
            List<UploadResult> uploadResults = ((AbstractRemoteResourceOperator)resourceOperator).getUploadResults(marks);
            return uploadResults;
        }
        IResourceStore resourceStore = config.getResourceStore();
        return resourceStore.getUploadResults(marks);
    }

    public static String accessUrl(Serializable mark) {
        UploadResult uploadResult = ResourceUtil.getUploadResult(mark);
        return uploadResult != null ? uploadResult.getUrl() : "";
    }

    public static List<String> accessUrl(Serializable ... marks) {
        return ResourceUtil.accessUrl(Arrays.asList(marks));
    }

    public static List<String> accessUrl(List<? extends Serializable> marks) {
        return CollectionUtil.convert(marks, ResourceUtil::accessUrl);
    }

    public static String getUrlPrefix() {
        return ResourceUtil.getUrlPrefix(Config.getInstance().getStrategy());
    }

    public static String getUrlPrefix(UploadStrategy uploadStrategy) {
        switch (uploadStrategy) {
            case LOCAL: {
                return Config.getInstance().getLocal().getUrlPrefix();
            }
            case FTP: {
                return Config.getInstance().getFtp().getUrlPrefix();
            }
            case ALI_OSS: {
                return Config.getInstance().getAliOss().getUrlPrefix();
            }
            case TENCENT_COS: {
                return Config.getInstance().getTencentCos().getUrlPrefix();
            }
            case QINIU_OSS: {
                return Config.getInstance().getQiniuOss().getUrlPrefix();
            }
            case REMOTE: 
            case RPC: {
                throw new RuntimeException("\u8fdc\u7aef\u8d44\u6e90\u65e0\u6cd5\u83b7\u53d6URL\u524d\u7f00");
            }
        }
        throw new RuntimeException("\u65e0\u6cd5\u83b7\u53d6URL\u524d\u7f00\uff1a" + (Object)((Object)uploadStrategy));
    }

    public static int getStoreType() {
        return Character.digit(Config.getInstance().getStrategy().getFlag(), 10);
    }
}

