/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.resource;

import com.jeecms.utils.resource.UploadStrategy;
import com.jeecms.utils.resource.UrlSpliceStrategy;
import com.jeecms.utils.resource.interceptor.ResourceInterceptor;
import com.jeecms.utils.resource.operator.ResourceOperator;
import com.jeecms.utils.resource.store.IResourceStore;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.context.annotation.Lazy;

public class Config {
    private static volatile Object config;
    private static Supplier<Config> configSupplier;
    private List<ResourceInterceptor> interceptors = new ArrayList<ResourceInterceptor>();
    private IResourceStore resourceStore;
    private UploadStrategy strategy = UploadStrategy.LOCAL;
    private Map<Character, UploadStrategy> strategyMap = new HashMap<Character, UploadStrategy>();
    private UrlSpliceStrategy urlSpliceStrategy = UrlSpliceStrategy.DYNAMIC;
    @NestedConfigurationProperty
    private LocalConfig local = new LocalConfig();
    @NestedConfigurationProperty
    private RemoteConfig remote = new RemoteConfig();
    @NestedConfigurationProperty
    private RPCConfig rpc = new RPCConfig();
    @NestedConfigurationProperty
    private FtpConfig ftp = new FtpConfig();
    @NestedConfigurationProperty
    private AliOSSConfig aliOss = new AliOSSConfig();
    @NestedConfigurationProperty
    private TencentCOSConfig tencentCos = new TencentCOSConfig();
    @NestedConfigurationProperty
    private QiniuOssConfig qiniuOss = new QiniuOssConfig();

    public static void setConfigSupplier(Supplier<Config> configSupplier) {
        Config.configSupplier = configSupplier;
    }

    @Lazy
    @Autowired
    public void setConfig(Config config) {
        Config.config = config;
    }

    public static Config getInstance() {
        return configSupplier.get();
    }

    private static String fixUrlPrefix(String urlPrefix) {
        if (!urlPrefix.startsWith("http://") && !urlPrefix.startsWith("https://")) {
            urlPrefix = "http://" + urlPrefix;
        }
        if (urlPrefix.endsWith("/")) {
            urlPrefix = urlPrefix.replaceAll("/+$", "");
        }
        return urlPrefix;
    }

    public Map<Character, UploadStrategy> getStrategyMap() {
        return this.strategyMap;
    }

    public void setStrategyMap(Map<Character, UploadStrategy> strategyMap) {
        this.strategyMap = strategyMap;
    }

    public UploadStrategy getStrategy() {
        return this.strategy;
    }

    public UrlSpliceStrategy getUrlSpliceStrategy() {
        return this.urlSpliceStrategy;
    }

    public LocalConfig getLocal() {
        return this.local;
    }

    public RemoteConfig getRemote() {
        return this.remote;
    }

    public FtpConfig getFtp() {
        return this.ftp;
    }

    public AliOSSConfig getAliOss() {
        return this.aliOss;
    }

    public TencentCOSConfig getTencentCos() {
        return this.tencentCos;
    }

    public QiniuOssConfig getQiniuOss() {
        return this.qiniuOss;
    }

    public void setStrategy(UploadStrategy strategy) {
        this.strategy = strategy;
    }

    public void setUrlSpliceStrategy(UrlSpliceStrategy urlSpliceStrategy) {
        this.urlSpliceStrategy = urlSpliceStrategy;
    }

    public void setLocal(LocalConfig local) {
        this.local = local;
    }

    public void setRemote(RemoteConfig remote) {
        this.remote = remote;
    }

    public void setFtp(FtpConfig ftp) {
        this.ftp = ftp;
    }

    public void setAliOss(AliOSSConfig aliOss) {
        this.aliOss = aliOss;
    }

    public void setTencentCos(TencentCOSConfig tencentCos) {
        this.tencentCos = tencentCos;
    }

    public void setQiniuOss(QiniuOssConfig qiniuOss) {
        this.qiniuOss = qiniuOss;
    }

    public RPCConfig getRpc() {
        return this.rpc;
    }

    public void setRpc(RPCConfig rpc) {
        this.rpc = rpc;
    }

    public List<ResourceInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List<ResourceInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public ResourceOperator getResourceOperator() {
        return Config.getInstance().getStrategy().getUploader();
    }

    public ResourceOperator getResourceOperator(Character storeType) {
        return Config.getInstance().getStrategyMap().get(storeType).getUploader();
    }

    public IResourceStore getResourceStore() {
        return this.resourceStore;
    }

    public void setResourceStore(IResourceStore resourceStore) {
        this.resourceStore = resourceStore;
    }

    public String toString() {
        return "Config(strategy=" + (Object)((Object)this.getStrategy()) + ", urlSpliceStrategy=" + (Object)((Object)this.getUrlSpliceStrategy()) + ", local=" + this.getLocal() + ", remote=" + this.getRemote() + ", ftp=" + this.getFtp() + ", aliOss=" + this.getAliOss() + ", tencentCos=" + this.getTencentCos() + ", qiniuOss=" + this.getQiniuOss() + ")";
    }

    static {
        configSupplier = () -> {
            if (config != null) return (Config)config;
            Class<Config> clazz = Config.class;
            synchronized (Config.class) {
                if (config != null) return (Config)config;
                config = new Config();
                // ** MonitorExit[var0] (shouldn't be in output)
                return (Config)config;
            }
        };
    }

    public static class QiniuOssConfig {
        String accessKey;
        String secretKey;
        String bucketName;
        String urlPrefix;

        public String getAccessKey() {
            return this.accessKey;
        }

        public String getSecretKey() {
            return this.secretKey;
        }

        public String getBucketName() {
            return this.bucketName;
        }

        public String getUrlPrefix() {
            return this.urlPrefix;
        }

        public void setAccessKey(String accessKey) {
            this.accessKey = accessKey;
        }

        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public void setUrlPrefix(String urlPrefix) {
            this.urlPrefix = Config.fixUrlPrefix(urlPrefix);
        }

        public String toString() {
            return "Config.QiniuOssConfig(accessKey=" + this.getAccessKey() + ", secretKey=" + this.getSecretKey() + ", bucketName=" + this.getBucketName() + ", urlPrefix=" + this.getUrlPrefix() + ")";
        }
    }

    public static class TencentCOSConfig {
        String secretId;
        String secretKey;
        String region;
        String bucketName;
        String urlPrefix;

        public String getUrlPrefix() {
            return this.urlPrefix;
        }

        public void setUrlPrefix(String urlPrefix) {
            this.urlPrefix = Config.fixUrlPrefix(urlPrefix);
        }

        public String getSecretId() {
            return this.secretId;
        }

        public String getSecretKey() {
            return this.secretKey;
        }

        public String getRegion() {
            return this.region;
        }

        public String getBucketName() {
            return this.bucketName;
        }

        public void setSecretId(String secretId) {
            this.secretId = secretId;
        }

        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public void setRegion(String region) {
            this.region = region;
        }

        public void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public String toString() {
            return "Config.TencentCOSConfig(secretId=" + this.getSecretId() + ", secretKey=" + this.getSecretKey() + ", region=" + this.getRegion() + ", bucketName=" + this.getBucketName() + ")";
        }
    }

    public static class AliOSSConfig {
        private String accessKeyId;
        private String accessKeySecret;
        private String endpoint;
        private String bucketName;
        private String urlPrefix;

        public void setUrlPrefix(String urlPrefix) {
            this.urlPrefix = Config.fixUrlPrefix(urlPrefix);
        }

        public String getUrlPrefix() {
            return this.urlPrefix;
        }

        public String getAccessKeyId() {
            return this.accessKeyId;
        }

        public String getAccessKeySecret() {
            return this.accessKeySecret;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public String getBucketName() {
            return this.bucketName;
        }

        public void setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
        }

        public void setAccessKeySecret(String accessKeySecret) {
            this.accessKeySecret = accessKeySecret;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public String toString() {
            return "Config.AliOSSConfig(accessKeyId=" + this.getAccessKeyId() + ", accessKeySecret=" + this.getAccessKeySecret() + ", endpoint=" + this.getEndpoint() + ", bucketName=" + this.getBucketName() + ")";
        }
    }

    public static class FtpConfig {
        private String host = "127.0.0.1";
        private int port = 21;
        private String username = "ftpuser";
        private String password = "ftpuser";
        private String dirPrefix = ".";
        private String urlPrefix;

        public void setUrlPrefix(String urlPrefix) {
            this.urlPrefix = Config.fixUrlPrefix(urlPrefix);
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public String getDirPrefix() {
            return this.dirPrefix;
        }

        public String getUrlPrefix() {
            return this.urlPrefix;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setDirPrefix(String dirPrefix) {
            this.dirPrefix = dirPrefix;
        }

        public String toString() {
            return "Config.FtpConfig(host=" + this.getHost() + ", port=" + this.getPort() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", dirPrefix=" + this.getDirPrefix() + ", urlPrefix=" + this.getUrlPrefix() + ")";
        }
    }

    public static class RPCConfig {
        private String serviceId;

        public String getServiceId() {
            return this.serviceId;
        }

        public void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }
    }

    public static class RemoteConfig {
        private String host = "127.0.0.1";
        private int port = 80;

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public String toString() {
            return "Config.RemoteConfig(host=" + this.getHost() + ", port=" + this.getPort() + ")";
        }
    }

    public static class LocalConfig {
        private String storeLocation;
        private String urlPrefix;

        public void setUrlPrefix(String urlPrefix) {
            this.urlPrefix = Config.fixUrlPrefix(urlPrefix);
        }

        public void setStoreLocation(String storeLocation) {
            if (!storeLocation.endsWith(File.separator)) {
                storeLocation = storeLocation + File.separator;
            }
            this.storeLocation = storeLocation;
        }

        public String getStoreLocation() {
            return this.storeLocation;
        }

        public String getUrlPrefix() {
            return this.urlPrefix;
        }

        public String toString() {
            return "Config.LocalConfig(storeLocation=" + this.getStoreLocation() + ", urlPrefix=" + this.getUrlPrefix() + ")";
        }
    }
}

