/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.releaseproject;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.net.NetUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jeecms.utils.FileUtil;
import com.jeecms.utils.ResourceLoaderUtil;
import com.jeecms.utils.releaseproject.Pm2Data;
import com.jeecms.utils.releaseproject.RuntimeUtil;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReleaseUtil {
    private static final Logger log = LoggerFactory.getLogger(ReleaseUtil.class);
    public static final String PREVIEW = "preview";
    public static final String RELEASE = "release";
    public static final String PROJECT_ARCHIVE_NAME = "demo.zip";
    public static final String PROJECT_NAME = "demo";
    public static final String BASE_PROJECT_PATH = "/home/saas";
    public static final String PM2_JSON = "pm2.json";

    public static void main(String[] args) throws InterruptedException {
    }

    public static void modifyPm2FilePort(String path, int port, String name) {
        boolean usableLocalPort = NetUtil.isUsableLocalPort((int)port);
        if (!usableLocalPort) {
            throw new RuntimeException("\u7aef\u53e3\u88ab\u5360\u7528");
        }
        path = path + "/" + PM2_JSON;
        String s = FileUtil.readUtf8String((String)path);
        JSONObject jsonObject = (JSONObject)JSON.parseObject((String)s, JSONObject.class);
        jsonObject.put("name", (Object)name);
        JSONObject env = jsonObject.getJSONObject("env");
        env.put("NODE_PORT", (Object)port);
        String s1 = jsonObject.toJSONString();
        FileUtil.writeAll(s1, new File(path));
        System.out.println(s);
    }

    public static String previewCopyBaseProject(Long siteId) {
        InputStream inputStream = ResourceLoaderUtil.loadClasspathResource(PROJECT_ARCHIVE_NAME);
        String path = "/home/saas/" + siteId + "/" + PREVIEW;
        System.out.println("path :" + path);
        String zipPath = path + "/" + PROJECT_ARCHIVE_NAME;
        log.info("zipPath {}:", (Object)zipPath);
        FileUtil.writeFromStream((InputStream)inputStream, (File)new File(zipPath));
        RuntimeUtil.execForStr(new File(path), "unzip demo.zip");
        boolean exist = FileUtil.exist((String)(path + "/" + PM2_JSON));
        if (!exist) {
            throw new RuntimeException("\u524d\u7aef\u9879\u76ee\u6587\u4ef6\u89e3\u538b\u5931\u8d25");
        }
        return path + "/";
    }

    public static String copyBaseProject(Long siteId) {
        InputStream inputStream = ResourceLoaderUtil.loadClasspathResource(PROJECT_ARCHIVE_NAME);
        String path = "/home/saas/" + siteId + "/" + RELEASE;
        String zipPath = path + "/" + PROJECT_ARCHIVE_NAME;
        FileUtil.writeFromStream((InputStream)inputStream, (File)new File(zipPath));
        System.out.println("\u538b\u7f29\u8def\u5f84 path\uff1a" + path);
        RuntimeUtil.execForStr(new File(path), "unzip demo.zip");
        if (!FileUtil.exist((String)(path + "//" + PM2_JSON))) {
            throw new RuntimeException("\u524d\u7aef\u9879\u76ee\u6587\u4ef6\u89e3\u538b\u5931\u8d25");
        }
        return path + "/";
    }

    public static void startupProject(String path) {
        RuntimeUtil.execForStr(new File(path), "npm install");
        RuntimeUtil.execForStr(new File(path), "npm run prod");
    }

    public static List<Pm2Data> pm2DataList(List<String> lines) {
        List lines1 = lines.stream().filter(o -> o.startsWith("\u2502")).collect(Collectors.toList());
        String headerStr = (String)lines1.get(0);
        if (!(headerStr = headerStr.substring(1, headerStr.length() - 1)).contains("id") || !headerStr.contains("name")) {
            throw new RuntimeException("\u67e5\u770bpm2 status\u51fa\u73b0\u5f02\u5e38");
        }
        String[] headers = (String[])Arrays.stream(headerStr.split("\u2502")).map(String::trim).map(s -> {
            if ("\u21ba".equals(s)) {
                return "refresh";
            }
            return s;
        }).toArray(String[]::new);
        ArrayList pm2DataList = CollectionUtil.newArrayList((Object[])new Pm2Data[0]);
        for (int i = 1; i < lines1.size(); ++i) {
            String valueStr = (String)lines1.get(i);
            String[] values = (String[])Arrays.stream((valueStr = valueStr.substring(1, valueStr.length() - 1)).split("\u2502")).map(String::trim).toArray(String[]::new);
            if (headers.length != values.length) {
                throw new RuntimeException("\u957f\u5ea6\u4e0d\u5339\u914d");
            }
            pm2DataList.add(Pm2Data.of(headers, values));
        }
        return pm2DataList;
    }
}

