/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.notify;

import com.jeecms.utils.CollectionUtil;
import com.jeecms.utils.TextTemplate;
import com.jeecms.utils.notify.AbstractNotify;
import com.jeecms.utils.notify.IMessageTemplate;
import com.jeecms.utils.notify.IWebSiteMessageTemplate;
import com.jeecms.utils.notify.MessageTemplateHelper;
import com.jeecms.utils.sitemessage.SiteMessageUtil;
import com.jeecms.utils.sitemessage.dto.SaveSiteMessageDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSiteNotify
extends AbstractNotify {
    private static final Logger log = LoggerFactory.getLogger(WebSiteNotify.class);

    @Override
    public void send(String templateSymbol, Map<String, String> vals, Collection<String> targets) {
        String subject;
        IWebSiteMessageTemplate webSiteMessageTemplate = this.getBySymbol(templateSymbol);
        if (!this.matchSendTime(webSiteMessageTemplate) || webSiteMessageTemplate.isEnable() == 0) {
            return;
        }
        SaveSiteMessageDTO saveSiteMessageDTO = new SaveSiteMessageDTO();
        saveSiteMessageDTO.setTypeId(webSiteMessageTemplate.getMessageType());
        saveSiteMessageDTO.setTitle(webSiteMessageTemplate.getTitle());
        List<Long> recipientIds = CollectionUtil.isEmpty(targets) ? new ArrayList<Long>(webSiteMessageTemplate.getUserIds()) : targets.stream().map(Long::parseLong).collect(Collectors.toList());
        saveSiteMessageDTO.setRecipientIds(recipientIds);
        saveSiteMessageDTO.setContent(TextTemplate.mold(webSiteMessageTemplate.getWebSiteTemplate(), vals));
        saveSiteMessageDTO.setLinkAddr(vals.get("linkAddr"));
        String siteId = vals.get("siteId");
        if (siteId != null) {
            saveSiteMessageDTO.setSiteId(Long.parseLong(siteId));
        }
        if (StringUtils.isBlank((CharSequence)(subject = vals.get("subject")))) {
            throw new IllegalArgumentException("[\u6536\u4ef6\u4eba\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        saveSiteMessageDTO.setSubject(Integer.parseInt(subject));
        if (log.isDebugEnabled()) {
            log.debug("\u7ad9\u5185\u4fe1\u53d1\u9001\u53c2\u6570\uff1a[{}]", (Object)saveSiteMessageDTO);
        }
        SiteMessageUtil.send(saveSiteMessageDTO);
    }

    protected IWebSiteMessageTemplate getBySymbol(String templateSymbol) {
        return MessageTemplateHelper.getWebSiteTemplateBySymbol(templateSymbol);
    }

    @Override
    protected void send(String title, String notifyContent, Collection<String> targets) {
    }

    @Override
    protected String fetchTemplateFromMessageTemplate(IMessageTemplate messageTemplate) {
        return null;
    }

    @Override
    protected String fetchTitleFromMessageTemplate(IMessageTemplate messageTemplate) {
        return null;
    }
}

