/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.notify;

import com.jeecms.utils.notify.Notify;
import com.jeecms.utils.notify.NotifyEnum;
import com.jeecms.utils.notify.NotifyFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class NotifyUtil {
    private NotifyUtil() {
    }

    public static void sendNotify(NotifyEnum notifyEnum, String templateSymbol, Map<String, String> vals, String target) {
        NotifyUtil.sendNotify(notifyEnum, templateSymbol, vals, StringUtils.isNotBlank((CharSequence)target) ? Collections.singletonList(target) : Collections.emptyList());
    }

    public static void sendNotify(NotifyEnum notifyEnum, String templateSymbol, Map<String, String> vals, Collection<String> targetes) {
        Notify notify = NotifyFactory.createNotify(notifyEnum);
        notify.send(templateSymbol, vals, targetes);
    }

    public static void sendSmsNotify(String templateSymbol, Map<String, String> vals, String phone) {
        NotifyUtil.sendSmsNotify(templateSymbol, vals, StringUtils.isNotBlank((CharSequence)phone) ? Collections.singletonList(phone) : Collections.emptyList());
    }

    public static void sendSmsNotify(String templateSymbol, Map<String, String> vals, Collection<String> phones) {
        NotifyUtil.sendNotify(NotifyEnum.SMS, templateSymbol, vals, phones);
    }

    public static void sendEmailNotify(String templateSymbol, Map<String, String> vals, String emailAddress) {
        NotifyUtil.sendEmailNotify(templateSymbol, vals, StringUtils.isNotBlank((CharSequence)emailAddress) ? Collections.singletonList(emailAddress) : Collections.emptyList());
    }

    public static void sendEmailNotify(String templateSymbol, Map<String, String> vals, Collection<String> emailAddresses) {
        NotifyUtil.sendNotify(NotifyEnum.EMAIL, templateSymbol, vals, emailAddresses);
    }

    public static void sendWebSiteNotify(String templateSymbol, Map<String, String> vals, String targete) {
        NotifyUtil.sendWebSiteNotify(templateSymbol, vals, StringUtils.isNotBlank((CharSequence)targete) ? Collections.singletonList(targete) : Collections.emptyList());
    }

    public static void sendWebSiteNotify(String templateSymbol, Map<String, String> vals, Collection<String> targetes) {
        NotifyUtil.sendNotify(NotifyEnum.WEBSITE, templateSymbol, vals, targetes);
    }

    public static void sendCorpWechatNotify(String templateSymbol, Map<String, String> vals, Collection<String> targetes) {
        NotifyUtil.sendNotify(NotifyEnum.CORP_WECHAT, templateSymbol, vals, targetes);
    }
}

