/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.notify;

import com.jeecms.utils.notify.CorpWechatNotify;
import com.jeecms.utils.notify.EmailNotify;
import com.jeecms.utils.notify.Notify;
import com.jeecms.utils.notify.NotifyEnum;
import com.jeecms.utils.notify.SmsNotify;
import com.jeecms.utils.notify.WebSiteNotify;
import java.util.HashMap;
import java.util.Map;

class NotifyFactory {
    private static Map<NotifyEnum, Notify> notifyMap = new HashMap<NotifyEnum, Notify>();

    NotifyFactory() {
    }

    static Notify createNotify(NotifyEnum notifyEnum) {
        return NotifyFactory.getNotifyFromCache(notifyEnum);
    }

    private static Notify getNotifyFromCache(NotifyEnum notifyEnum) {
        return notifyMap.computeIfAbsent(notifyEnum, NotifyFactory::createNotify0);
    }

    private static Notify createNotify0(NotifyEnum notifyEnum) {
        switch (notifyEnum) {
            case SMS: {
                return new SmsNotify();
            }
            case EMAIL: {
                return new EmailNotify();
            }
            case WEBSITE: {
                return new WebSiteNotify();
            }
            case CORP_WECHAT: {
                return new CorpWechatNotify();
            }
        }
        return null;
    }
}

