/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.notify;

import com.jeecms.utils.notify.ICorpWechatMessageTemplate;
import com.jeecms.utils.notify.IEmailMessageTemplate;
import com.jeecms.utils.notify.IMessageTemplate;
import com.jeecms.utils.notify.IMessageTemplateFetcher;
import com.jeecms.utils.notify.ISmsMessageTemplate;
import com.jeecms.utils.notify.IWebSiteMessageTemplate;
import com.jeecms.utils.spring.SpringUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;

class MessageTemplateHelper {
    private static volatile Collection<IMessageTemplateFetcher> fetchers;

    MessageTemplateHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Collection<IMessageTemplateFetcher> getFetchers() {
        if (fetchers != null) return fetchers;
        Class<MessageTemplateHelper> clazz = MessageTemplateHelper.class;
        synchronized (MessageTemplateHelper.class) {
            if (fetchers != null) return fetchers;
            Map<String, IMessageTemplateFetcher> beansOfType = SpringUtil.getBeansOfType(IMessageTemplateFetcher.class);
            fetchers = beansOfType.values();
            // ** MonitorExit[var0] (shouldn't be in output)
            return fetchers;
        }
    }

    private static <T extends IMessageTemplate> boolean isExpectMessageTemplateFetcher(IMessageTemplateFetcher<?> fetcher, Class<T> expectMessageTemplateClass) {
        Type[] genericInterfaces = fetcher.getClass().getGenericInterfaces();
        ParameterizedType parameterizedType = (ParameterizedType)genericInterfaces[0];
        Class actualTypeArgument = (Class)parameterizedType.getActualTypeArguments()[0];
        return expectMessageTemplateClass.isAssignableFrom(actualTypeArgument);
    }

    private static <T extends IMessageTemplate> T getExpectMessageTemplateBySymbol(String symbol, Class<T> expectMessageTemplateClass) {
        for (IMessageTemplateFetcher fetcher : MessageTemplateHelper.getFetchers()) {
            Object template;
            if (!MessageTemplateHelper.isExpectMessageTemplateFetcher(fetcher, expectMessageTemplateClass) || (template = fetcher.getBySymbol(symbol)) == null) continue;
            return template;
        }
        return null;
    }

    static <T extends IMessageTemplate> T getBySymbol(String symbol) {
        for (IMessageTemplateFetcher fetcher : MessageTemplateHelper.getFetchers()) {
            Object template = fetcher.getBySymbol(symbol);
            if (template == null) continue;
            return template;
        }
        return null;
    }

    static IEmailMessageTemplate getEmailTemplateBySymbol(String symbol) {
        return MessageTemplateHelper.getExpectMessageTemplateBySymbol(symbol, IEmailMessageTemplate.class);
    }

    static ISmsMessageTemplate getSmsTemplateBySymbol(String symbol) {
        return MessageTemplateHelper.getExpectMessageTemplateBySymbol(symbol, ISmsMessageTemplate.class);
    }

    static IWebSiteMessageTemplate getWebSiteTemplateBySymbol(String symbol) {
        return MessageTemplateHelper.getExpectMessageTemplateBySymbol(symbol, IWebSiteMessageTemplate.class);
    }

    static ICorpWechatMessageTemplate getCorpWechatTemplateBySymBol(String symbol) {
        return MessageTemplateHelper.getExpectMessageTemplateBySymbol(symbol, ICorpWechatMessageTemplate.class);
    }
}

