/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.notify;

import com.jeecms.utils.EmailUtil;
import com.jeecms.utils.notify.AbstractNotify;
import com.jeecms.utils.notify.IEmailMessageTemplate;
import com.jeecms.utils.notify.IMessageTemplate;
import com.jeecms.utils.notify.MessageTemplateHelper;
import java.io.File;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EmailNotify
extends AbstractNotify {
    private static final Logger log = LoggerFactory.getLogger(EmailNotify.class);

    EmailNotify() {
    }

    @Override
    protected void send(String title, String notifyContent, Collection<String> targets) {
        EmailUtil.sendHtml(targets, title, notifyContent, new File[0]);
    }

    protected IMessageTemplate getBySymbol(String templateSymbol) {
        return MessageTemplateHelper.getEmailTemplateBySymbol(templateSymbol);
    }

    @Override
    protected String fetchTemplateFromMessageTemplate(IMessageTemplate messageTemplate) {
        if (messageTemplate instanceof IEmailMessageTemplate) {
            return ((IEmailMessageTemplate)messageTemplate).getEmailTemplate();
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6a21\u677f\u7c7b\u578b");
    }

    @Override
    protected String fetchTitleFromMessageTemplate(IMessageTemplate messageTemplate) {
        if (messageTemplate instanceof IEmailMessageTemplate) {
            return ((IEmailMessageTemplate)messageTemplate).getEmailTitle();
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6a21\u677f\u7c7b\u578b");
    }
}

