/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.notify;

import com.jeecms.utils.TextTemplate;
import com.jeecms.utils.corpwechat.util.CorpWechatUtils;
import com.jeecms.utils.notify.AbstractNotify;
import com.jeecms.utils.notify.ICorpWechatMessageTemplate;
import com.jeecms.utils.notify.IMessageTemplate;
import com.jeecms.utils.notify.ISmsMessageTemplate;
import com.jeecms.utils.notify.MessageTemplateHelper;
import java.util.Collection;
import java.util.Map;

class CorpWechatNotify
extends AbstractNotify {
    CorpWechatNotify() {
    }

    @Override
    public void send(String templateSymbol, Map<String, String> vals, Collection<String> targets) {
        ICorpWechatMessageTemplate corpWechatMessageTemplate = this.getBySymbol(templateSymbol);
        if (!this.matchSendTime(corpWechatMessageTemplate) || corpWechatMessageTemplate.isEnable() == 0) {
            return;
        }
        CorpWechatUtils.sendTextMessageAll(TextTemplate.mold(corpWechatMessageTemplate.getCorpWechatTemplate(), vals), 0);
    }

    @Override
    public void send(String title, String notifyContent, Collection<String> user) {
    }

    protected ICorpWechatMessageTemplate getBySymbol(String templateSymbol) {
        return MessageTemplateHelper.getCorpWechatTemplateBySymBol(templateSymbol);
    }

    @Override
    protected String fetchTemplateFromMessageTemplate(IMessageTemplate messageTemplate) {
        if (messageTemplate instanceof ICorpWechatMessageTemplate) {
            return ((ISmsMessageTemplate)messageTemplate).getSmsTemplate();
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6a21\u677f\u7c7b\u578b");
    }

    @Override
    protected String fetchTitleFromMessageTemplate(IMessageTemplate messageTemplate) {
        return "";
    }
}

