/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.notify;

import com.jeecms.utils.Assert;
import com.jeecms.utils.DateUtil;
import com.jeecms.utils.TextTemplate;
import com.jeecms.utils.notify.IMessageTemplate;
import com.jeecms.utils.notify.MessageTemplateHelper;
import com.jeecms.utils.notify.Notify;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractNotify
implements Notify {
    private static final Logger log = LoggerFactory.getLogger(AbstractNotify.class);

    AbstractNotify() {
    }

    @Override
    public void send(String templateSymbol, Map<String, String> vals, Collection<String> targets) {
        Assert.notBlank((CharSequence)templateSymbol, (String)"\u6a21\u677f\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\u5b57\u7b26\u4e32", (Object[])new Object[0]);
        Assert.notEmpty(targets, (String)"\u901a\u77e5\u76ee\u6807\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Object messageTemplate = this.getBySymbol(templateSymbol);
        if (messageTemplate == null) {
            throw new IllegalArgumentException("\u6d88\u606f\u6a21\u677f\u4e0d\u5b58\u5728: symbol: [" + templateSymbol + "]");
        }
        if (!this.matchSendTime((IMessageTemplate)messageTemplate) || messageTemplate.isEnable() == 0) {
            return;
        }
        String template = this.fetchTemplateFromMessageTemplate((IMessageTemplate)messageTemplate);
        String title = this.fetchTitleFromMessageTemplate((IMessageTemplate)messageTemplate);
        String msg = TextTemplate.mold(template, vals);
        targets = targets.stream().distinct().collect(Collectors.toList());
        log.debug("\u53d1\u9001\u901a\u77e5: \u76ee\u6807:[{}],  \u5185\u5bb9:[{}]", (Object)targets, (Object)msg);
        this.send(title, msg, (Collection<String>)targets);
    }

    protected abstract void send(String var1, String var2, Collection<String> var3);

    protected <T extends IMessageTemplate> T getBySymbol(String templateSymbol) {
        return MessageTemplateHelper.getBySymbol(templateSymbol);
    }

    protected abstract String fetchTemplateFromMessageTemplate(IMessageTemplate var1);

    protected abstract String fetchTitleFromMessageTemplate(IMessageTemplate var1);

    protected boolean matchSendTime(IMessageTemplate messageTemplate) {
        LocalDateTime notifyTimeStart = messageTemplate.notifyTimeStart();
        LocalDateTime notifyTimeEnd = messageTemplate.notifyTimeEnd();
        if (notifyTimeStart == null || notifyTimeEnd == null) {
            return true;
        }
        return DateUtil.isIn(LocalDateTime.now(), notifyTimeStart, notifyTimeEnd);
    }
}

