/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.mediautil.enums;

import java.util.HashSet;
import java.util.Set;

public enum PresetValueEnum {
    MAX_FAST_ZIP_SPEED("\u6700\u5feb\u538b\u7f29\u901f\u5ea6\uff0c\u6700\u4f4e\u538b\u7f29\u7387", "faster"),
    SECOND_FAST_ZIP_SPEED("\u7b2c\u4e8c\u5feb\u7684\u538b\u7f29\u901f\u5ea6", "fast"),
    MEDIUM_ZIP_SPEED("\u4e2d\u7b49\u538b\u7f29\u901f\u5ea6", "medium"),
    SLOW_ZIP_SPEED("\u4f4e\u538b\u7f29\u901f\u5ea6", "slow"),
    SLOWER_ZIP_SPEED("\u6700\u6162\u538b\u7f29\u901f\u5ea6", "slower");

    private String presetName;
    private String presetValue;
    private static Set<String> TYPE_VALUE_SET;

    private PresetValueEnum(String presetName, String presetValue) {
        this.presetName = presetName;
        this.presetValue = presetValue;
    }

    public static boolean isValid(String typeValue) {
        return TYPE_VALUE_SET.contains(typeValue);
    }

    public static PresetValueEnum convertoEnum(String typeValue) {
        if (!PresetValueEnum.isValid(typeValue)) {
            return null;
        }
        for (PresetValueEnum type : PresetValueEnum.values()) {
            if (!typeValue.equals(type.getPresetValue())) continue;
            return type;
        }
        return null;
    }

    public boolean isEqual(String typeValue) {
        if (typeValue == null) {
            return false;
        }
        return this.getPresetValue().equals(typeValue);
    }

    public String getPresetName() {
        return this.presetName;
    }

    public void setPresetName(String presetName) {
        this.presetName = presetName;
    }

    public String getPresetValue() {
        return this.presetValue;
    }

    public void setPresetValue(String presetValue) {
        this.presetValue = presetValue;
    }

    public static Set<String> getTypeValueSet() {
        return TYPE_VALUE_SET;
    }

    public static void setTypeValueSet(Set<String> typeValueSet) {
        TYPE_VALUE_SET = typeValueSet;
    }

    static {
        TYPE_VALUE_SET = new HashSet<String>();
        PresetValueEnum[] types = PresetValueEnum.values();
        if (null != types) {
            for (PresetValueEnum type : types) {
                TYPE_VALUE_SET.add(type.getPresetValue());
            }
        }
    }
}

