/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.mediautil.enums;

import java.util.HashSet;
import java.util.Set;

public enum CrfValueEnum {
    LOW_QUALITY("\u4f4e\u8d28\u91cf", 28),
    MEDIUM_QUALITY("\u4e2d\u7b49\u8d28\u91cf", 26),
    HIGH_QUALITY("\u9ad8\u8d28\u91cf", 23);

    private String name;
    private Integer code;
    private static Set<Integer> TYPE_CODE_SET;

    private CrfValueEnum(String typeName, Integer typeCode) {
        this.name = typeName;
        this.code = typeCode;
    }

    public static boolean isValid(Integer typeCode) {
        return TYPE_CODE_SET.contains(typeCode);
    }

    public static CrfValueEnum convertoEnum(Integer typeCode) {
        if (!CrfValueEnum.isValid(typeCode)) {
            return null;
        }
        for (CrfValueEnum type : CrfValueEnum.values()) {
            if (!typeCode.equals(type.getCode())) continue;
            return type;
        }
        return null;
    }

    public boolean isEqual(Integer typeCode) {
        if (typeCode == null) {
            return false;
        }
        return this.getCode().equals(typeCode);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public static Set<Integer> getTypeCodeSet() {
        return TYPE_CODE_SET;
    }

    public static void setTypeCodeSet(Set<Integer> typeCodeSet) {
        TYPE_CODE_SET = typeCodeSet;
    }

    static {
        TYPE_CODE_SET = new HashSet<Integer>();
        CrfValueEnum[] types = CrfValueEnum.values();
        if (null != types) {
            for (CrfValueEnum type : types) {
                TYPE_CODE_SET.add(type.getCode());
            }
        }
    }
}

