/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.lambda;

import com.jeecms.utils.lambda.anno.SerializableFunction;
import java.beans.Introspector;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.time.LocalDateTime;

public class LambdaUtil {
    public static <R> R doNothing(Object ... objs) {
        return null;
    }

    public static <R> R nop(Object ... objs) {
        return null;
    }

    public static <R, E extends Throwable> R doThrow(Throwable e) throws E {
        throw e;
    }

    public static <R, E extends Throwable> R raise(Throwable e) throws E {
        throw e;
    }

    public static <T> T doThrow(DoThrowWrapper<T> doThrowWrapper) {
        try {
            return doThrowWrapper.get();
        }
        catch (Throwable throwable) {
            return (T)LambdaUtil.doThrow(throwable);
        }
    }

    public static void doThrow(DoThrowWrapper2 doThrowWrapper) {
        try {
            doThrowWrapper.run();
        }
        catch (Throwable throwable) {
            LambdaUtil.doThrow(throwable);
        }
    }

    public static <T> T raise(DoThrowWrapper<T> doThrowWrapper) {
        return LambdaUtil.doThrow(doThrowWrapper);
    }

    public static void raise(DoThrowWrapper2 doThrowWrapper) {
        LambdaUtil.doThrow(doThrowWrapper);
    }

    public static String getOriginName(Serializable lambda) {
        try {
            Method writeReplace = lambda.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            writeReplace.setAccessible(true);
            SerializedLambda serializedLambda = (SerializedLambda)writeReplace.invoke((Object)lambda, new Object[0]);
            String getter = serializedLambda.getImplMethodName();
            return getter;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String getMethodSignatureClass(Serializable lambda) {
        try {
            Method writeReplace = lambda.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            writeReplace.setAccessible(true);
            SerializedLambda serializedLambda = (SerializedLambda)writeReplace.invoke((Object)lambda, new Object[0]);
            String instantiatedMethodType = serializedLambda.getInstantiatedMethodType();
            return instantiatedMethodType.substring(instantiatedMethodType.lastIndexOf("/") + 1, instantiatedMethodType.length() - 1);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Class getReturnType(SerializableFunction lambda) {
        try {
            Method writeReplace = lambda.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            writeReplace.setAccessible(true);
            SerializedLambda serializedLambda = (SerializedLambda)writeReplace.invoke((Object)lambda, new Object[0]);
            String instantiatedMethodType = serializedLambda.getInstantiatedMethodType();
            int idx = instantiatedMethodType.indexOf(")L");
            String className = instantiatedMethodType.substring(idx + 2, instantiatedMethodType.length() - 1).replaceAll("/", ".");
            return Class.forName(className);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String getMethodSignatureClassStr(Serializable lambda) {
        String cs = LambdaUtil.getMethodSignatureClass(lambda);
        if ("String".equals(cs) || "BigInteger".equals(cs) || "Long".equals(cs) || "Integer".equals(cs) || "BigDecimal".equals(cs) || "Double".equals(cs) || "Float".equals(cs) || "Date".equals(cs) || "Timestamp".equals(cs) || "Boolean".equals(cs)) {
            return cs;
        }
        return String.class.getSimpleName();
    }

    public static String getOriginFieldName(Serializable lambda) {
        String originName = LambdaUtil.getOriginName(lambda);
        if (originName.length() < 4 && !originName.startsWith("get") && !originName.startsWith("set")) {
            throw new IllegalArgumentException("origin method is not a getter or a setter");
        }
        String fieldName = Introspector.decapitalize(originName.substring(3));
        return fieldName;
    }

    public static void main(String[] args) {
        TT tt = new TT();
        SerializableFunction sf = TT::getDt;
        Class returnType = LambdaUtil.getReturnType(sf);
        System.out.println(returnType);
    }

    static class TT {
        LocalDateTime dt;

        TT() {
        }

        public LocalDateTime getDt() {
            return this.dt;
        }
    }

    @FunctionalInterface
    public static interface DoThrowWrapper2 {
        public void run() throws Throwable;
    }

    @FunctionalInterface
    public static interface DoThrowWrapper<T> {
        public T get() throws Throwable;
    }
}

