/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.javacv;

import cn.hutool.core.util.StrUtil;
import com.jeecms.utils.javacv.FFmpegGrabFunction;
import com.jeecms.utils.javacv.FFmpegRecordFunction;
import com.jeecms.utils.javacv.meta.AudioMetaInfo;
import com.jeecms.utils.javacv.meta.VideoMetaInfo;
import com.jeecms.utils.lambda.LambdaUtil;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.OutputStream;
import org.bytedeco.ffmpeg.global.avcodec;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.FFmpegFrameRecorder;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.FrameRecorder;
import org.bytedeco.javacv.Java2DFrameConverter;

public class MediaUtil {
    public static AudioMetaInfo getAudioMetaInfo(String audioFilePath) {
        return MediaUtil.grab(audioFilePath, MediaUtil::getAudioMetaInfo);
    }

    public static AudioMetaInfo getAudioMetaInfo(InputStream inputStream) {
        return MediaUtil.grab(inputStream, MediaUtil::getAudioMetaInfo);
    }

    public static VideoMetaInfo getVideoMetaInfo(String videoFilePath) {
        return MediaUtil.grab(videoFilePath, MediaUtil::getVideoMetaInfo);
    }

    public static VideoMetaInfo getVideoMetaInfo(InputStream inputStream) {
        return MediaUtil.grab(inputStream, MediaUtil::getVideoMetaInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T grab(String mediaPath, FFmpegGrabFunction<T> grabFunction) {
        FFmpegFrameGrabber grabber = null;
        try {
            grabber = FFmpegFrameGrabber.createDefault((String)mediaPath);
            grabber.start();
            T t = grabFunction.grab(grabber);
            return t;
        }
        catch (Exception e) {
            Object r = LambdaUtil.raise(e);
            return (T)r;
        }
        finally {
            if (grabber != null) {
                try {
                    grabber.stop();
                }
                catch (FFmpegFrameGrabber.Exception e) {
                    LambdaUtil.raise(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T grab(InputStream inputStream, FFmpegGrabFunction<T> grabFunction) {
        FFmpegFrameGrabber grabber = null;
        try {
            grabber = new FFmpegFrameGrabber(inputStream);
            grabber.start();
            T t = grabFunction.grab(grabber);
            return t;
        }
        catch (Exception e) {
            Object r = LambdaUtil.raise(e);
            return (T)r;
        }
        finally {
            if (grabber != null) {
                try {
                    grabber.stop();
                }
                catch (FFmpegFrameGrabber.Exception e) {
                    LambdaUtil.raise(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void record(FFmpegFrameGrabber grabber, String mediaPath, FFmpegRecordFunction recordFunction) {
        FFmpegFrameRecorder recorder = null;
        try {
            recorder = new FFmpegFrameRecorder(mediaPath, grabber.getAudioChannels());
            recordFunction.record(recorder);
        }
        catch (Exception e) {
            LambdaUtil.raise(e);
        }
        finally {
            if (recorder != null) {
                try {
                    recorder.stop();
                    recorder.release();
                }
                catch (FFmpegFrameRecorder.Exception e) {
                    LambdaUtil.raise(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void record(FFmpegFrameGrabber grabber, OutputStream outputStream, FFmpegRecordFunction recordFunction) {
        FFmpegFrameRecorder recorder = null;
        try {
            recorder = new FFmpegFrameRecorder(outputStream, grabber.getAudioChannels());
            recordFunction.record(recorder);
        }
        catch (Exception e) {
            LambdaUtil.raise(e);
        }
        finally {
            if (recorder != null) {
                try {
                    recorder.stop();
                }
                catch (FFmpegFrameRecorder.Exception e) {
                    LambdaUtil.raise(e);
                }
            }
        }
    }

    private static VideoMetaInfo getVideoMetaInfo(FFmpegFrameGrabber grabber) {
        VideoMetaInfo videoMetaInfo = new VideoMetaInfo();
        videoMetaInfo.setDuration(grabber.getLengthInTime());
        videoMetaInfo.setFrameRate(grabber.getVideoFrameRate());
        videoMetaInfo.setFrames(grabber.getLengthInVideoFrames());
        videoMetaInfo.setBitRate(grabber.getVideoBitrate());
        videoMetaInfo.setFormat(grabber.getFormat());
        videoMetaInfo.setWidth(grabber.getImageWidth());
        videoMetaInfo.setHeight(grabber.getImageHeight());
        try (BytePointer name = avcodec.avcodec_find_decoder((int)grabber.getVideoCodec()).name();){
            videoMetaInfo.setCodec(name.getString());
        }
        try {
            String rotate = grabber.getVideoMetadata("rotate");
            if (StrUtil.isBlank((CharSequence)rotate)) {
                videoMetaInfo.setRotate(0);
            } else {
                videoMetaInfo.setRotate(Integer.parseInt(rotate));
            }
        }
        catch (NumberFormatException e) {
            videoMetaInfo.setRotate(0);
        }
        if (grabber.hasAudio()) {
            videoMetaInfo.setAudioMetaInfo(MediaUtil.getAudioMetaInfo(grabber));
        }
        long bitRate = videoMetaInfo.getBitRate();
        if (videoMetaInfo.getAudioMetaInfo() != null) {
            bitRate += (long)videoMetaInfo.getAudioMetaInfo().getBitRate();
        }
        videoMetaInfo.setSize(bitRate * videoMetaInfo.getDuration() / 1000000L / 8L);
        videoMetaInfo.setMetadata(grabber.getVideoMetadata());
        return videoMetaInfo;
    }

    private static AudioMetaInfo getAudioMetaInfo(FFmpegFrameGrabber grabber) {
        AudioMetaInfo audioMetaInfo = new AudioMetaInfo();
        audioMetaInfo.setBitRate(grabber.getAudioBitrate());
        audioMetaInfo.setDuration(grabber.getLengthInTime());
        audioMetaInfo.setSampleRate(grabber.getSampleRate());
        audioMetaInfo.setChannels(grabber.getAudioChannels());
        audioMetaInfo.setMetadata(grabber.getAudioMetadata());
        audioMetaInfo.setSize((long)audioMetaInfo.getBitRate() * audioMetaInfo.getDuration() / 1000000L / 8L);
        audioMetaInfo.setFormat(grabber.getFormat());
        try (BytePointer name = avcodec.avcodec_find_decoder((int)grabber.getAudioCodec()).name();){
            audioMetaInfo.setCodec(name.getString());
        }
        return audioMetaInfo;
    }

    public static BufferedImage getScreenshotInFrame(String videoFilePath, int select) {
        return MediaUtil.getScreenshotInFrame(videoFilePath, select, true);
    }

    public static BufferedImage getScreenshotInFrame(String videoFilePath, int select, boolean checkOver) {
        return MediaUtil.grab(videoFilePath, (FFmpegFrameGrabber grabber) -> MediaUtil.getScreenshot(grabber, select, true, checkOver));
    }

    public static BufferedImage getScreenshotInFrame(InputStream inputStream, int select) {
        return MediaUtil.getScreenshotInFrame(inputStream, select, true);
    }

    public static BufferedImage getScreenshotInFrame(InputStream inputStream, int select, boolean checkOver) {
        return MediaUtil.grab(inputStream, (FFmpegFrameGrabber grabber) -> MediaUtil.getScreenshot(grabber, select, true, true));
    }

    public static BufferedImage getScreenshotInSecond(String videoFilePath, int select) {
        return MediaUtil.getScreenshotInSecond(videoFilePath, select, true);
    }

    public static BufferedImage getScreenshotInSecond(String videoFilePath, int select, boolean checkOver) {
        return MediaUtil.grab(videoFilePath, (FFmpegFrameGrabber grabber) -> MediaUtil.getScreenshot(grabber, select, false, checkOver));
    }

    public static BufferedImage getScreenshotInSecond(InputStream inputStream, int select) {
        return MediaUtil.getScreenshotInSecond(inputStream, select, true);
    }

    public static BufferedImage getScreenshotInSecond(InputStream inputStream, int select, boolean checkOver) {
        return MediaUtil.grab(inputStream, (FFmpegFrameGrabber grabber) -> MediaUtil.getScreenshot(grabber, select, true, checkOver));
    }

    public static BufferedImage getVideoPoster(String videoFilePath) {
        return MediaUtil.getScreenshotInSecond(videoFilePath, 10, false);
    }

    public static BufferedImage getVideoPoster(InputStream inputStream) {
        return MediaUtil.getScreenshotInSecond(inputStream, 10, false);
    }

    private static BufferedImage getScreenshot(FFmpegFrameGrabber grabber, int select, boolean isFrame, boolean checkOver) throws FFmpegFrameGrabber.Exception {
        if (select < 0) {
            return null;
        }
        int frames = grabber.getLengthInAudioFrames();
        int targetFrame = select;
        if (!isFrame) {
            double videoFrameRate = grabber.getVideoFrameRate();
            targetFrame = (int)(videoFrameRate * (double)select);
        }
        if (checkOver && targetFrame > frames) {
            return null;
        }
        Frame frame = null;
        int count = 0;
        for (int i = 0; i < frames && ((frame = grabber.grabImage()) == null || frame.image == null || ++count != targetFrame); ++i) {
        }
        if (frame != null && frame.image != null) {
            Java2DFrameConverter converter = new Java2DFrameConverter();
            BufferedImage bi = converter.getBufferedImage(frame);
            return bi;
        }
        return null;
    }

    public static void getAudioFromVideo(String videoFilePath, String targetFilePath) {
        MediaUtil.grab(videoFilePath, (FFmpegFrameGrabber grabber) -> {
            FFmpegFrameRecorder recorder = new FFmpegFrameRecorder(targetFilePath, grabber.getAudioChannels());
            MediaUtil.getAudioFromVideo(grabber, recorder);
            return null;
        });
    }

    public static void getAudioFromVideo(String videoFilePath, OutputStream outputStream) {
        MediaUtil.grab(videoFilePath, (FFmpegFrameGrabber grabber) -> {
            FFmpegFrameRecorder recorder = new FFmpegFrameRecorder(outputStream, grabber.getAudioChannels());
            MediaUtil.getAudioFromVideo(grabber, recorder);
            return null;
        });
    }

    public static void getAudioFromVideo(InputStream videoInputStream, String targetFilePath) {
        MediaUtil.grab(videoInputStream, (FFmpegFrameGrabber grabber) -> {
            FFmpegFrameRecorder recorder = new FFmpegFrameRecorder(targetFilePath, grabber.getAudioChannels());
            MediaUtil.getAudioFromVideo(grabber, recorder);
            return null;
        });
    }

    public static void getAudioFromVideo(InputStream videoInputStream, OutputStream outputStream) {
        MediaUtil.grab(videoInputStream, (FFmpegFrameGrabber grabber) -> {
            FFmpegFrameRecorder recorder = new FFmpegFrameRecorder(outputStream, grabber.getAudioChannels());
            MediaUtil.getAudioFromVideo(grabber, recorder);
            return null;
        });
    }

    private static void getAudioFromVideo(FFmpegFrameGrabber grabber, FFmpegFrameRecorder recorder) throws FFmpegFrameRecorder.Exception, FFmpegFrameGrabber.Exception {
        Frame frame;
        recorder.setFormat("mp3");
        recorder.setSampleRate(grabber.getSampleRate());
        recorder.setTimestamp(grabber.getTimestamp());
        recorder.setAudioQuality(0.0);
        recorder.start();
        while ((frame = grabber.grab()) != null) {
            if (frame.samples == null) continue;
            recorder.recordSamples(frame.sampleRate, frame.audioChannels, frame.samples);
        }
        recorder.stop();
        recorder.release();
        try {
            recorder.close();
        }
        catch (FrameRecorder.Exception exception) {
            // empty catch block
        }
    }

    public static void compressVideo(String videoFilePath, String targetFilePath) {
        MediaUtil.compressVideo(videoFilePath, targetFilePath, -1, -1, 15, 300000);
    }

    public static void compressVideo(String videoFilePath, String targetFilePath, int width, int height, int frameRate, int videoBitrate) {
        MediaUtil.grab(videoFilePath, (FFmpegFrameGrabber grabber) -> {
            MediaUtil.record(grabber, targetFilePath, (FFmpegFrameRecorder recorder) -> MediaUtil.compressVideo(grabber, recorder, width, height, frameRate, videoBitrate));
            return null;
        });
    }

    public static void compressVideo(InputStream inputStream, OutputStream outputStream) {
        MediaUtil.compressVideo(inputStream, outputStream, -1, -1, 15, 300000);
    }

    public static void compressVideo(InputStream inputStream, OutputStream outputStream, int width, int height, int frameRate, int videoBitrate) {
        MediaUtil.grab(inputStream, (FFmpegFrameGrabber grabber) -> {
            MediaUtil.record(grabber, outputStream, (FFmpegFrameRecorder recorder) -> MediaUtil.compressVideo(grabber, recorder, width, height, frameRate, videoBitrate));
            return null;
        });
    }

    public static void compressVideo(String videoFilePath, OutputStream outputStream) {
        MediaUtil.compressVideo(videoFilePath, outputStream, -1, -1, 15, 300000);
    }

    public static void compressVideo(String videoFilePath, OutputStream outputStream, int width, int height, int frameRate, int videoBitrate) {
        MediaUtil.grab(videoFilePath, (FFmpegFrameGrabber grabber) -> {
            MediaUtil.record(grabber, outputStream, (FFmpegFrameRecorder recorder) -> MediaUtil.compressVideo(grabber, recorder, width, height, frameRate, videoBitrate));
            return null;
        });
    }

    public static void compressVideo(InputStream inputStream, String targetFilePath) {
        MediaUtil.compressVideo(inputStream, targetFilePath, -1, -1, 20, 300000);
    }

    public static void compressVideo(InputStream inputStream, String targetFilePath, int width, int height, int frameRate, int videoBitrate) {
        MediaUtil.grab(inputStream, (FFmpegFrameGrabber grabber) -> {
            MediaUtil.record(grabber, targetFilePath, (FFmpegFrameRecorder recorder) -> MediaUtil.compressVideo(grabber, recorder, width, height, frameRate, videoBitrate));
            return null;
        });
    }

    private static void compressVideo(FFmpegFrameGrabber grabber, FFmpegFrameRecorder recorder, int width, int height, int frameRate, int videoBitrate) throws FFmpegFrameRecorder.Exception {
        int originWidth = grabber.getImageWidth();
        int originHeight = grabber.getImageHeight();
        if (width <= 0 && height <= 0) {
            if (originWidth > 640) {
                width = 640;
                height = width * originHeight / originWidth;
                height &= 0xFFFFFFFE;
            } else if (originHeight > 640) {
                height = 640;
                width = height * originWidth / originHeight;
                width &= 0xFFFFFFFE;
            } else {
                width = originWidth;
                height = originHeight;
            }
        } else if (width <= 0) {
            width = height * originWidth / originHeight;
            width &= 0xFFFFFFFE;
        } else if (height <= 0) {
            height = width * originHeight / originWidth;
            height &= 0xFFFFFFFE;
        }
        recorder.setFrameRate((double)frameRate);
        recorder.setSampleRate(grabber.getSampleRate());
        recorder.setVideoOption("preset", "medium");
        recorder.setVideoOption("crf", "26");
        recorder.setVideoOption("movflags", "faststart");
        recorder.setPixelFormat(0);
        recorder.setVideoCodec(27);
        recorder.setAudioCodec(86018);
        recorder.setFormat("mp4");
        recorder.setVideoBitrate(videoBitrate);
        recorder.setImageWidth(width);
        recorder.setImageHeight(height);
        recorder.start();
        while (true) {
            try {
                Frame frame;
                while ((frame = grabber.grabFrame()) != null) {
                    recorder.record(frame);
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }
}

