/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.excel.aspect;

import cn.hutool.core.util.ArrayUtil;
import com.jeecms.kit.JcResult;
import com.jeecms.utils.BeanUtil;
import com.jeecms.utils.DateUtil;
import com.jeecms.utils.ReflectUtil;
import com.jeecms.utils.excel.annotation.Enum;
import com.jeecms.utils.excel.annotation.ExcelExport;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ExcelAspect {
    private static final Logger log = LoggerFactory.getLogger(ExcelAspect.class);
    private final HttpServletResponse response;
    private final ThreadLocal<Map<String, Map<String, String>>> enumsThreadLocal = new ThreadLocal();

    public ExcelAspect(HttpServletResponse response) {
        this.response = response;
    }

    @Pointcut(value="@annotation(excelExport)")
    public void serviceStatistics(ExcelExport excelExport) {
    }

    @Around(value="serviceStatistics(excelExport)", argNames="joinPoint,excelExport")
    public void around(ProceedingJoinPoint joinPoint, ExcelExport excelExport) throws Throwable {
        Object[] args = joinPoint.getArgs();
        for (int i = 0; i < args.length; ++i) {
            Pageable pageable;
            Object arg = args[i];
            if (!(arg instanceof Pageable) || (pageable = (Pageable)arg).getPageNumber() == 0 && pageable.getPageSize() >= 200) continue;
            args[i] = PageRequest.of((int)0, (int)200, (Sort)pageable.getSort());
        }
        Object retVal = joinPoint.proceed(args);
        this.postAdvice((JoinPoint)joinPoint, excelExport, retVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postAdvice(JoinPoint joinPoint, ExcelExport excelExport, Object returnValue) throws IOException {
        List<Object> objectList = this.checkTarget(returnValue);
        if (objectList == null) {
            log.error("\u65e0\u6cd5\u89e3\u6790\u7684\u6570\u636e: {}", returnValue);
            this.response.sendError(HttpStatus.INTERNAL_SERVER_ERROR.value());
        }
        Page page = this.getPage(returnValue);
        try (ServletOutputStream out = this.response.getOutputStream();){
            String excelBaseName = FilenameUtils.getBaseName((String)excelExport.filename());
            String title = excelExport.title();
            if (StringUtils.isBlank((CharSequence)excelBaseName)) {
                excelBaseName = StringUtils.isNotBlank((CharSequence)title) ? title : "export";
            }
            String excelName = excelBaseName + ".xlsx";
            this.response.setContentType("application/x-msdownload");
            this.response.setHeader("Content-disposition", "attachment; filename=" + URLEncoder.encode(excelName, "UTF-8"));
            Workbook wb = this.genExcel(Arrays.asList(excelExport.heads()), excelBaseName, title);
            int pos = StringUtils.isBlank((CharSequence)title) ? 1 : 2;
            while (true) {
                List<List<Object>> valuesList = this.fetchValuesList(objectList, excelExport);
                this.writeExcel(wb, valuesList, pos);
                if (page.isLast()) break;
                pos += valuesList.size();
                Page nextPage = this.nextPage(page, joinPoint);
                objectList = this.checkTarget(nextPage);
                page = nextPage;
            }
            wb.write((OutputStream)out);
            out.flush();
        }
        catch (IOException e) {
            log.error("excel\u5bfc\u51fa\u5931\u8d25: {}#{}", new Object[]{joinPoint.getTarget().getClass().getName(), joinPoint.getSignature().getName(), e});
        }
        finally {
            this.enumsThreadLocal.remove();
        }
    }

    private void writeExcel(Workbook wb, List<List<Object>> valuesList, int pos) {
        Sheet sheet = wb.getSheetAt(0);
        for (int i = 0; i < valuesList.size(); ++i) {
            List<Object> vals = valuesList.get(i);
            Row row = sheet.createRow(pos + i);
            for (int j = 0; j < vals.size(); ++j) {
                Object val = vals.get(j);
                if (val == null) {
                    val = "";
                } else if (val instanceof Date) {
                    val = DateUtil.formatDateTime((Date)((Date)val));
                } else if (val instanceof LocalDateTime) {
                    val = DateUtil.formatDateTime((LocalDateTime)val);
                } else if (val instanceof LocalDate) {
                    val = DateUtil.formatDate((LocalDate)val);
                } else if (val instanceof LocalTime) {
                    val = DateUtil.formatTime((LocalTime)val);
                }
                row.createCell(j).setCellValue(val.toString());
                sheet.setColumnWidth(j, Math.max(sheet.getColumnWidth(j), (int)((double)val.toString().getBytes().length * 1.2 * 256.0)));
            }
        }
    }

    private Workbook genExcel(List<String> headerList, String sheetName, String title) {
        Row row;
        SXSSFWorkbook wb = new SXSSFWorkbook(500);
        Sheet sheet = wb.createSheet(sheetName);
        Font font = wb.createFont();
        font.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
        font.setBold(true);
        CellStyle style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setFont(font);
        int offset = 0;
        if (StringUtils.isNotBlank((CharSequence)title)) {
            row = sheet.createRow(offset++);
            Cell cell = row.createCell(0);
            cell.setCellValue(title);
            cell.setCellStyle(style);
            CellRangeAddress cra = new CellRangeAddress(0, 0, 0, headerList.size() - 1);
            sheet.addMergedRegion(cra);
            RegionUtil.setBorderTop((BorderStyle)BorderStyle.NONE, (CellRangeAddress)cra, (Sheet)sheet);
        }
        row = sheet.createRow(offset);
        int size = headerList.size();
        for (int i = 0; i < size; ++i) {
            Cell cell = row.createCell(i);
            cell.setCellStyle(style);
            cell.setCellValue(headerList.get(i));
            sheet.setColumnWidth(i, (int)((double)headerList.get(i).length() * 1.2 * 256.0));
        }
        return wb;
    }

    private Page getPage(Object returnValue) {
        Object retData = returnValue;
        if (retData instanceof JcResult) {
            retData = ((JcResult)returnValue).getData();
        }
        if (retData instanceof Page) {
            Page page = (Page)retData;
            return page;
        }
        PageImpl page = new PageImpl(Collections.emptyList(), (Pageable)PageRequest.of((int)1, (int)1), 1L);
        return page;
    }

    private Page nextPage(Page page, JoinPoint joinPoint) {
        Pageable pageable = page.getPageable().next();
        Object target = joinPoint.getTarget();
        Object[] args = joinPoint.getArgs();
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof Pageable)) continue;
            args[i] = pageable;
        }
        Method method = this.getTargetMethod(joinPoint);
        Object invoke = ReflectUtil.invoke((Object)target, (Method)method, (Object[])args);
        if (invoke instanceof JcResult) {
            JcResult jc = (JcResult)invoke;
            return (Page)jc.getData();
        }
        return (Page)invoke;
    }

    private List<Object> checkTarget(Object returnValue) {
        Object retData = returnValue;
        if (retData instanceof JcResult) {
            retData = ((JcResult)returnValue).getData();
        }
        if (ArrayUtil.isArray((Object)retData)) {
            retData = Arrays.asList(retData);
        }
        if (retData instanceof Page) {
            retData = ((Page)retData).getContent();
        }
        if (!(retData instanceof List)) {
            return null;
        }
        return retData;
    }

    private List<List<Object>> fetchValuesList(List<Object> objList, ExcelExport excelExport) {
        Map<String, Map<String, String>> enumMap = this.fetchEnums(excelExport);
        ArrayList<List<Object>> ret = new ArrayList<List<Object>>(objList.size());
        String[] fields = excelExport.fields();
        for (Object obj : objList) {
            ArrayList<Object> list = new ArrayList<Object>(fields.length);
            for (String fieldPath : fields) {
                Object property = BeanUtil.getProperty((Object)obj, (String)fieldPath);
                if (enumMap.containsKey(fieldPath) && property != null) {
                    property = Optional.ofNullable(enumMap.get(fieldPath).get(property.toString())).orElse((String)property);
                }
                list.add(property);
            }
            ret.add(list);
        }
        return ret;
    }

    private Map<String, Map<String, String>> fetchEnums(ExcelExport excelExport) {
        if (this.enumsThreadLocal.get() != null) {
            return this.enumsThreadLocal.get();
        }
        Enum[] enums = excelExport.enums();
        if (enums.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Map<String, String>> ret = new HashMap<String, Map<String, String>>(enums.length);
        for (Enum anEnum : enums) {
            ret.put(anEnum.field(), this.convertEnumToMap(anEnum));
        }
        this.enumsThreadLocal.set(ret);
        return ret;
    }

    private Map<String, String> convertEnumToMap(Enum anEnum) {
        HashMap<String, String> ret = new HashMap<String, String>(anEnum.values().length);
        if (anEnum.labels().length != anEnum.values().length) {
            throw new IllegalArgumentException("excel\u5bfc\u51fa\u914d\u7f6e\u9519\u8bef\uff0c[" + anEnum.field() + "]\u679a\u4e3e\u8bf4\u660e\u7684\u53d8\u91cf\u6570\u91cf\u548c\u6807\u7b7e\u6570\u91cf\u4e0d\u4e00\u81f4");
        }
        for (int i = 0; i < anEnum.values().length; ++i) {
            ret.put(anEnum.values()[i], anEnum.labels()[i]);
        }
        return ret;
    }

    private Method getTargetMethod(JoinPoint joinPoint) {
        Object mi = ReflectUtil.getFieldValue((Object)joinPoint, (String)"methodInvocation");
        Object method = ReflectUtil.getFieldValue((Object)mi, (String)"method");
        return (Method)method;
    }
}

