/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.corpwechat.util;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jeecms.exception.GlobalRuntimeException;
import com.jeecms.util.RedisUtil;
import com.jeecms.utils.CollectionUtil;
import com.jeecms.utils.corpwechat.pojo.ChatInfoVO;
import com.jeecms.utils.corpwechat.pojo.ContentDTO;
import com.jeecms.utils.corpwechat.pojo.CreateDTO;
import com.jeecms.utils.corpwechat.pojo.ResultVO;
import com.jeecms.utils.corpwechat.pojo.SendAppMessageDTO;
import com.jeecms.utils.corpwechat.pojo.SendMessageDTO;
import com.jeecms.utils.corpwechat.pojo.UpdateDTO;
import com.jeecms.utils.corpwechat.pojo.UserListVO;
import com.jeecms.utils.corpwechat.util.CorpWechatAccount;
import com.jeecms.utils.spring.SpringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorpWechatUtils {
    private static final Logger logger = LoggerFactory.getLogger(CorpWechatUtils.class);
    public static Supplier<CorpWechatAccount> accountSupplier;
    public static final String MESSAGE_TYPE_TEXT = "text";
    public static final String MESSAGE_TYPE_IMAGE = "image";
    public static final String MESSAGE_TYPE_VOICE = "voice";
    public static final String MESSAGE_TYPE_VIDEO = "video";
    public static final String MESSAGE_TYPE_FILE = "file";
    public static final String MESSAGE_TYPE_TEXTCARD = "textcard";
    public static final String MESSAGE_TYPE_NEWS = "news";
    public static final String MESSAGE_TYPE_MPNEWS = "mpnews";
    public static final String MESSAGE_TYPE_MARKDOWN = "markdown";
    private static final String CORP_WECHAT_TOKEN_KEY = "corpWechat:token";
    private static final String GET_ACCESS_TOKEN = "https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=%s&corpsecret=%s";
    private static final String CREATE_GROUP_CHAT = "https://qyapi.weixin.qq.com/cgi-bin/appchat/create?access_token=%s";
    private static final String UPDATE_GROUP_CHAT = "https://qyapi.weixin.qq.com/cgi-bin/appchat/update?access_token=%s";
    private static final String GET_GROUP_CHAT = "https://qyapi.weixin.qq.com/cgi-bin/appchat/get?access_token=%s&chatid=%s";
    private static final String SEND_MESSAGE = "https://qyapi.weixin.qq.com/cgi-bin/appchat/send?access_token=%s";
    private static final String SEND_APP_MESSAGE = "https://qyapi.weixin.qq.com/cgi-bin/message/send?access_token=%s";
    private static final String GET_DEPARTMENT_USER = "https://qyapi.weixin.qq.com/cgi-bin/user/simplelist?access_token=%s&department_id=%s&fetch_child=%s";
    private static final String GET_DEPARTMENT_LIST = "https://qyapi.weixin.qq.com/cgi-bin/department/list?access_token=%s";

    public static String getAccessToken(CorpWechatAccount account) {
        RedisUtil redisUtil = SpringUtil.getBean(RedisUtil.class);
        Object token = redisUtil.get(CORP_WECHAT_TOKEN_KEY);
        if (token == null) {
            String result = HttpUtil.get((String)String.format(GET_ACCESS_TOKEN, account.getCorpId(), account.getCorpMessageSecret()));
            ResultVO response = (ResultVO)JSONObject.parseObject((String)result, ResultVO.class);
            if (!response.isSuccess()) {
                throw new GlobalRuntimeException((int)response.getErrcode(), response.getErrmsg(), new Object[0]);
            }
            System.out.println(result);
            redisUtil.set(CORP_WECHAT_TOKEN_KEY, (Object)response.getAccessToken(), (long)(response.getExpiresIn() - 60));
            return response.isSuccess() ? response.getAccessToken() : null;
        }
        return (String)token;
    }

    public static boolean createGroupChat(String name, String owner, List<String> userList, String chatId) {
        ChatInfoVO groupChat = CorpWechatUtils.getGroupChat(chatId);
        if (groupChat != null) {
            List<String> delUserList = groupChat.getUserlist();
            delUserList.removeAll(userList);
            return CorpWechatUtils.updateGroupChat(name, owner, userList, delUserList, chatId);
        }
        CreateDTO createDTO = new CreateDTO(name, owner, userList, chatId);
        CorpWechatAccount account = accountSupplier.get();
        String result = HttpUtil.post((String)String.format(CREATE_GROUP_CHAT, CorpWechatUtils.getAccessToken(account)), (String)JSONObject.toJSONString((Object)createDTO));
        ResultVO resultVO = (ResultVO)JSONObject.parseObject((String)result, ResultVO.class);
        if (!resultVO.isSuccess()) {
            throw new GlobalRuntimeException((int)resultVO.getErrcode(), resultVO.getErrmsg(), new Object[0]);
        }
        return resultVO.isSuccess();
    }

    public static ChatInfoVO getGroupChat(String chatId) {
        CorpWechatAccount account = accountSupplier.get();
        String result = HttpUtil.get((String)String.format(GET_GROUP_CHAT, CorpWechatUtils.getAccessToken(account), chatId));
        ResultVO resultVO = (ResultVO)JSONObject.parseObject((String)result, ResultVO.class);
        if (!resultVO.isSuccess()) {
            throw new GlobalRuntimeException((int)resultVO.getErrcode(), resultVO.getErrmsg(), new Object[0]);
        }
        return resultVO.getChat_info();
    }

    public static boolean updateGroupChat(String name, String owner, List<String> addUserList, List<String> delUserList, String chatId) {
        UpdateDTO updateDTO = new UpdateDTO(chatId, name, owner, addUserList, delUserList);
        CorpWechatAccount account = accountSupplier.get();
        String result = HttpUtil.post((String)String.format(UPDATE_GROUP_CHAT, CorpWechatUtils.getAccessToken(account)), (String)JSONObject.toJSONString((Object)updateDTO));
        ResultVO resultVO = (ResultVO)JSONObject.parseObject((String)result, ResultVO.class);
        if (!resultVO.isSuccess()) {
            throw new GlobalRuntimeException((int)resultVO.getErrcode(), resultVO.getErrmsg(), new Object[0]);
        }
        return resultVO.isSuccess();
    }

    public static List<Integer> getDepartmentList() {
        CorpWechatAccount account = accountSupplier.get();
        String result = HttpUtil.get((String)String.format(GET_DEPARTMENT_LIST, CorpWechatUtils.getAccessToken(account)));
        JSONObject json = JSONObject.parseObject((String)result);
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (json.getIntValue("errcode") == 0) {
            JSONArray departments = json.getJSONArray("department");
            for (Object department : departments) {
                JSONObject jsonObject = (JSONObject)department;
                Integer id = jsonObject.getInteger("id");
                list.add(id);
            }
        }
        return list;
    }

    public static List<String> getDepartmentUser(int departmentId, Integer fetchChild) {
        CorpWechatAccount account = accountSupplier.get();
        String result = HttpUtil.get((String)String.format(GET_DEPARTMENT_USER, CorpWechatUtils.getAccessToken(account), departmentId, fetchChild));
        ResultVO resultVO = (ResultVO)JSONObject.parseObject((String)result, ResultVO.class);
        if (!resultVO.isSuccess()) {
            throw new GlobalRuntimeException((int)resultVO.getErrcode(), resultVO.getErrmsg(), new Object[0]);
        }
        List<String> convert = CollectionUtil.convert(resultVO.getUserlist(), UserListVO::getUserid);
        return resultVO.isSuccess() ? convert : Collections.emptyList();
    }

    public static boolean sendMessage(String message, String chatId, Integer safe) {
        CorpWechatAccount account = accountSupplier.get();
        SendMessageDTO sendMessageDTO = new SendMessageDTO(chatId, new ContentDTO(message), safe);
        String result = HttpUtil.post((String)String.format(SEND_MESSAGE, CorpWechatUtils.getAccessToken(account)), (String)JSONObject.toJSONString((Object)sendMessageDTO));
        ResultVO resultVO = (ResultVO)JSONObject.parseObject((String)result, ResultVO.class);
        if (!resultVO.isSuccess()) {
            throw new GlobalRuntimeException((int)resultVO.getErrcode(), resultVO.getErrmsg(), new Object[0]);
        }
        return resultVO.isSuccess();
    }

    public static boolean sendTextMessageAll(String message, Integer safe) {
        CorpWechatAccount account = accountSupplier.get();
        String chatId = account.getChatId();
        ChatInfoVO groupChat = CorpWechatUtils.getGroupChat(chatId);
        List<String> departmentUser = CorpWechatUtils.getDepartmentUser(1, 0);
        if (groupChat == null) {
            CorpWechatUtils.createGroupChat(account.getGroupChatName(), null, departmentUser, chatId);
        } else {
            List<String> delUserList = groupChat.getUserlist();
            delUserList.removeAll(departmentUser);
            CorpWechatUtils.updateGroupChat(account.getGroupChatName(), null, departmentUser, delUserList, chatId);
        }
        SendMessageDTO sendMessageDTO = new SendMessageDTO(chatId, new ContentDTO(message), safe);
        String result = HttpUtil.post((String)String.format(SEND_MESSAGE, CorpWechatUtils.getAccessToken(account)), (String)JSONObject.toJSONString((Object)sendMessageDTO));
        ResultVO resultVO = (ResultVO)JSONObject.parseObject((String)result, ResultVO.class);
        if (!resultVO.isSuccess()) {
            throw new GlobalRuntimeException((int)resultVO.getErrcode(), resultVO.getErrmsg(), new Object[0]);
        }
        return resultVO.isSuccess();
    }

    public static void sendMessage(SendMessageDTO dto) {
        if (StringUtils.isBlank((CharSequence)dto.getChatid())) {
            return;
        }
        CorpWechatAccount account = accountSupplier.get();
        String result = HttpUtil.post((String)String.format(SEND_MESSAGE, CorpWechatUtils.getAccessToken(account)), (String)JSONObject.toJSONString((Object)dto));
        ResultVO resultVO = (ResultVO)JSONObject.parseObject((String)result, ResultVO.class);
        if (!resultVO.isSuccess()) {
            throw new GlobalRuntimeException((int)resultVO.getErrcode(), resultVO.getErrmsg(), new Object[0]);
        }
        logger.info("\u53d1\u9001\u6210\u529f");
    }

    public static boolean sendAppMessage(List<String> toUsers, String message) {
        return CorpWechatUtils.sendAppMessage(CollectionUtil.join(toUsers, (CharSequence)"|"), null, null, message);
    }

    public static boolean sendAppMessage(List<String> toUsers, List<String> toPartys, String message) {
        return CorpWechatUtils.sendAppMessage(CollectionUtil.join(toUsers, (CharSequence)"|"), CollectionUtil.join(toPartys, (CharSequence)"|"), null, message);
    }

    public static boolean sendAppMessage(List<String> toUsers, List<String> toPartys, List<String> toTags, String message) {
        return CorpWechatUtils.sendAppMessage(CollectionUtil.join(toUsers, (CharSequence)"|"), CollectionUtil.join(toPartys, (CharSequence)"|"), CollectionUtil.join(toTags, (CharSequence)"|"), message);
    }

    public static boolean sendAppMessage(String toUsers, String toPartys, String toTags, String message) {
        CorpWechatAccount account = accountSupplier.get();
        SendAppMessageDTO sendMessageRequest = new SendAppMessageDTO(toUsers, toPartys, toTags, MESSAGE_TYPE_TEXT, account.getMessageAgentId(), new ContentDTO(message));
        String result = HttpUtil.post((String)String.format(SEND_APP_MESSAGE, CorpWechatUtils.getAccessToken(account)), (String)JSONObject.toJSONString((Object)sendMessageRequest));
        ResultVO resultVO = (ResultVO)JSONObject.parseObject((String)result, ResultVO.class);
        if (!resultVO.isSuccess()) {
            throw new GlobalRuntimeException((int)resultVO.getErrcode(), resultVO.getErrmsg(), new Object[0]);
        }
        return resultVO.isSuccess();
    }

    public static void main(String[] args) {
        ContentDTO markdown = new ContentDTO("<font color=\"warning\">@$userName=XiaoHui$</font>\uff0c \u6d4b\u8bd5@\u5355\u72ec\u4e00\u4e2a\u6210\u5458\u662f\u5426\u6709\u63d0\u793a");
        SendMessageDTO request = new SendMessageDTO("wrLs5DDwAAxyBTtDuajA6MaA8Rb0mlGA", MESSAGE_TYPE_MARKDOWN, null, markdown, 0);
        CorpWechatUtils.sendMessage(request);
        System.out.println(CorpWechatUtils.sendAppMessage("XiaoHui", null, null, "\u5c0f\u7070\uff0c \u4f60\u597d\uff0c\u6211\u662f\u6d88\u606f\u63d0\u9192\u5e94\u7528\uff0c\u8fd9\u91cc\u63d0\u9192\u4f60\u8981\u559d\u6c34\u4e86\uff01\uff01\uff01"));
    }
}

