/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.area.store;

import com.alibaba.fastjson.JSON;
import com.jeecms.utils.CollectionUtil;
import com.jeecms.utils.StrUtil;
import com.jeecms.utils.area.operator.AreaResult;
import com.jeecms.utils.area.store.IAreaStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;

public class AreaCacheStore
implements IAreaStore {
    private static final Logger log = LoggerFactory.getLogger(AreaCacheStore.class);
    private static final String KEY_PREFIX = "AREA:";
    private IAreaStore areaStore;
    private StringRedisTemplate redisTemplate;

    public AreaCacheStore(IAreaStore areaStore, StringRedisTemplate redisTemplate) {
        this.areaStore = areaStore;
        this.redisTemplate = redisTemplate;
    }

    @Override
    public AreaResult getAreaResultById(Long id) {
        AreaResult areaResult;
        String jsonStr = (String)this.redisTemplate.opsForValue().get((Object)(KEY_PREFIX + id));
        if (StrUtil.isNotBlank((CharSequence)jsonStr) && (areaResult = this.parseAreaResult(jsonStr)) != null) {
            return areaResult;
        }
        return this.loadAreaResultByIds(Collections.singletonList(id)).get(0);
    }

    @Override
    public List<AreaResult> getAreaResultByIds(List<Long> ids) {
        List keys = ids.stream().map(id -> KEY_PREFIX + id).collect(Collectors.toList());
        List jsonStrs = this.redisTemplate.opsForValue().multiGet(keys);
        if (CollectionUtil.isNotEmpty((Collection)jsonStrs)) {
            ArrayList<Long> hitIds = new ArrayList<Long>(jsonStrs.size());
            ArrayList<AreaResult> areaResults = new ArrayList<AreaResult>(ids.size());
            for (String jsonStr : jsonStrs) {
                AreaResult areaResult = this.parseAreaResult(jsonStr);
                if (areaResult == null) continue;
                areaResults.add(areaResult);
                hitIds.add(areaResult.getId());
            }
            if (hitIds.size() == ids.size()) {
                return areaResults;
            }
            ArrayList<Long> copyIds = new ArrayList<Long>(ids);
            copyIds.removeAll(hitIds);
            List<AreaResult> areaResultFromDb = this.loadAreaResultByIds(copyIds);
            areaResults.addAll(areaResultFromDb);
            return areaResults;
        }
        return this.loadAreaResultByIds(ids);
    }

    private List<AreaResult> loadAreaResultByIds(List<Long> ids) {
        List<AreaResult> areaResults;
        if (CollectionUtil.isEmpty(ids)) {
            return Collections.emptyList();
        }
        if (ids.size() == 1) {
            AreaResult areaResult = this.areaStore.getAreaResultById(ids.get(0));
            areaResults = Collections.singletonList(areaResult);
        } else {
            areaResults = this.areaStore.getAreaResultByIds(ids);
        }
        for (AreaResult areaResult : areaResults) {
            String jsonString = JSON.toJSONString((Object)areaResult);
            this.redisTemplate.opsForValue().set((Object)(KEY_PREFIX + areaResult.getId()), (Object)jsonString, 1L, TimeUnit.HOURS);
        }
        return areaResults;
    }

    private AreaResult parseAreaResult(String jsonStr) {
        try {
            return (AreaResult)JSON.parseObject((String)jsonStr, AreaResult.class);
        }
        catch (Exception e) {
            log.error("\u8d44\u6e90JSON\u53cd\u5e8f\u5217\u5316\u5931\u8d25", (Throwable)e);
            return null;
        }
    }
}

