/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.area.resolve;

import cn.hutool.core.util.ReflectUtil;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.jeecms.utils.CollectionUtil;
import com.jeecms.utils.StrUtil;
import com.jeecms.utils.area.operator.AreaResult;
import com.jeecms.utils.area.resolve.Area;
import com.jeecms.utils.spring.WebUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class AreaPropertyFilter
implements ValueFilter {
    public Object process(Object object, String name, Object value) {
        try {
            if (value == null) {
                return value;
            }
            if (!(value instanceof Long) && !(value instanceof Collection)) {
                return value;
            }
            Class<?> objectClass = object.getClass();
            Field field = null;
            try {
                field = ReflectUtil.getField(objectClass, (String)name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Area area = null;
            if (field != null) {
                area = field.getAnnotation(Area.class);
            }
            if (area == null) {
                try {
                    Method method = ReflectUtil.getMethod(objectClass, (String)("get" + StrUtil.upperFirst((CharSequence)name)), (Class[])new Class[0]);
                    if (method != null) {
                        area = method.getAnnotation(Area.class);
                    }
                }
                catch (Exception method) {
                    // empty catch block
                }
            }
            if (area != null) {
                Collection coll;
                if (value instanceof Long) {
                    return this.resolveResource((Long)value, area);
                }
                if (value instanceof Collection && CollectionUtil.isNotEmpty((Collection)(coll = (Collection)value))) {
                    ArrayList<Long> ids = !(coll instanceof List) ? new ArrayList<Long>(coll) : (ArrayList<Long>)coll;
                    List<AreaResult> areaResults = this.getResultByIds(ids);
                    if (area.onlyFullPathName()) {
                        List<String> fullPathName = CollectionUtil.convert(areaResults, ur -> Optional.ofNullable(ur).map(AreaResult::getFullPathName).orElse(null));
                        return fullPathName;
                    }
                    if (area.onlyName()) {
                        List<String> names = CollectionUtil.convert(areaResults, ur -> Optional.ofNullable(ur).map(AreaResult::getName).orElse(null));
                        return names;
                    }
                    if (area.onlyNodeIds()) {
                        List<List> nodeIdsList = CollectionUtil.convert(areaResults, ur -> Optional.ofNullable(ur).map(AreaResult::getNodeIds).orElse(null));
                        return nodeIdsList;
                    }
                    List<Map> maps = CollectionUtil.convert(areaResults, ur -> this.maskRoute((AreaResult)ur).apply((AreaResult)ur));
                    return maps;
                }
            }
        }
        catch (Exception e) {
            return value;
        }
        return value;
    }

    private Object resolveResource(Long id, Area area) {
        if (id == null) {
            return null;
        }
        AreaResult areaResult = this.getResultById(id);
        if (areaResult == null) {
            return null;
        }
        if (area.onlyName()) {
            return areaResult.getName();
        }
        if (area.onlyFullPathName()) {
            return areaResult.getFullPathName();
        }
        if (area.onlyNodeIds()) {
            return areaResult.getNodeIds();
        }
        return this.maskRoute(areaResult).apply(areaResult);
    }

    private AreaResult getResultById(Long id) {
        if (id == null) {
            return null;
        }
        Map resultMap = (Map)WebUtil.getRequest().getAttribute("AREA_RESULTS");
        return (AreaResult)resultMap.get(id);
    }

    private List<AreaResult> getResultByIds(List<Long> ids) {
        if (ids == null) {
            return Collections.emptyList();
        }
        Map resultMap = (Map)WebUtil.getRequest().getAttribute("AREA_RESULTS");
        List<AreaResult> results = ids.stream().map(resultMap::get).collect(Collectors.toList());
        return results;
    }

    private Function<AreaResult, Map<String, Object>> maskRoute(AreaResult areaResult) {
        return this::maskArea;
    }

    private Map<String, Object> maskArea(AreaResult areaResult) {
        if (areaResult == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        if (areaResult.getId() != null) {
            map.put("id", areaResult.getId().toString());
        }
        map.put("name", areaResult.getName());
        map.put("code", areaResult.getCode());
        map.put("filename", areaResult.getFullPathName());
        map.put("nodeIds", CollectionUtil.isEmpty(areaResult.getNodeIds()) ? CollectionUtil.newArrayList((Object[])new Object[0]) : areaResult.getNodeIds());
        return map;
    }
}

