/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.area.resolve;

import cn.hutool.core.collection.ConcurrentHashSet;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.TypeUtil;
import com.jeecms.kit.JcResult;
import com.jeecms.lang.JeePage;
import com.jeecms.utils.CollectionUtil;
import com.jeecms.utils.ReflectUtil;
import com.jeecms.utils.area.AreaUtil;
import com.jeecms.utils.area.operator.AreaResult;
import com.jeecms.utils.area.resolve.Area;
import com.jeecms.utils.spring.WebUtil;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Page;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@RestControllerAdvice
public class AreaAdvice
implements ResponseBodyAdvice<Object> {
    private static final Set<Class> BASIC_CLASS_SET = new HashSet<Class>(Arrays.asList(Integer.TYPE, Integer.class, Byte.TYPE, Byte.class, Float.TYPE, Float.class, Double.TYPE, Double.class, Character.TYPE, Character.class, Short.TYPE, Short.class, Boolean.TYPE, Boolean.class, Long.TYPE, Long.class, String.class, Date.class, LocalDateTime.class, LocalDate.class, LocalTime.class, BigInteger.class, BigDecimal.class));
    private final Map<Class, Map<Field, Area>> areaVoMap = new ConcurrentHashMap<Class, Map<Field, Area>>();
    private final Set<String> containAreaApi = new ConcurrentHashSet();
    private final Set<String> rejectAreaApi = new ConcurrentHashSet();
    private final Map<Field, Area> placeholderMap = new HashMap<Field, Area>();
    private static final String BASE_PACKAGE = "com.jeecms";

    public boolean supports(MethodParameter returnType, Class converterType) {
        boolean support;
        String genericString = returnType.getMethod().toGenericString();
        if (this.rejectAreaApi.contains(genericString)) {
            return false;
        }
        if (this.containAreaApi.contains(genericString)) {
            return true;
        }
        Class parameterType = returnType.getParameterType();
        if (!parameterType.getName().startsWith(BASE_PACKAGE)) {
            this.rejectAreaApi.add(genericString);
            return false;
        }
        Class<?> objClass = this.findObjClass(returnType.getParameterType(), returnType.getGenericParameterType());
        if (objClass == null) {
            this.rejectAreaApi.add(genericString);
            return false;
        }
        Map<Field, Area> fieldMap = this.areaVoMap.get(objClass);
        if (fieldMap == null) {
            this.findResAnnotation(objClass);
            fieldMap = this.areaVoMap.get(objClass);
        }
        boolean bl = support = !fieldMap.isEmpty();
        if (support) {
            this.containAreaApi.add(genericString);
        } else {
            this.rejectAreaApi.add(genericString);
        }
        return support;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        this.cacheUploadResult(body);
        return body;
    }

    private Class<?> findObjClass(Class<?> cls, Type type) {
        ParameterizedType genericParameterType;
        Object[] actualTypeArguments;
        if (cls == JcResult.class && type instanceof ParameterizedType && ArrayUtil.isNotEmpty((Object[])(actualTypeArguments = (genericParameterType = (ParameterizedType)type).getActualTypeArguments()))) {
            type = actualTypeArguments[0];
            Class aClass = TypeUtil.getClass((Type)type);
            return this.findObjClass(aClass, (Type)type);
        }
        if (Page.class.isAssignableFrom(cls) && type instanceof ParameterizedType && ArrayUtil.isNotEmpty((Object[])(actualTypeArguments = (genericParameterType = (ParameterizedType)type).getActualTypeArguments()))) {
            type = actualTypeArguments[0];
            Class aClass = TypeUtil.getClass((Type)type);
            return this.findObjClass(aClass, (Type)type);
        }
        if (Collection.class.isAssignableFrom(cls) && type instanceof ParameterizedType && ArrayUtil.isNotEmpty((Object[])(actualTypeArguments = (genericParameterType = (ParameterizedType)type).getActualTypeArguments()))) {
            type = actualTypeArguments[0];
            Class aClass = TypeUtil.getClass((Type)type);
            return this.findObjClass(aClass, (Type)type);
        }
        if (Map.class.isAssignableFrom(cls) && type instanceof ParameterizedType && ArrayUtil.isNotEmpty((Object[])(actualTypeArguments = (genericParameterType = (ParameterizedType)type).getActualTypeArguments()))) {
            type = actualTypeArguments[1];
            Class aClass = TypeUtil.getClass((Type)type);
            return this.findObjClass(aClass, (Type)type);
        }
        return cls;
    }

    private void cacheUploadResult(Object obj) {
        ArrayList<Long> allAreaId = new ArrayList<Long>(this.collectAllResId(obj));
        List<Object> areaResults = CollectionUtil.isEmpty(allAreaId) ? Collections.emptyList() : AreaUtil.getAreaResult(allAreaId);
        Map<Long, AreaResult> map = areaResults.stream().collect(Collectors.toMap(AreaResult::getId, u -> u));
        WebUtil.getRequest().setAttribute("AREA_RESULTS", map);
    }

    private Set<Long> collectAllResId(Object obj) {
        if (obj == null) {
            return Collections.emptySet();
        }
        if (obj instanceof JcResult) {
            JcResult jcResult = (JcResult)obj;
            Object data = jcResult.getData();
            return this.collectAllResId(data);
        }
        if (obj instanceof Page) {
            Page page = (Page)obj;
            return this.collectAllResId(page.getContent());
        }
        if (obj instanceof JeePage) {
            JeePage page = (JeePage)obj;
            return this.collectAllResId(page.getContent());
        }
        HashSet<Long> resIds = new HashSet<Long>();
        if (obj instanceof Collection) {
            Collection coll = (Collection)obj;
            for (Object o : coll) {
                resIds.addAll(this.collectAllResId(o));
            }
            return resIds;
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            for (Map.Entry entry : map.entrySet()) {
                resIds.addAll(this.collectAllResId(entry.getValue()));
            }
            return resIds;
        }
        Map<Field, Area> fieldMap = this.areaVoMap.get(obj.getClass());
        for (Map.Entry<Field, Area> entry : fieldMap.entrySet()) {
            Field field = entry.getKey();
            Area resAnno = entry.getValue();
            Object value = ReflectUtil.getFieldValue(obj, field);
            if (resAnno == null) {
                resIds.addAll(this.collectAllResId(value));
                continue;
            }
            if (value instanceof Long) {
                resIds.add((Long)value);
                continue;
            }
            if (!(value instanceof List)) continue;
            List list = (List)value;
            resIds.addAll(list);
        }
        return resIds;
    }

    private void findResAnnotation(Class<?> objClass) {
        this.areaVoMap.put(objClass, this.placeholderMap);
        LinkedHashMap<Field, Area> map = new LinkedHashMap<Field, Area>();
        for (Field field : ReflectUtil.getFields(objClass)) {
            Class inlineVoClass;
            Type typeParameter;
            Type genericType;
            if (this.isResIdField(field)) {
                Area annotation = field.getAnnotation(Area.class);
                if (annotation == null) continue;
                map.put(field, annotation);
                continue;
            }
            if (this.isBasicType(field)) continue;
            if (Collection.class.isAssignableFrom(field.getType())) {
                genericType = field.getGenericType();
                if (!(genericType instanceof ParameterizedType) || (typeParameter = this.getGenericType((ParameterizedType)genericType, 0)) == null) continue;
                inlineVoClass = TypeUtil.getClass((Type)typeParameter);
                if (!this.areaVoMap.containsKey(inlineVoClass)) {
                    this.findResAnnotation(inlineVoClass);
                }
                if (this.areaVoMap.get(inlineVoClass).isEmpty()) continue;
                map.put(field, null);
                continue;
            }
            if (Map.class.isAssignableFrom(field.getType())) {
                genericType = field.getGenericType();
                if (!(genericType instanceof ParameterizedType) || (typeParameter = this.getGenericType((ParameterizedType)genericType, 1)) == null) continue;
                inlineVoClass = TypeUtil.getClass((Type)typeParameter);
                if (!this.areaVoMap.containsKey(inlineVoClass)) {
                    this.findResAnnotation(inlineVoClass);
                }
                if (this.areaVoMap.get(inlineVoClass).isEmpty()) continue;
                map.put(field, null);
                continue;
            }
            if (field.getType().isArray()) continue;
            Class<?> inlineVoClass2 = field.getType();
            if (!this.areaVoMap.containsKey(inlineVoClass2)) {
                this.findResAnnotation(inlineVoClass2);
            }
            if (this.areaVoMap.get(inlineVoClass2).isEmpty()) continue;
            map.put(field, null);
        }
        this.areaVoMap.put(objClass, map.isEmpty() ? Collections.emptyMap() : map);
    }

    private boolean isBasicType(Field field) {
        return BASIC_CLASS_SET.contains(field.getType()) || field.getType().isEnum();
    }

    private boolean isResIdField(Field field) {
        ParameterizedType genericParameterType;
        Object[] actualTypeArguments;
        Object type;
        Class<?> cls = field.getType();
        if (cls == Long.class || cls == Long.TYPE) {
            return true;
        }
        if (List.class.isAssignableFrom(field.getType()) && (type = field.getGenericType()) instanceof ParameterizedType && ArrayUtil.isNotEmpty((Object[])(actualTypeArguments = (genericParameterType = (ParameterizedType)type).getActualTypeArguments()))) {
            type = actualTypeArguments[0];
            return Long.class == TypeUtil.getClass((Type)type);
        }
        return false;
    }

    private Type getGenericType(ParameterizedType type, int idx) {
        Object[] actualTypeArguments = type.getActualTypeArguments();
        if (ArrayUtil.isNotEmpty((Object[])actualTypeArguments) && idx < actualTypeArguments.length) {
            return actualTypeArguments[idx];
        }
        return null;
    }
}

