/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.area.operator;

import com.alibaba.fastjson.JSONObject;
import com.jeecms.kit.JcResult;
import com.jeecms.utils.CollectionUtil;
import com.jeecms.utils.JcEncryptUtil;
import com.jeecms.utils.area.AreaConfig;
import com.jeecms.utils.area.endpoint.GetAreaResultDTO;
import com.jeecms.utils.area.operator.AreaOperator;
import com.jeecms.utils.area.operator.AreaResult;
import com.jeecms.utils.area.store.IAreaStore;
import com.jeecms.utils.spring.WebUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class AbstractRemoteAreaOperator
implements AreaOperator {
    private static final Logger log = LoggerFactory.getLogger(AbstractRemoteAreaOperator.class);

    protected abstract String getAreaResultUrl();

    protected abstract RestTemplate getRestTemplate();

    public AreaResult getAreaResult(Serializable mark) {
        if (mark == null) {
            return null;
        }
        List<AreaResult> areaResults = this.getAreaResults(Collections.singletonList(mark));
        if (CollectionUtil.isEmpty(areaResults)) {
            return AreaResult.EmptyAreaResult();
        }
        return areaResults.get(0);
    }

    public List<AreaResult> getAreaResults(List<? extends Serializable> marks) {
        IAreaStore areaStore = AreaConfig.getInstance().getAreaStore();
        if (areaStore != null) {
            return areaStore.getUploadResults(marks);
        }
        return this.getRemoteAreaResults(marks);
    }

    public List<AreaResult> getRemoteAreaResults(List<? extends Serializable> marks) {
        if (CollectionUtil.isEmpty(marks)) {
            return Collections.emptyList();
        }
        String url = this.getAreaResultUrl();
        HttpHeaders headers = this.getDefaultHeader(url);
        headers.set("Content-Type", "application/json;charset=UTF-8");
        headers.set("Feign-Request", "feign");
        GetAreaResultDTO getAreaResultDTO = new GetAreaResultDTO();
        getAreaResultDTO.setMarks(marks);
        log.info("\u53c2\u6570 ");
        HttpEntity requestEntity = new HttpEntity((Object)JSONObject.toJSONString((Object)getAreaResultDTO), (MultiValueMap)headers);
        ResponseEntity resEntity = this.getRestTemplate().exchange(url, HttpMethod.POST, requestEntity, JcResult.class, new Object[0]);
        JcResult jcResult = (JcResult)resEntity.getBody();
        log.debug("\u67e5\u8be2Infra: \u53c2\u6570:{}  \u7ed3\u679c:{}", (Object)getAreaResultDTO, (Object)jcResult);
        if (!jcResult.success()) {
            throw new RuntimeException(jcResult.getMessage());
        }
        List maps = (List)jcResult.getData();
        List<AreaResult> areaResults = this.convertMapsToResults(maps);
        return areaResults;
    }

    private HttpHeaders getDefaultHeader(String url) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("remote-auth-token", this.getRemoteAuth(url));
        headers.add("Referer", this.getReferer());
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes != null) {
            HttpServletRequest request = attributes.getRequest();
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                headers.add(headerName, request.getHeader(headerName));
            }
        }
        return headers;
    }

    private String getRemoteAuth(String url) {
        String auth = StringUtils.reverse((String)JcEncryptUtil.encrypt("tauthr", url));
        return auth;
    }

    private String getReferer() {
        try {
            return WebUtil.currReferer();
        }
        catch (Exception e) {
            return "";
        }
    }

    private List<AreaResult> convertMapsToResults(List<Map<String, Object>> maps) {
        List<AreaResult> results = maps.stream().map(m -> {
            Object nodeIds;
            String fullPathName;
            String code;
            String name;
            AreaResult areaResult = new AreaResult();
            String id = m.get("id").toString();
            if (StringUtils.isNotBlank((CharSequence)id)) {
                areaResult.setId(Long.parseLong(id));
            }
            if (StringUtils.isNotBlank((CharSequence)(name = (String)m.get("name")))) {
                areaResult.setName(name);
            }
            if (StringUtils.isNotBlank((CharSequence)(code = (String)m.get("code")))) {
                areaResult.setCode(code);
            }
            if (StringUtils.isNotBlank((CharSequence)(fullPathName = (String)m.get("fullPathName")))) {
                areaResult.setFullPathName(fullPathName);
            }
            if ((nodeIds = m.get("nodeIds")) != null && nodeIds instanceof Collection) {
                areaResult.setNodeIds((List)nodeIds);
            }
            return areaResult;
        }).collect(Collectors.toList());
        return results;
    }
}

