/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.area.endpoint;

import com.jeecms.kit.JcResult;
import com.jeecms.utils.CollectionUtil;
import com.jeecms.utils.JcEncryptUtil;
import com.jeecms.utils.area.AreaUtil;
import com.jeecms.utils.area.endpoint.GetAreaResultDTO;
import com.jeecms.utils.area.operator.AreaResult;
import com.jeecms.utils.spring.SpringUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@ApiIgnore
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@RestController
public class AreaQueryEndpoint {
    private static final Logger log = LoggerFactory.getLogger(AreaQueryEndpoint.class);

    @PostMapping(value={"/innerArea/detail"})
    public JcResult<List<AreaResult>> getUploadResult(HttpServletRequest request, HttpServletResponse response, @RequestBody @Valid GetAreaResultDTO dto) throws IOException {
        long t3 = System.currentTimeMillis();
        if (!AreaQueryEndpoint.check(request, response)) {
            return JcResult.ok();
        }
        if (CollectionUtil.isEmpty(dto.getMarks())) {
            return JcResult.ok(Collections.emptyList());
        }
        AreaQueryEndpoint.fixMarks(dto.getMarks());
        log.debug("\u67e5\u8be2\u533a\u57df\uff1a{}", (Object)dto);
        List<AreaResult> areaResult = AreaUtil.getAreaResult(dto.getMarks());
        log.debug("\u67e5\u8be2\u7ed3\u679c\uff1a{}", areaResult);
        long t4 = System.currentTimeMillis();
        System.out.println("t4-t3->" + (t4 - t3));
        return JcResult.ok(areaResult);
    }

    private static boolean check(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String authToken = request.getHeader("remote-auth-token");
        String requestUrl = request.getRequestURL().toString();
        String requestUtl2 = requestUrl.replaceAll("//(.*?)/", "//" + SpringUtil.getApplicationName() + "/");
        try {
            String decrypt = JcEncryptUtil.decrypt("tauthr", StringUtils.reverse((String)authToken));
            if (requestUrl.equalsIgnoreCase(decrypt) || requestUtl2.equalsIgnoreCase(decrypt)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        response.sendError(HttpStatus.NOT_FOUND.value());
        return false;
    }

    private static void fixMarks(List<? extends Serializable> marks) {
        List<? extends Serializable> ms = marks;
        for (int i = 0; i < ms.size(); ++i) {
            Serializable serializable = ms.get(i);
            if (!(serializable instanceof Number) || serializable instanceof Long) continue;
            Number number = (Number)serializable;
            ms.set(i, (Serializable)number.longValue());
        }
    }
}

