/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.area;

import cn.hutool.core.util.ArrayUtil;
import com.jeecms.utils.CollectionUtil;
import com.jeecms.utils.area.AreaConfig;
import com.jeecms.utils.area.operator.AbstractRemoteAreaOperator;
import com.jeecms.utils.area.operator.AreaOperator;
import com.jeecms.utils.area.operator.AreaResult;
import com.jeecms.utils.area.operator.RPCAreaOperator;
import com.jeecms.utils.area.store.IAreaStore;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class AreaUtil {
    public static AreaResult getAreaResult(Serializable mark) {
        if (mark == null) {
            return null;
        }
        AreaConfig config = AreaConfig.getInstance();
        AreaOperator areaOperator = config.getAreaOperator();
        if (areaOperator instanceof RPCAreaOperator) {
            AreaResult areaResult = ((AbstractRemoteAreaOperator)areaOperator).getAreaResult(mark);
            return areaResult;
        }
        IAreaStore areaStore = config.getAreaStore();
        if (mark instanceof Long) {
            Long id = (Long)mark;
            return areaStore.getAreaResultById(id);
        }
        return AreaResult.EmptyAreaResult();
    }

    public static List<AreaResult> getAreaResult(Serializable ... marks) {
        if (ArrayUtil.isEmpty((Object[])marks)) {
            return Collections.emptyList();
        }
        return AreaUtil.getAreaResult(Arrays.asList(marks));
    }

    public static List<AreaResult> getAreaResult(List<? extends Serializable> marks) {
        if (CollectionUtil.isEmpty(marks)) {
            return Collections.emptyList();
        }
        AreaConfig config = AreaConfig.getInstance();
        AreaOperator areaOperator = config.getAreaOperator();
        if (areaOperator instanceof RPCAreaOperator) {
            List<AreaResult> areaResults = ((AbstractRemoteAreaOperator)areaOperator).getAreaResults(marks);
            return areaResults;
        }
        IAreaStore areaStore = config.getAreaStore();
        return areaStore.getUploadResults(marks);
    }
}

