/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.area;

import com.jeecms.utils.area.operator.AreaOperator;
import com.jeecms.utils.area.operator.RPCAreaOperator;
import com.jeecms.utils.area.store.IAreaStore;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.context.annotation.Lazy;

public class AreaConfig {
    public static final Integer QUERY_STRATEGY_DEFAULT = 1;
    public static final Integer QUERY_STRATEGY_RPC = 2;
    public static final Integer QUERY_STRATEGY_REMOTE = 3;
    private static volatile Object config;
    private static Supplier<AreaConfig> configSupplier;
    private IAreaStore areaStore;
    private Integer queryStrategy = QUERY_STRATEGY_DEFAULT;
    @NestedConfigurationProperty
    private RPCConfig rpc = new RPCConfig();

    public static void setConfigSupplier(Supplier<AreaConfig> configSupplier) {
        AreaConfig.configSupplier = configSupplier;
    }

    @Lazy
    @Autowired
    public void setConfig(AreaConfig config) {
        AreaConfig.config = config;
    }

    public static AreaConfig getInstance() {
        return configSupplier.get();
    }

    public IAreaStore getAreaStore() {
        return this.areaStore;
    }

    public void setAreaStore(IAreaStore areaStore) {
        this.areaStore = areaStore;
    }

    public RPCConfig getRpc() {
        return this.rpc;
    }

    public void setRpc(RPCConfig rpc) {
        this.rpc = rpc;
    }

    public Integer getQueryStrategy() {
        return this.queryStrategy;
    }

    public void setQueryStrategy(Integer queryStrategy) {
        this.queryStrategy = queryStrategy;
    }

    public String toString() {
        return "AreaConfig{areaStore=" + this.areaStore + '}';
    }

    public AreaOperator getAreaOperator() {
        Integer queryStrategy = AreaConfig.getInstance().getQueryStrategy();
        if (queryStrategy.equals(QUERY_STRATEGY_RPC)) {
            return new RPCAreaOperator();
        }
        return null;
    }

    static {
        configSupplier = () -> {
            if (config != null) return (AreaConfig)config;
            Class<AreaConfig> clazz = AreaConfig.class;
            synchronized (AreaConfig.class) {
                if (config != null) return (AreaConfig)config;
                config = new AreaConfig();
                // ** MonitorExit[var0] (shouldn't be in output)
                return (AreaConfig)config;
            }
        };
    }

    public static class RPCConfig {
        private String serviceId;

        public String getServiceId() {
            return this.serviceId;
        }

        public void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }
    }
}

