/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils;

import cn.hutool.core.util.ReUtil;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XssUtil {
    static Logger logger = LoggerFactory.getLogger(XssUtil.class);
    static Pattern scriptPattern = Pattern.compile("<script>(.*?)</script>", 2);
    static Pattern scriptPatternSrc = Pattern.compile("src=\"(.*?)", 2);
    static Pattern scriptPatternHref = Pattern.compile("href=\"(.*?)", 2);
    static Pattern singleScriptPattern = Pattern.compile("</script>", 2);
    static Pattern singleBeginScriptPattern = Pattern.compile("<script(.*?)>", 42);
    static Pattern singleBeginIframePattern = Pattern.compile("(.*?)<iframe(.*?)>", 42);
    static Pattern criptPattern = Pattern.compile("eval\\((.*?)\\)", 42);
    static Pattern expressionPattern = Pattern.compile("expression\\((.*?)\\)", 42);
    static Pattern javascriptPattern = Pattern.compile("javascript:", 2);
    static Pattern alertPattern = Pattern.compile("(.*?)alert(.*?)", 2);
    static Pattern importPattern = Pattern.compile("(.*?)import(.*?)", 2);
    static Pattern functionPattern = Pattern.compile("(.*?)function(.*?)", 2);
    static Pattern vbscriptPattern = Pattern.compile("vbscript:", 2);
    static Pattern onScriptPattern = Pattern.compile("on(.*?)=['|\"](.*?)['|\"]", 42);
    static Set<String> rechTextClasses = new HashSet<String>();

    public static void main(String[] args) {
        byte[] bytes = new byte[]{99, 111, 109, 46, 106, 101, 101, 99, 109, 115, 46, 117, 116, 105, 108, 115, 46, 82, 101, 102, 108, 101, 99, 116, 85, 116, 105, 108};
        String mes = new String(bytes);
        String ma = "ClassLoader";
        byte[] b1 = ma.getBytes();
        System.out.println(mes);
    }

    public static Set<String> getRechTextClassNames() {
        return rechTextClasses;
    }

    public static boolean isRechTextClass(String className) {
        if (StringUtils.isBlank((CharSequence)className)) {
            return false;
        }
        for (String r : rechTextClasses) {
            if (!className.endsWith(r)) continue;
            return true;
        }
        return false;
    }

    public static String cleanXSS(String className, String value) {
        if (XssUtil.isRechTextClass(className)) {
            return value;
        }
        return XssUtil.cleanXSS(value);
    }

    public static String cleanXSS(String value) {
        if (value != null) {
            value = scriptPattern.matcher(value).replaceAll("");
            value = scriptPatternSrc.matcher(value).replaceAll("");
            value = scriptPatternHref.matcher(value).replaceAll("");
            value = singleScriptPattern.matcher(value).replaceAll("");
            value = singleBeginScriptPattern.matcher(value).replaceAll("");
            value = singleBeginIframePattern.matcher(value).replaceAll("");
            value = criptPattern.matcher(value).replaceAll("");
            value = expressionPattern.matcher(value).replaceAll("");
            value = javascriptPattern.matcher(value).replaceAll("");
            value = alertPattern.matcher(value).replaceAll("");
            value = importPattern.matcher(value).replaceAll("");
            value = functionPattern.matcher(value).replaceAll("");
            value = vbscriptPattern.matcher(value).replaceAll("");
            if ((value = onScriptPattern.matcher(value).replaceAll("")).contains("%df") || value.contains("%22") || value.contains("%3E") || value.contains("%3e") || value.contains("%3C") || value.contains("%3c") || value.contains("<") || value.contains(">") || value.contains("\"") || value.contains("'") || value.contains(" and ") || value.contains(" or ") || value.contains("1=1") || value.contains("(") || value.contains(")")) {
                value.replace("%df", "");
                value.replace("%22", "");
                value.replace("%3E", "");
                value.replace("%3e", "");
                value.replace("%3C", "");
                value.replace("%3c", "");
                value.replace("<", "");
                value.replace(">", "");
                value.replace("'", "");
                value.replace(" and ", "");
                value.replace(" or ", "");
                value.replace("1=1", "");
                value.replace("(", "");
                value.replace(")", "");
            }
        }
        return value;
    }

    public static boolean containXss(String value) {
        if (value != null) {
            if (ReUtil.isMatch((String)scriptPattern.pattern(), (CharSequence)value)) {
                return true;
            }
            if (ReUtil.isMatch((String)scriptPatternSrc.pattern(), (CharSequence)value)) {
                return true;
            }
            if (ReUtil.isMatch((String)scriptPatternHref.pattern(), (CharSequence)value)) {
                return true;
            }
            if (ReUtil.isMatch((String)singleScriptPattern.pattern(), (CharSequence)value)) {
                return true;
            }
            if (ReUtil.isMatch((String)singleBeginScriptPattern.pattern(), (CharSequence)value)) {
                return true;
            }
            if (ReUtil.isMatch((String)singleBeginIframePattern.pattern(), (CharSequence)value)) {
                return true;
            }
            if (ReUtil.isMatch((String)criptPattern.pattern(), (CharSequence)value)) {
                return true;
            }
            if (ReUtil.isMatch((String)expressionPattern.pattern(), (CharSequence)value)) {
                return true;
            }
            if (ReUtil.isMatch((String)javascriptPattern.pattern(), (CharSequence)value)) {
                return true;
            }
            if (ReUtil.isMatch((String)alertPattern.pattern(), (CharSequence)value)) {
                return true;
            }
            if (ReUtil.isMatch((String)importPattern.pattern(), (CharSequence)value)) {
                return true;
            }
            if (ReUtil.isMatch((String)functionPattern.pattern(), (CharSequence)value)) {
                return true;
            }
            if (ReUtil.isMatch((String)vbscriptPattern.pattern(), (CharSequence)value)) {
                return true;
            }
            if (ReUtil.isMatch((String)onScriptPattern.pattern(), (CharSequence)value)) {
                return true;
            }
            if (value.contains("%df") || value.contains("%22") || value.contains("%3E") || value.contains("%3e") || value.contains("%3C") || value.contains("%3c") || value.contains(" and ") || value.contains(" or ") || value.contains("1=1")) {
                return true;
            }
        }
        return false;
    }

    static {
        rechTextClasses.add("Article");
        rechTextClasses.add("ProductTxt");
        rechTextClasses.add("ProductDTO");
    }
}

