/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils;

import cn.hutool.core.io.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.LinkedHashSet;
import java.util.function.Consumer;
import java.util.logging.Level;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverUtil {
    private static final Logger log;
    private static WebDriver driver;
    private static String ORIGIN_WINDOW_HANDLE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <X> X screenshot(String url, By by, OutputType<X> target, Consumer<WebDriver> consumer) {
        Class<WebDriverUtil> clazz = WebDriverUtil.class;
        synchronized (WebDriverUtil.class) {
            WebDriver driver = WebDriverUtil.get(url);
            LinkedHashSet windowHandles = (LinkedHashSet)driver.getWindowHandles();
            driver.switchTo().window(windowHandles.toArray(new String[windowHandles.size()])[1]);
            consumer.accept(driver);
            TakesScreenshot ts = by == null ? (TakesScreenshot)driver : driver.findElement(by);
            X x = WebDriverUtil.takeScreenshot(ts, target);
            driver.close();
            driver.switchTo().window(ORIGIN_WINDOW_HANDLE);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return x;
        }
    }

    private static <X> X screenshot(String url, OutputType<X> target, Consumer<WebDriver> consumer) {
        return WebDriverUtil.screenshot(url, null, target, consumer);
    }

    public static <X> X screenshot(String url, By by, OutputType<X> target) {
        return WebDriverUtil.screenshot(url, by, target, WebDriverUtil::screen1920x1080);
    }

    public static <X> X screenshotFull(String url, OutputType<X> target) {
        return WebDriverUtil.screenshot(url, target, WebDriverUtil::scrollMax);
    }

    public static <X> X screenshot(String url, OutputType<X> target) {
        return WebDriverUtil.screenshot(url, target, WebDriverUtil::screen1920x1080);
    }

    private static <X> X takeScreenshot(TakesScreenshot takesScreenshot, OutputType<X> target) {
        OutputType<X> ot = target == OutputType.FILE ? OutputType.BYTES : target;
        Object obj = takesScreenshot.getScreenshotAs(ot);
        return (X)(target == OutputType.FILE ? FileUtil.writeFromStream((InputStream)new ByteArrayInputStream((byte[])obj), (File)FileUtil.createTempFile((String)"webdriver", (String)".jpg", (File)FileUtil.getTmpDir(), (boolean)true)) : obj);
    }

    private static WebDriver get(String url) {
        JavascriptExecutor js = (JavascriptExecutor)driver;
        js.executeScript("window.open('" + url + "')", new Object[0]);
        return driver;
    }

    public static void quit() {
        log.debug("\u9000\u51faWebDriver");
        driver.quit();
    }

    private static void scrollMax(WebDriver driver) {
        JavascriptExecutor js = (JavascriptExecutor)driver;
        long scrollHeight = (Long)js.executeScript("return document.body.parentNode.scrollHeight", new Object[0]);
        driver.manage().window().setSize(new Dimension(1920, (int)scrollHeight));
    }

    private static void screen1920x1080(WebDriver driver) {
        driver.manage().window().setSize(new Dimension(1920, 1080));
    }

    private static void doNothing(WebDriver driver) {
    }

    static {
        block2: {
            log = LoggerFactory.getLogger(WebDriverUtil.class);
            try {
                ChromeOptions options = new ChromeOptions();
                options.addArguments(new String[]{"--headless"});
                options.addArguments(new String[]{"--disable-gpu"});
                System.setProperty("webdriver.chrome.silentOutput", "true");
                java.util.logging.Logger.getLogger("org.openqa.selenium").setLevel(Level.OFF);
                driver = new ChromeDriver(options);
                ORIGIN_WINDOW_HANDLE = driver.getWindowHandle();
                Runtime.getRuntime().addShutdownHook(new Thread(WebDriverUtil::quit));
            }
            catch (Throwable t) {
                log.error("\u6253\u5f00ChromeDriver\u5931\u8d25", t);
                if (driver == null) break block2;
                driver.quit();
            }
        }
    }
}

